/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.jface;

import java.io.File;
import java.io.FileFilter;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.unitarou.io.Ios;
import org.unitarou.jface.FileAnnotationLabelProvider;
import org.unitarou.jface.FileFolderListener;
import org.unitarou.jface.FileListContentProvider;
import org.unitarou.ml.MessageResource;
import org.unitarou.swt.WidgetContainer;
import org.unitarou.util.ArgumentChecker;

public class FilesTableViewer
implements WidgetContainer {
    private static final MessageResource LB_FILENAME = new MessageResource(FilesTableViewer.class, "lbFilename");
    private File folder_;
    private final int tvFlag_;
    private TableViewer tableViewer_;
    private FileFilter fileFilter_;
    private final Set<FileFolderListener> listeners_;
    static /* synthetic */ Class class$0;

    public FilesTableViewer() {
        this(67588);
    }

    public FilesTableViewer(int swtFlag) {
        this.tvFlag_ = swtFlag;
        this.folder_ = Ios.getCurrentDirectory();
        this.tableViewer_ = null;
        this.fileFilter_ = TrueFileFilter.INSTANCE;
        this.listeners_ = new HashSet<FileFolderListener>();
    }

    public Control createContents(Composite parent) {
        ArgumentChecker.throwIfNull((Object)parent);
        this.tableViewer_ = new TableViewer(parent, this.tvFlag_);
        Table table = this.tableViewer_.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn column = new TableColumn(table, 0);
        column.setText(LB_FILENAME.get());
        column.setWidth(200);
        this.tableViewer_.setContentProvider(new FileListContentProvider());
        this.tableViewer_.setLabelProvider(new FileAnnotationLabelProvider());
        this.tableViewer_.addFilter(new ViewerFilterImpl());
        this.tableViewer_.setSorter(new ViewerSorterImpl());
        this.tableViewer_.setInput(this.folder_);
        TableViewersListener listener = new TableViewersListener();
        this.tableViewer_.addPostSelectionChangedListener(listener);
        this.tableViewer_.addDoubleClickListener(listener);
        return this.tableViewer_.getControl();
    }

    public void dispose() {
    }

    public File getFolder() {
        return this.folder_;
    }

    public void setFolder(File folder) {
        ArgumentChecker.throwIfNull((Object)folder);
        if (!folder.isDirectory()) {
            throw new IllegalArgumentException("Parameter 'folder' must be a directory: " + folder.getPath());
        }
        this.folder_ = folder;
        if (this.tableViewer_ != null) {
            this.tableViewer_.setInput(this.folder_);
        }
    }

    public void setFileFilter(FileFilter fileFilter) {
        ArgumentChecker.throwIfNull((Object)fileFilter);
        this.fileFilter_ = fileFilter;
        this.tableViewer_.refresh();
    }

    public void addListener(FileFolderListener listener) {
        if (listener == null) {
            return;
        }
        this.listeners_.add(listener);
    }

    public void removeListener(FileFolderListener listener) {
        this.listeners_.remove(listener);
    }

    private class TableViewersListener
    implements ISelectionChangedListener,
    IDoubleClickListener {
        TableViewersListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            Object[] objs = ((IStructuredSelection)event.getSelection()).toArray();
            if (objs == null) {
                objs = new Object[]{};
            }
            File[] files = new File[objs.length];
            System.arraycopy(objs, 0, files, 0, files.length);
            for (FileFolderListener listener : FilesTableViewer.this.listeners_) {
                listener.filesFocused(files);
            }
        }

        public void doubleClick(DoubleClickEvent event) {
            File file = (File)((IStructuredSelection)event.getSelection()).getFirstElement();
            if (file.isDirectory()) {
                for (FileFolderListener listener : FilesTableViewer.this.listeners_) {
                    listener.folderChanged(file);
                }
                FilesTableViewer.this.folder_ = file;
                return;
            }
            for (FileFolderListener listener : FilesTableViewer.this.listeners_) {
                listener.filesDoubleClicked(file);
            }
        }
    }

    private class ViewerFilterImpl
    extends ViewerFilter {
        ViewerFilterImpl() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof File) {
                File file = (File)element;
                return file.isDirectory() || FilesTableViewer.this.fileFilter_.accept(file);
            }
            return false;
        }
    }

    private class ViewerSorterImpl
    extends ViewerSorter {
        ViewerSorterImpl() {
        }

        public int category(Object element) {
            if (element instanceof File) {
                File file = (File)element;
                return file.isDirectory() ? 0 : 1;
            }
            return super.category(element);
        }
    }
}

