/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.cmd;

import java.util.ArrayList;
import java.util.LinkedList;
import org.unitarou.cmd.Command;
import org.unitarou.cmd.CommandDriverListener;
import org.unitarou.lang.NameDisplayable;
import org.unitarou.util.ArgumentChecker;

public class CommandDriver {
    private final LinkedList<Command> executedCommands_ = new LinkedList();
    private final LinkedList<Command> undoneCommands_ = new LinkedList();
    private final ArrayList<CommandDriverListener> listeners_ = new ArrayList();
    private Status status_ = new Status();

    public void clear() {
        this.clearUndo();
        this.clearRedo();
    }

    public void clearUndo() {
        this.executedCommands_.clear();
    }

    public void clearRedo() {
        this.undoneCommands_.clear();
    }

    public Status getStatus() {
        return this.status_;
    }

    public Status execute(Command command) {
        ArgumentChecker.throwIfNull((Object)command);
        command.execute();
        this.executedCommands_.addLast(command);
        this.undoneCommands_.clear();
        for (CommandDriverListener listener : this.listeners_) {
            listener.executed(command);
        }
        this.status_.executedCommand_ = command;
        return this.status_;
    }

    public Status redo() {
        Command command = this.undoneCommands_.removeFirst();
        command.execute();
        this.executedCommands_.addLast(command);
        for (CommandDriverListener listener : this.listeners_) {
            listener.redoExecuted(command);
        }
        this.status_.executedCommand_ = command;
        return this.status_;
    }

    public Status undo() {
        Command command = this.executedCommands_.removeLast();
        command.undo();
        this.undoneCommands_.addFirst(command);
        for (CommandDriverListener listener : this.listeners_) {
            listener.undoExecuted(command);
        }
        this.status_.executedCommand_ = command;
        return this.status_;
    }

    public void addListener(CommandDriverListener listener) {
        if (listener == null) {
            return;
        }
        this.listeners_.add(listener);
    }

    public void removeListener(CommandDriverListener listener) {
        this.listeners_.remove(listener);
    }

    public class Status {
        private Command executedCommand_;

        private Status() {
        }

        public Command getExecutedCommand() {
            return this.executedCommand_;
        }

        public String getRedoName() {
            if (this.isRedoable() && CommandDriver.this.undoneCommands_.getFirst() instanceof NameDisplayable) {
                NameDisplayable command = (NameDisplayable)CommandDriver.this.undoneCommands_.getFirst();
                return command.displayName();
            }
            return "";
        }

        public String getUndoName() {
            if (this.isUndoable() && CommandDriver.this.executedCommands_.getLast() instanceof NameDisplayable) {
                NameDisplayable command = (NameDisplayable)CommandDriver.this.executedCommands_.getLast();
                return command.displayName();
            }
            return "";
        }

        public boolean isUndoable() {
            return !CommandDriver.this.executedCommands_.isEmpty();
        }

        public boolean isRedoable() {
            return !CommandDriver.this.undoneCommands_.isEmpty();
        }
    }
}

