/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.AbstractListViewer;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.List;

public class ListViewer
extends AbstractListViewer {
    private List list;

    public ListViewer(Composite parent) {
        this(parent, 2818);
    }

    public ListViewer(Composite parent, int style) {
        this(new List(parent, style));
    }

    public ListViewer(List list) {
        this.list = list;
        this.hookControl(list);
    }

    public Control getControl() {
        return this.list;
    }

    public List getList() {
        return this.list;
    }

    public void reveal(Object element) {
        Assert.isNotNull(element);
        int index = this.getElementIndex(element);
        if (index == -1) {
            return;
        }
        int count = this.list.getItemCount();
        if (count == 0) {
            return;
        }
        int height = this.list.getItemHeight();
        Rectangle rect = this.list.getClientArea();
        int topIndex = this.list.getTopIndex();
        int visibleCount = Math.max((rect.x + rect.height) / height, 1);
        int bottomIndex = Math.min(topIndex + visibleCount + 1, count - 1);
        if (topIndex <= index && index <= bottomIndex) {
            return;
        }
        int newTop = Math.min(Math.max(index - visibleCount / 2, 0), count - 1);
        this.list.setTopIndex(newTop);
    }

    protected void listAdd(String string, int index) {
        this.list.add(string, index);
    }

    protected void listSetItem(int index, String string) {
        this.list.setItem(index, string);
    }

    protected int[] listGetSelectionIndices() {
        return this.list.getSelectionIndices();
    }

    protected int listGetItemCount() {
        return this.list.getItemCount();
    }

    protected void listSetItems(String[] labels) {
        this.list.setItems(labels);
    }

    protected void listRemoveAll() {
        this.list.removeAll();
    }

    protected void listRemove(int index) {
        this.list.remove(index);
    }

    protected void listSetSelection(int[] ixs) {
        this.list.setSelection(ixs);
    }

    protected void listDeselectAll() {
        this.list.deselectAll();
    }

    protected void listShowSelection() {
        this.list.showSelection();
    }
}

