<?php
/*
 * 顼ơ֥ɽ饹
 * color.inc class Color
 * $Id: color.inc,v 1.1 2002/09/17 07:53:42 nanasess Exp $
*/

class Color {
  var $db_name = "myDB_Sql";
  var $include_path = ".";
  var $ColorTableName = "color";
  var $print_error = "ǡμ˼Ԥޤ";
  var $error_back = "<input type=\"submit\" value=\"\" onClick=\"javascript:history.go(-1)\">";

  /* ϥǡå */
  function CheckData($data) {
	  if (preg_match("/^[#a-zA-Z0-9]+$/", $data) == false) {
		print("Data Error!");
		print($this->error_back);
		return exit;
	  }
	  return true;
  }

  /* 顼 */
  function GetColorQuery($where = "") {
	$select = sprintf("SELECT * FROM %s %s", $this->ColorTableName, $where);
	return $select;
  }

  /* ̤˳Ǽ */
  function IntoColorArray() {
	$select = $this->GetColorQuery();
	$db = new $this->db_name;
	$result = $db->query($select);
	if ($result == false) {
	  print($this->print_error);
	  print($this->error_back);
	  $db->query("ROLLBACK");
	  return exit;
	}
	$list = array();
	while ($db->next_record()) {
	  $list[$db->f("color_name")] = $db->f("color_hex");
	}
	return $list;
  }

  /* 顼ꥹȼ */
  function GetColorList($colorList) {
	$list = "";
	foreach ($colorList as $key => $val) {
	  if ($_SESSION["bgcolor"] == $val || $_SESSION["text_color"] == $val) {
		$selected = "selected=\"selected\"";
	  } else {
		$selected = "";
	  }
	  $list .= sprintf("<option value=\"%s\" %s>%s</option>\n",
					   htmlspecialchars($val, ENT_QUOTES), 
					   $selected, 
					   htmlspecialchars($key, ENT_QUOTES));
	}
	return $list;
  }

  /* 顼ơ֥ */
  function GetColorTable($colorList) {
	$list = "";
	$count = count($colorList);
	$i = 0;
	$nKey = array();
	$nVal = array();
	foreach ($colorList as $key => $val) {
	  $i++;
	  $nKey[$i] = $key;
	  $nVal[$i] = $val;
	}
	$rows = (int)($count / 3); // Կ
	$div = $count % 3;
	if ($div > 0) {
	  $rows += 1;
	}
	$l = 0;
	$list = "";
	for ($j=0; $j < $rows; $j++) {
	  $list .= "<tr>\n";

	  for ($k=0; $k < 3; $k++) {
		$l++;
		if ($_GET["Type"] == "text") {
		  $list .= sprintf("<td><font color=\"%s\">%s</font></td>\n",
						   htmlspecialchars($nVal[$l], ENT_QUOTES),
						   htmlspecialchars($nKey[$l], ENT_QUOTES));
		} else {
		  $list .= sprintf("<td align=\"center\" bgcolor=\"%s\">%s</td>\n",
						 htmlspecialchars($nVal[$l], ENT_QUOTES), 
						 htmlspecialchars($nKey[$l], ENT_QUOTES));
		}
	  }

	  $list .= "</tr>\n";
	}
	return $list;
  }

  /* ƥȥ顼 */
  function GetTextColor() {
	if ($_SESSION["text_color"] == "") {
	  print("#000099");
	} else {
	  print(htmlspecialchars($_SESSION["text_color"], ENT_QUOTES));
	}
  }

  /* طʥ顼 */
  function GetBgColor() {
	if ($_SESSION["bgcolor"] == "") {
	  print("#CCFFCC");
	} else {
	  print(htmlspecialchars($_SESSION["bgcolor"], ENT_QUOTES));
	}
  }

  /* ǡ򥻥å */
  function PostToSession() {
	if ($_POST["color2"] != "") {
	  $color = $_POST["color2"];
	} else {
	  $color = $_POST["color"];
	}
	$_SESSION["bgcolor"] = "";
	$_SESSION["text_color"] = "";
	if ($_GET["Type"] == "text") {
	  $_SESSION["bgcolor"] = $color;
	} else {
	  $_SESSION["text_color"] = $color;
	}
	return true;
  }

  /* طʿ */
  function SelectBgColor($bgColor) {
	$_SESSION["bgcolor"] = "#" . $bgColor;
	return true;
  }

  /* ʸ */
  function SelectTextColor($textColor) {
	$_SESSION["text_color"] = "#" . $textColor;
	return true;
  }
}
?>