# vim fileencoding=utf-8
# vi:ts=4:et
# $Id: test_hook.py,v 1.1 2004/05/15 09:03:38 etale Exp $
# =====================================================

import operator
import sys

import unittest
from test import test_support

from young import *

class TestHook(unittest.TestCase):
    def test_repr_str(self):
        hook = Hook((3,2,1,1))

        #print
        `hook`
        print hook

        repr(hook)
        str(hook)

        hook.__repr__()
        hook.__str__()

        "%r"%hook
        "%s"%hook

    def test_instance(self):
        shape = (6,5,5,3)
        part = Partition(shape)
        hook = part.get_hook()
        self.assertEqual(hook, Hook(part))
        self.assertEqual(hook, Hook(shape))
        self.assertEqual(Hook(part), Hook(shape))

    def test_hook_constructor(self):
        # There are two ways to create an instance of Hook object.
        # Check these two yield the same result

        shape = (6,5,5,3)

        part = Partition(shape)
        hook1 = part.get_hook()
        hook2 = Hook(shape)

        self.assertEqual(hook1.number(), hook2.number())
        self.assertEqual(hook1.number(5), hook2.number(5))

        self.assertEqual(hook1.hook_length_formula(), hook2.hook_length_formula())
        self.assertEqual(hook1.hook_length_formula_nonstd(5), hook2.hook_length_formula_nonstd(5))
        self.assertEqual(hook1.hook_length_formula_nonstd2(5), hook2.hook_length_formula_nonstd2(5))


class TestHookLengthFormulaStd(unittest.TestCase):
    def test_hook_length1(self):
        shape = (3,2)
        part = Partition(shape)
        hook = part.get_hook()
        self.assertEqual(hook, Hook(part))

        self.assert_(hook.number() == \
                     hook.hook_length_formula() == \
                     hook.hook_length_formula_ex9() == \
                     5)

    def test_hook_length2(self):
        # this example is taken from Fulton P. 53.

        shape = (6,5,5,3)
        part = Partition(shape)
        hook = part.get_hook()

        self.assertEqual(hook, [[9,8,7,5,4,1],[7,6,5,3,2],[6,5,4,2,1],[3,2,1]])

        self.assertEqual(hook, Hook(part))

        self.assert_(hook.number() == \
                     hook.hook_length_formula() == \
                     hook.hook_length_formula_ex9() == \
                     6651216)

    def test_hook_length_with_young(self):
        for part in partition(8):
            part = Partition(part)
            hook = part.get_hook()
            self.assertEqual(hook.number(), young(part).size())

class TestHookLengthFormulaNonStd(unittest.TestCase):
    def test_hook_length1(self):
        # this example is taken from Fulton P. 55.

        shape = (6,5,5,3)
        part = Partition(shape)
        hook = part.get_hook()
        self.assertEqual(hook, Hook(part))

        self.assert_(hook.number(5) == \
                     hook.hook_length_formula_nonstd(5) == \
                     hook.hook_length_formula_nonstd2(5) == \
                     3360)

class TestHookYoung(unittest.TestCase):
    def test_instance_with_young1(self):
        shape = (3,2,1,1)
        hook = Hook(shape)

        for y in young(shape):
            self.assertEqual(y.get_hook(), hook)

    def test_instance_with_young2(self):
        y = Young([[1,2,3],[4,5],[6],[7]])
        shape = (3,2,1,1)
        hook = Hook(shape)
        self.assertEqual(hook, y.get_hook())


def test_main(verbose=None):
    testclasses = (
            TestHook,
            TestHookLengthFormulaStd,
            TestHookLengthFormulaNonStd,
            TestHookYoung,
            )

    test_support.run_unittest(*testclasses)

if __name__ == '__main__':

    test_main()
