# -*- coding: utf-8 -*-
# vi:ts=4:et
#
# $Date: 2004/05/14 08:26:53 $
# $Revision: 1.6 $
# =====================================================

"""pretty print library for math"""

import sys
import pprint
import itertools

try:
    from cStringIO import StringIO
except ImportError:
    from StringIO import StringIO

__all__     = [
               'pprint_whole_tableaux',
               'pprint_tableaux',
               'pprint_factorial',
               'pprint_partition',
               ]


def pprint_whole_tableaux(part, tableaux):
    '''pretty print all the tableaux
    '''
    buff = StringIO()
    buff.write('\n')
    buff.write(pprint_partition(part) + "\n")
    buff.write('='*40 + "\n")
    for table in tableaux:
        buff.write(pprint_tableaux(table))
        buff.write('-'*20 + "\n")

    return buff.getvalue()

def pprint_tableaux(tableaux):
    '''pretty print tableau
    '''
    # [[1, 2, 3],
    #  [4, 5, 6],
    #  [7]]
    # -> 
    # 1  2  3
    # 4  5  6
    # 7

    buff = StringIO()
    for cor in tableaux:
        '''# convert int -> str
        [1,2,3] -> ['1', '2', '3']
        '''
        cor = itertools.imap(lambda x:"%2s"%x, cor)
        buff.write(" ".join(cor) + "\n")
    #buff.write('\n')
    return buff.getvalue()

def pprint_skew_tableaux(tableaux):
    '''pretty print a skew tableau
    '''
    # [[None, None, 1],
    #  [None, 2, 3],
    #  [5],]
    #  ->
    #  *  *  1]
    #  *  2  3]
    #  5 
    return pprint_tableaux(tableaux).replace('None', ' *')

def pprint_partition(part, prefix = '(', suffix = ')'):
    '''pretty print partition
    '''
    # convert int -> str
    # ( 3,2,1,1) -> ('3', '2', '1', '1')
    part= itertools.imap(str, part)
    return prefix + ",".join(part) + suffix

def pprint_factorial(number):
    '''pretty print factorial
    '''
    # 3 -> 3x2x1
    l = range(number, 0, -1)
    str_l = itertools.imap(str, l)
    return "x".join(str_l)

