# -*- coding: utf-8 -*-
# vi:ts=4:et
#
# $Date: 2004/01/07 02:38:26 $
# $Revision: 1.8 $
# =====================================================

"""functional tools"""

# following recipes might help.
# "Python Cookbook"
# o 17.11 "Wrapping an Unbounded Iterator"
# o 17.12 "Operating on Iterators"

import itertools


__all__ = [
           'drop',
           'take',
           ]

def take(iterable, *args):
    """take(iterable, [start,] stop [,step]) --> take object
    A subiterator limitied to the first n items of iterable's sequence"""

    return itertools.islice(iterable, *args)

def drop(iterable, n, step=1):
    """drop(iterable, start [, step]) --> drop object

    A subiterator removing the first n items from
    iterable's sequence
    """
    return itertools.islice(iterable, n, None, step)

def tail(iterable, n):
    """A subiterator limitied to the last n items of iterable's sequence
    """
    # XXX
    # You need to know the size of the iterable in advance.
    # So this function may not be practical.

    try:
        num_of_drop = len(iterable) - n
    except TypeError, e:
        raise TypeError,\
    "failed to get the size of the iterable in advance.\nuse take or drop instead."

    return drop(iterable, num_of_drop)

# The following sets edit modes for GNU EMACS
# Local Variables:
# mode:python
# End:

