# -*- coding: utf-8 -*-
# vi:ts=4:et
#
# $Date: 2004/05/14 08:15:29 $
# $Revision: 1.3 $
# =====================================================

"""
functions for backward compatibility
"""
import itertools
import sys

__all__ = [
    'reversed',
    'sorted',
    'groupby',
    'tee',
]


def reversed(x):
    """reverse(sequence) -> reverse iterator over values of the sequence"""
    # builtin
    # New in Python 2.4

    if hasattr(x, 'keys'):
        raise ValueError("mappings do not support reverse iteration")
    try:
        i = len(x)
    except Exception, e:
        print >> sys.stderr, e
        print >> sys.stderr, "got %s"%type(x)
        raise e
    while i > 0:
        i -= 1
        yield x[i]

def sorted(iterable, cmp_func=None, key=None, reverse= False):
    """sorted(iterable, cmp=None, key=None, reverse=False) --> new sorted list"""
    # builtin
    # New in Python 2.4

    # XXX
    # If both cmp and key arguments are given, this function doesn't 
    # sort iterable the same way as official Python does.

    aList = list(iterable)

    def decorate(x, y):
        return cmp(key(x), key(y))

    if key:
        # decorator sort
        aList.sort(decorate)

    aList.sort(cmp_func)

    if reverse:
        aList.reverse()

    return aList

def tee(iterable):
    """tee(iterable, n=2) --> tuple of n independent iterators."""
    # itertools.tee
    # New in Python 2.4

    def gen(next, data={}, cnt=[0]):
        for i in itertools.count():
            if i == cnt[0]:
                item = data[i] = next()
                cnt[0] += 1
            else:
                item = data.pop(i)
            yield item
    it = iter(iterable)
    return (gen(it.next), gen(it.next))

class groupby(object):
    
    """groupby(iterable[, keyfunc]) -> create an iterator which returns\n\
(key, sub-iterator) grouped by each value of key(value).\n"""
    # itertools.groupby
    # New in Python 2.4

    def __init__(self, iterable, key=None):
        if key is None:
            key = lambda x: x
        self.keyfunc = key
        self.it = iter(iterable)
        self.tgtkey = self.currkey = self.currvalue = xrange(0)

    def __iter__(self):
        return self

    def next(self):
        while self.currkey == self.tgtkey:
            self.currvalue = self.it.next() # Exit on StopIteration
            self.currkey = self.keyfunc(self.currvalue)
        self.tgtkey = self.currkey
        return (self.currkey, self._grouper(self.tgtkey))

    def _grouper(self, tgtkey):
        while self.currkey == tgtkey:
            yield self.currvalue
            self.currvalue = self.it.next() # Exit on StopIteration
            self.currkey = self.keyfunc(self.currvalue)

