#! /usr/bin/env python
# -*- coding: utf-8 -*-
#
# vi:ts=4:et
# $Date: 2003/10/13 15:48:35 $
# $Revision: 1.2 $
# =====================================================
"""Test script for permgroup.py"""

import sys

# young module
import young

def symm_test():
    # test for symmetric group

    symm = young.SymmetricGroup(3)
    print symm

    print "order : %d"%symm.get_order()
    print

    even = symm.get_even()
    print "even permutation"
    for e in even:
        print e
        print "sgn : %d"%e.get_sgn()
        print "inv : %d"%e.get_inv()
    print

    odd = symm.get_odd()
    print "odd permutation"
    for o in odd:
        print o
        print "sgn : %d"%o.get_sgn()
        print "inv : %d"%o.get_inv()
    print

    for x in symm:
        print x
        print x.to_matrix()

    #sys.exit(0)
    print
    print "sort_by_cycle"
    sorted = symm.sort_by_cycle()

    for x, y in sorted:
        print x
        print "\t",
        print y



def perm_test():
    # test for permutation group

    p = young.PermGroup((3,1,4,2,5))
    print p
    print p.to_cycle()
    print p.to_matrix()

    print "signature : %d"%p.get_sgn()
    print "inversion : %d"%p.get_inversion()

    print "isodd  : %s"%p.isodd()
    print "iseven : %s"%p.iseven()

    print "excedance      : %d"%p.excedance()
    print "weak excedance : %d"%p.weak_excedance()

    inverse = p.get_inverse()
    print "inverse : ",inverse

    # g * g~ = id
    print p * inverse

    return


def cycle_test():
    # test for cycle

    l = range(1,4)
    perm_list = young.permutation(l)
    for perm in perm_list:
        print young.permgroup(perm)
        print "signature : %d"%young.get_sgn(perm)
        print "inversion : %d"%young.get_inversion(perm)
        print "cycle : ",young.to_cycle(perm)
        print


def test():

    # test for permutation group
    perm_test()

    # test for symmetric group
    symm_test()

    # test for cycles
    cycle_test()

if __name__ == '__main__':
    test()
