# -*- coding: utf-8 -*-
#
# vi:ts=4:et
# $Date: 2003/10/19 08:19:43 $
# $Revision: 1.3 $
# =====================================================
"""Test script for partition.py"""

import young

def _test_number_of_partition():
    # test of number of partitions

    print "test of number of partitions"
    print

    n = 10
    p = young.partition(n)
    assert p.size() == young.number_of_partition(n)
    d = dict.fromkeys(range(1, n+1), 0)
    for x in p:d[len(x)] += 1

    print "index\tnormal\trecursive"
    for i in range(1, n+1):
        print "%d\t%d\t%d"%(i, d[i], young.number_of_partition(n, i))
    else:
        print

def _test_plot():
    # plot test

    print "test of plotting"
    print

    n = young.partition(3)
    n.plot()

    p = young.partition(4)
    print p
    for a in p:
        print "-"*5
        print a
        #a.dot_notation()
        print "#original"
        a.plot()
        print "#conjugate"
        a.conjugate().plot()

    return

def _test_iterator():
    # test of iterator

    print "test of iterator"
    print

    p = young.partition(6)
    print "take 7"
    for x in young.take(p, 7):
        print x

    print "drop 8"
    for x in young.drop(p, 8):
        print x

def _test():
    # test

    p = young.partition(10)
    print "size of partition(10):", p.size()
    print "size of partition(20):", young.partition(20).size()

    p = young.partition(6)
    print "distinct partitions"
    p.distinct()
    print p

    return


if __name__ == '__main__':
    _test()
    _test_iterator()
    _test_plot()
    test_number_of_partition()

