/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ykhr.eclipse.plugin.autocp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import jp.gr.java_conf.ykhr.eclipse.plugin.autocp.Activator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.ui.IStartup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibraryManager
implements IStartup {
    private static final List<String> LIB_EXT = Collections.unmodifiableList(Arrays.asList("jar", "zip"));
    private static final String LIBRARY_DIR_NAME = "lib";

    public void earlyStartup() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener(new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                try {
                    event.getDelta().accept(new IResourceDeltaVisitor(){

                        public boolean visit(IResourceDelta delta) throws CoreException {
                            IResource resource;
                            boolean added;
                            boolean removed = (delta.getKind() & 2) != 0;
                            boolean bl = added = (delta.getKind() & 1) != 0;
                            if ((removed || added) && ((resource = delta.getResource()).getType() & 1) != 0 && LibraryManager.this.isTargetLibrary((IFile)resource)) {
                                if (removed) {
                                    LibraryManager.this.removeClasspath((IFile)resource);
                                } else if (added) {
                                    LibraryManager.this.addClasspath((IFile)resource);
                                }
                                return false;
                            }
                            return true;
                        }
                    });
                }
                catch (CoreException e) {
                    Activator.logError(e);
                }
            }
        }, 8);
    }

    private boolean isTargetLibrary(IFile file) throws CoreException {
        IProject project = file.getProject();
        IPath dirPath = file.getParent().getFullPath();
        IPath libPath = project.getFullPath().append(LIBRARY_DIR_NAME);
        return project.exists() && project.hasNature("jp.gr.java_conf.ykhr.eclipse.plugin.autocpnature") && LIB_EXT.contains(file.getFileExtension()) && dirPath.equals((Object)libPath);
    }

    private void removeClasspath(IFile resource) throws JavaModelException {
        IProject project = resource.getProject();
        IJavaProject javaProject = (IJavaProject)project.getAdapter(IJavaElement.class);
        IClasspathEntry[] classpathEntries = javaProject.getRawClasspath();
        if (classpathEntries == null) {
            return;
        }
        ArrayList<IClasspathEntry> newEntries = new ArrayList<IClasspathEntry>();
        IClasspathEntry[] iClasspathEntryArray = classpathEntries;
        int n = classpathEntries.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (entry.getEntryKind() != 1 || !entry.getPath().equals((Object)resource.getFullPath())) {
                newEntries.add(entry);
            }
            ++n2;
        }
        this.setClasspath(javaProject, newEntries);
    }

    private void addClasspath(IFile resource) throws JavaModelException {
        IClasspathEntry entry;
        IProject project = resource.getProject();
        IJavaProject javaProject = (IJavaProject)project.getAdapter(IJavaElement.class);
        IClasspathEntry[] classpathEntries = javaProject.getRawClasspath();
        if (classpathEntries == null) {
            classpathEntries = new IClasspathEntry[]{};
        }
        boolean exist = false;
        ArrayList<IClasspathEntry> newEntries = new ArrayList<IClasspathEntry>();
        IClasspathEntry[] iClasspathEntryArray = classpathEntries;
        int n = classpathEntries.length;
        int n2 = 0;
        while (n2 < n) {
            entry = iClasspathEntryArray[n2];
            if (entry.getEntryKind() == 1 && entry.getPath().equals((Object)resource.getFullPath())) {
                exist = true;
            }
            newEntries.add(entry);
            ++n2;
        }
        if (!exist) {
            entry = JavaCore.newLibraryEntry((IPath)resource.getFullPath(), null, null);
            newEntries.add(entry);
            this.setClasspath(javaProject, newEntries);
        }
    }

    private void setClasspath(IJavaProject javaProject, List<IClasspathEntry> newEntries) throws JavaModelException {
        IClasspathEntry[] entries = new IClasspathEntry[newEntries.size()];
        newEntries.toArray(entries);
        javaProject.setRawClasspath(entries, null);
    }
}

