/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ykhr.eclipse.plugin.viewlist;

import jp.gr.java_conf.ykhr.eclipse.plugin.viewlist.ViewListActivator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.internal.dialogs.ViewContentProvider;
import org.eclipse.ui.internal.dialogs.ViewLabelProvider;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.IViewDescriptor;
import org.eclipse.ui.views.IViewRegistry;

public class ViewListView
extends ViewPart {
    private static final String ID = "jp.gr.java_conf.ykhr.eclipse.plugin.viewlist.view";
    private TreeViewer viewer;
    private Color dimmedForeground;

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 0);
        Control control = this.viewer.getControl();
        RGB dimmedRGB = ViewListView.blend(control.getForeground().getRGB(), control.getBackground().getRGB(), 60);
        this.dimmedForeground = new Color((Device)this.viewer.getControl().getDisplay(), dimmedRGB);
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider(ViewListActivator.getActiveWorkbenchWindow(), this.dimmedForeground));
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ViewListView.this.doDoubleClickAction(event);
            }
        });
        IViewRegistry viewRegistry = ViewListActivator.getDefault().getWorkbench().getViewRegistry();
        this.viewer.setInput((Object)viewRegistry);
    }

    private static RGB blend(RGB c1, RGB c2, int ratio) {
        int r = ViewListView.blend(c1.red, c2.red, ratio);
        int g = ViewListView.blend(c1.green, c2.green, ratio);
        int b = ViewListView.blend(c1.blue, c2.blue, ratio);
        return new RGB(r, g, b);
    }

    private static int blend(int v1, int v2, int ratio) {
        int b = (ratio * v1 + (100 - ratio) * v2) / 100;
        return Math.min(255, b);
    }

    private void doDoubleClickAction(DoubleClickEvent event) {
        IStructuredSelection s = (IStructuredSelection)event.getSelection();
        Object element = s.getFirstElement();
        if (this.viewer.isExpandable(element)) {
            this.changeExpandedState(element);
        } else if (element instanceof IViewDescriptor) {
            IViewDescriptor viewDesc = (IViewDescriptor)element;
            if (ID.equals(viewDesc.getId())) {
                MessageDialog.openInformation((Shell)ViewListActivator.getShell(), (String)"from ykhr", (String)"^^;");
            } else {
                this.openView(viewDesc.getId());
            }
        }
    }

    private void changeExpandedState(Object element) {
        boolean oldState = this.viewer.getExpandedState(element);
        this.viewer.setExpandedState(element, !oldState);
    }

    private void openView(String viewId) {
        IWorkbenchPage page = ViewListActivator.getActiveWorkbenchWindow().getActivePage();
        try {
            page.showView(viewId);
        }
        catch (PartInitException e) {
            ViewListActivator.logError(e);
        }
    }

    public void setFocus() {
    }

    public void dispose() {
        this.dimmedForeground.dispose();
    }
}

