package jp.gr.java_conf.ykhr.csvutil.converter;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

import jp.gr.java_conf.ykhr.csvutil.CSVElement;
import jp.gr.java_conf.ykhr.csvutil.ReaderUtils;
import jp.gr.java_conf.ykhr.csvutil.Utils;
import jp.gr.java_conf.ykhr.csvutil.config.ReadConfig;
import jp.gr.java_conf.ykhr.csvutil.ex.CSVReadException;

public class PriorityConverter implements Converter {
    
    public <T>Collection<T> toBeanCollection(Class<T> clazz, Collection<String[]> elements, ReadConfig config)
    throws CSVReadException {
        
        Map<CSVElement, PropertyDescriptor> priorityToProperty 
            = getPriorityToPropertyMapping(clazz);
        Collection<T> beans = new ArrayList<T>();
        
        Iterator<String[]> iter = elements.iterator();
        if (config.isExistHeader()) {
            if (!iter.hasNext()) {
                throw new CSVReadException();
            }
            iter.next();
        }
        
        for ( ; iter.hasNext(); ) {
            String[] data = iter.next();
            T bean = ReaderUtils.createBeanInstance(clazz);
            
            int i = 0;
            for (PropertyDescriptor desc : priorityToProperty.values()) {
                Method method = desc.getWriteMethod();
                Class<?>[] types = method.getParameterTypes();
                if (types.length < 1) {
                    continue;
                }

                Object param = ReaderUtils.convertType(data[i++], types[0]);
                if (param != null) {
                    ReaderUtils.setObject(bean, method, param);
                }
            }
            
            beans.add(bean);
        }
        
        return beans;
    }

    private <T> Map<CSVElement, PropertyDescriptor> getPriorityToPropertyMapping(Class<T> clazz) 
    throws CSVReadException {
        Map<CSVElement, PropertyDescriptor> priorityToProperty 
            = new TreeMap<CSVElement, PropertyDescriptor>(Utils.PRIORITY_COMP);;
        try {
            priorityToProperty.putAll(Utils.createCsvToPropertyInfo(clazz));
        } catch (IntrospectionException e) {
            throw new CSVReadException(e);
        }
        return priorityToProperty;
    }

}
