/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ykhr.csvutil;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import jp.gr.java_conf.ykhr.csvutil.ex.CSVReadException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReaderUtils {
    public static void setObject(Object bean, Method method, Object param) throws CSVReadException {
        try {
            method.invoke(bean, param);
        }
        catch (IllegalAccessException e) {
            throw new CSVReadException(e);
        }
        catch (InvocationTargetException e) {
            throw new CSVReadException(e);
        }
    }

    public static <T> T createBeanInstance(Class<T> clazz) throws CSVReadException {
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new CSVReadException(e);
        }
        catch (IllegalAccessException e) {
            throw new CSVReadException(e);
        }
    }

    public static Object convertType(String value, Type type) {
        if (ReaderUtils.isEmpty(value)) {
            return null;
        }
        if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
            return Integer.valueOf(value);
        }
        if (type.equals(Double.TYPE) || type.equals(Double.class)) {
            return Double.valueOf(value);
        }
        if (type.equals(Long.TYPE) || type.equals(Long.class)) {
            return Long.valueOf(value);
        }
        if (type.equals(Float.TYPE) || type.equals(Float.class)) {
            return Float.valueOf(value);
        }
        if (type.equals(Boolean.TYPE) || type.equals(Boolean.class)) {
            return Boolean.valueOf(value);
        }
        if (type.equals(Character.TYPE) || type.equals(Character.class)) {
            return Character.valueOf(value.charAt(0));
        }
        if (type.equals(Byte.TYPE) || type.equals(Byte.class)) {
            return Byte.valueOf(value);
        }
        return value;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }
}

