/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ykhr.eclipse.plugin.junitreporter.vo;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.gr.java_conf.ykhr.eclipse.plugin.junitreporter.vo.TestCaseVO;

public class TestSuiteVO {
    private String id;
    private String name;
    private List testCases;
    private long failures;
    private long errors;
    private long time;
    private Date timeStamp;

    public TestSuiteVO(String id, String name) {
        this.id = id;
        this.name = name;
        this.testCases = new ArrayList();
        this.timeStamp = new Date();
    }

    public void addTestCase(TestCaseVO testCase) {
        this.testCases.add(testCase);
        this.time += testCase.getTime();
        if (testCase.isError()) {
            ++this.errors;
        } else if (testCase.isFailure()) {
            ++this.failures;
        }
    }

    public String getId() {
        return this.id;
    }

    public double getTimeInSecond() {
        return (double)this.time / 1000.0;
    }

    public String getName() {
        return this.name;
    }

    public List getTestCases() {
        return this.testCases;
    }

    public long getTests() {
        return this.testCases.size();
    }

    public long getFailures() {
        return this.failures;
    }

    public long getErrors() {
        return this.errors;
    }

    public long getTime() {
        return this.time;
    }

    public Date getTimeStamp() {
        return this.timeStamp;
    }

    public String getPackage() {
        int index = this.name.lastIndexOf(46);
        if (index == -1) {
            return "";
        }
        return this.name.substring(0, index);
    }
}

