/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ykhr.eclipse.plugin.junitreporter.main;

import java.io.File;
import java.util.Map;
import jp.gr.java_conf.ykhr.eclipse.plugin.junitreporter.JUnitReporterActivator;
import jp.gr.java_conf.ykhr.eclipse.plugin.junitreporter.ex.WriteException;
import jp.gr.java_conf.ykhr.eclipse.plugin.junitreporter.main.DirCommand;
import jp.gr.java_conf.ykhr.eclipse.plugin.junitreporter.main.HtmlConverter;
import jp.gr.java_conf.ykhr.eclipse.plugin.junitreporter.main.IReporterCommand;
import jp.gr.java_conf.ykhr.eclipse.plugin.junitreporter.main.JUnitXmlWriter;
import jp.gr.java_conf.ykhr.eclipse.plugin.junitreporter.main.ReporterProperty;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class ReporterCommand
implements IReporterCommand {
    private Map testResults;
    private ReporterProperty prop;

    public ReporterCommand(Map testResults, ReporterProperty prop) {
        this.testResults = testResults;
        this.prop = prop;
    }

    public static IReporterCommand getCommand(Map testResult, ReporterProperty prop) {
        return new DirCommand(testResult, prop);
    }

    public String getName() {
        return "JUnit Reporter";
    }

    public void execute(IProgressMonitor monitor) throws WriteException {
        monitor.beginTask(this.getName(), 3);
        String output = this.getOutputPath(monitor);
        if (output == null) {
            return;
        }
        monitor.worked(1);
        if (monitor.isCanceled()) {
            return;
        }
        String xmlPath = this.createXml(monitor);
        monitor.worked(1);
        if (monitor.isCanceled()) {
            return;
        }
        this.createReport(output, xmlPath, monitor);
        monitor.worked(1);
        monitor.done();
    }

    protected void createReport(String output, String xmlPath, IProgressMonitor monitor) throws WriteException {
        monitor.setTaskName("create html");
        HtmlConverter converter = this.getHtmlConverter(xmlPath, output);
        converter.convertHtml();
    }

    protected String createXml(IProgressMonitor monitor) throws WriteException {
        monitor.setTaskName("create xml");
        String xmlPath = this.getXmlOutputPath();
        JUnitXmlWriter writer = new JUnitXmlWriter(xmlPath, this.testResults.values());
        writer.write();
        return xmlPath;
    }

    protected String getXmlOutputPath() {
        IPath stateLocation = JUnitReporterActivator.getDefault().getStateLocation();
        IPath xmlDestPath = stateLocation.append("junit").append("junit.xml");
        File xmlDest = xmlDestPath.toFile();
        File parent = xmlDest.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        return xmlDest.getAbsolutePath();
    }

    protected abstract String getOutputPath(IProgressMonitor var1);

    protected abstract HtmlConverter getHtmlConverter(String var1, String var2);
}

