/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ykhr.eclipse.plugin.junitreporter.main;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import jp.gr.java_conf.ykhr.eclipse.plugin.junitreporter.ex.WriteException;
import jp.gr.java_conf.ykhr.eclipse.plugin.junitreporter.utils.DomUtils;
import jp.gr.java_conf.ykhr.eclipse.plugin.junitreporter.vo.TestCaseVO;
import jp.gr.java_conf.ykhr.eclipse.plugin.junitreporter.vo.TestSuiteVO;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JUnitXmlWriter {
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private static final DecimalFormat df = new DecimalFormat("0.000");
    private String output;
    private Collection testResults;

    public JUnitXmlWriter(String output, Collection testResults) {
        this.output = output;
        this.testResults = testResults;
    }

    public void write() throws WriteException {
        try {
            Document document = DomUtils.newDocument();
            Element suitesElm = DomUtils.createElement(document, "testsuites");
            Iterator suiteIt = this.testResults.iterator();
            while (suiteIt.hasNext()) {
                TestSuiteVO suite = (TestSuiteVO)suiteIt.next();
                Element suiteElm = this.createTestSuiteElement(suitesElm, suite);
                List testCases = suite.getTestCases();
                Iterator tcIt = testCases.iterator();
                while (tcIt.hasNext()) {
                    TestCaseVO testCase = (TestCaseVO)tcIt.next();
                    Element testCaseElm = this.createTestCaseElement(suiteElm, testCase);
                    if (testCase.isSuccess()) continue;
                    this.appendTestErrorChild(testCaseElm, testCase);
                }
            }
            DomUtils.outputXMLFile(document, this.output, "UTF-8");
        }
        catch (ParserConfigurationException e) {
            throw new WriteException(e);
        }
        catch (TransformerException e) {
            throw new WriteException(e);
        }
    }

    private Element createTestCaseElement(Element suiteElm, TestCaseVO testCase) {
        Element testCaseElm = DomUtils.createElement(suiteElm, "testcase");
        testCaseElm.setAttribute("classname", testCase.getClassName());
        testCaseElm.setAttribute("name", testCase.getName());
        testCaseElm.setAttribute("time", df.format(testCase.getTimeInSecond()));
        return testCaseElm;
    }

    private Element createTestSuiteElement(Element suitesElm, TestSuiteVO suite) {
        Element suiteElm = DomUtils.createElement(suitesElm, "testsuite");
        suiteElm.setAttribute("id", suite.getId());
        suiteElm.setAttribute("name", suite.getName());
        suiteElm.setAttribute("package", suite.getPackage());
        suiteElm.setAttribute("tests", String.valueOf(suite.getTests()));
        suiteElm.setAttribute("errors", String.valueOf(suite.getErrors()));
        suiteElm.setAttribute("failures", String.valueOf(suite.getFailures()));
        suiteElm.setAttribute("time", df.format(suite.getTimeInSecond()));
        suiteElm.setAttribute("timestamp", sdf.format(suite.getTimeStamp()));
        suiteElm.setAttribute("hostname", System.getProperty("user.name", "unknown"));
        return suiteElm;
    }

    private void appendTestErrorChild(Element testElm, TestCaseVO testCase) {
        if (testCase.isSuccess()) {
            return;
        }
        Element errorElm = null;
        if (testCase.isError()) {
            errorElm = DomUtils.createElement(testElm, "error");
        } else if (testCase.isFailure()) {
            errorElm = DomUtils.createElement(testElm, "failure");
        } else {
            throw new IllegalArgumentException();
        }
        errorElm.setAttribute("type", testCase.getType());
        String message = testCase.getMessage();
        if (message != null && !message.equals("")) {
            errorElm.setAttribute("message", testCase.getMessage());
        }
        DomUtils.createTextNode(errorElm, testCase.getTrace());
    }
}

