/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ykhr.eclipse.plugin.junitreporter.main;

import java.io.File;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import jp.gr.java_conf.ykhr.eclipse.plugin.junitreporter.ex.WriteException;
import jp.gr.java_conf.ykhr.eclipse.plugin.junitreporter.main.ReporterProperty;

public abstract class HtmlConverter {
    protected String xml;
    protected String dest;
    protected String xslt;
    protected ReporterProperty prop;

    public HtmlConverter(String xml, String dest, ReporterProperty prop) {
        this.xml = xml;
        this.dest = dest;
        this.prop = prop;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void convertHtml() throws WriteException {
        this.preConvert();
        File xsltFile = this.selectXslt();
        StreamSource xmlSource = new StreamSource(new File(this.xml));
        StreamSource xslt = new StreamSource(xsltFile);
        Result result = this.getTransformResult();
        try {
            try {
                Transformer tf = TransformerFactory.newInstance().newTransformer(xslt);
                this.configTransformer(tf);
                tf.transform(xmlSource, result);
            }
            catch (TransformerConfigurationException e) {
                throw new WriteException(e);
            }
            catch (TransformerException e) {
                throw new WriteException(e);
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            this.postConvert();
            throw throwable;
        }
        {
            Object var6_10 = null;
            this.postConvert();
            return;
        }
    }

    private File selectXslt() throws WriteException {
        File xsltFile = null;
        xsltFile = this.xslt == null || this.xslt.length() == 0 ? this.getDefaultStyle() : new File(this.xslt);
        if (xsltFile == null || !xsltFile.exists()) {
            throw new WriteException();
        }
        return xsltFile;
    }

    protected void configTransformer(Transformer tf) {
    }

    protected abstract Result getTransformResult();

    protected abstract File getDefaultStyle();

    protected abstract void preConvert();

    protected abstract void postConvert();
}

