<?php
/*
 * Actung Baby - Kids Class by Yoshi Sakai ( a.k.a bluemoon )
 */
require_once "./class/tcp_ping.class.php";
require_once "./class/boundio.class.php";

class ActionHandler {
	var $mTable = "profile_data";
	var $records = array();
	var $debstr="";
	var $multiple="";
	var $opArray = array();
	var $mObject = array();
	var $opText="";
	var $opHtml="";
	var $opHtmlTbl="";
	var $opHtmlFan="";
	var $profileData = array();
	var $bdo_error;
	/*
	 *  Initial Handler Section
	 */
	function ActionHandler($ctrl="",$callbyBlock=false){
		if($callbyBlock!=true) $this->getParam();
		$this->callbyBlock = $callbyBlock;
		switch($ctrl){
			case "category_addnew":
				$this->ctrl = "addnew" ;
				break;
			case "category_edit":
				$this->ctrl = "edit" ;
				break;
		}
	}
	/*
	 *  Global Task Section
	 */
	function load(){
		global $xoopsDB,$xoopsModuleConfig;
		$pinger = new TcpPingWrapper();
		$pinger->ReadFormInput();
		$sql = "SELECT * FROM " . $xoopsDB->prefix($this->mTable);
		$res = $xoopsDB->query($sql);
		while($myrow=$xoopsDB->fetchArray($res)){
			if(isset($myrow['host']) && isset($myrow['status'])){
				if ($myrow['status']!="Down")
					$pinger->ReadFormProfile( $myrow['host'] );
			}
			$this->mObject[$myrow['host']] = $myrow;
		}
		$bdo = new boundio($xoopsModuleConfig['boundio_serial'],$xoopsModuleConfig['boundio_key']);
		if (isset($_REQUEST['hosts'])){
			$pinger->Ping();
			$this->opArray = $pinger->GetOutputAsArray();
			foreach($this->opArray as $op){
				if ($op['status']!="Alive"){
					$this->setErrorStatus($op);
					$this->sendMail($op);
					$tell_to = $this->mObject[$op['host']]['phone'];
					$this->bdo_error = $bdo->bundioCall($tell_to,$xoopsModuleConfig['boundio_fileno']);
				}
			}
		}
		return true;
	}
	function assignRecords(){
		global $xoopsTpl;
		$debstr = "";	//$this->debstr;
		$xoopsTpl->assign('multiple', $this->multiple );
		$xoopsTpl->assign('opArray', $this->opArray );
		$xoopsTpl->assign('thisUser', $this->mObject );
		$xoopsTpl->assign('boundio', $this->bdo_error );
		//		$xoopsTpl->assign( 'ctrl', $this->ctrl );
	}
	function debug(){
		return $this->debstr;
	}
	/*
	 *  Private Task Section
	 */
	private function getParam(){
		global $xoopsUser;
		if (isset($_POST['multiple'])) {
			$this->multiple = htmlspecialchars($_POST['multiple'],ENT_QUOTES,_CHARSET);
			$_REQUEST['hosts'] = preg_split("/\s+/", $this->multiple, 10, PREG_SPLIT_NO_EMPTY);
		}
	}
	private function setErrorStatus($op){
		global $xoopsDB;
		$myts =& MyTextSanitizer::getInstance();
		$rec = $this->mObject[$op['host']];
		$upd = array();
		foreach ($op as $key => $val) {
			echo sprintf("%s[%s]<br />",$key,$val);
			if(($key=="status" || $key=="additionalInfo") && isset($rec[$key]))
				$upd[$key] = '"' . $myts->addSlashes($val) . '"';
		}
		$sql = "UPDATE ".$xoopsDB->prefix($this->mTable) . " SET ";
		$i=0;
		foreach ($upd as $key=>$val ){
			if ($i>0) $sql .= ",";
			$sql .= " " . $key . "=" . $val;
			$i++;
		}
		$sql .= " WHERE uid=" . $rec['uid'];
		$result = $xoopsDB->query( $sql );
		$this->debstr .= $sql."<br />";
		return $result;
	}
	private function sendMail($op){
		global $xoopsConfig, $xoopsUser;
		
		$rec = $this->mObject[$op['host']];
		$userName = $xoopsUser->uname();
		$userEmail = isset($op['mailto']) ? $op['mailto'] : $xoopsUser->email();
		$subject = sprintf("xSurvive to %s", $userName);
		$mailTplDir  = sprintf(
			'%s/modules/xsurvive/language/%s/mail_template/',
			XOOPS_ROOT_PATH, $xoopsConfig['language']
		);
		$mailer =& getMailer();
		$mailer->useMail();
		$mailer->setTemplateDir($mailTplDir);
		$mailer->setTemplate('notify.tpl');
		$mailer->setToEmails($userEmail);
		$mailer->setFromEmail($xoopsConfig['adminmail']);
		$mailer->setFromName($xoopsConfig['sitename']);
		$mailer->setSubject($subject);
		$mailer->assign('UNAME', $userName);
		$mailer->assign('STATUS', $op['status']);
		$mailer->assign('ADDITIONALINFO', $op['additionalInfo']);
		
		if ( !$mailer->send() ){
			return $result = "Error!".$mailer->getErrors();
		}		
		return NULL;
	}
	/*
	 *  Controller Driven Section
	 */
	function category_insert(){
		$ret = $this->insert();
		$this->load();
		$this->message = _MD_CARTB2B_ADDNEWDONE;
		$this->ctrl = "edit";
		return 1;
	}
	function category_addnew(){
		$this->ctrl = "insert";
		return 1;
	}
	function category_update(){
		$ret = $this->update();
		$this->load();
		$this->message = _MD_CARTB2B_UPDATEDONE;
		$this->ctrl = "edit";
		return 1;
	}
	function category_edit(){
		$this->ctrl = "update";
		return 1;
	}
	function category_deleteOk(){
		$ret = $this->delete();
		$this->gcid = 0;
		$this->ctrl = "";
		$this->message = _MD_CARTB2B_DELETEDONE;
		$this->load();
		return 1;
	}
	function category_delete(){
		$this->ctrl = "deleteOk";
		return 1;
	}
}
?>