/*
 * Qt Application/GUI thread
 *
 * Author: Takuya Murakami
 */

#ifdef	QWS
#include <qpe/qpeapplication.h>
#include <qwsevent_qws.h>
#else
#include <qapplication.h>
//#include <qthread.h>
#endif

#include <unistd.h>
#include <pthread.h>

#include "xqtcmn.h"
#include "qtscreen.h"

#ifdef	QWS
class XqtApplication : public QPEApplication
{
public:
	XqtApplication(int &argc, char **argv);
	virtual bool qwsEventFilter(QWSEvent *e);
};

XqtApplication::XqtApplication(int &argc, char **argv)
	: QPEApplication(argc, argv)
{
}

bool XqtApplication::qwsEventFilter(QWSEvent *e)
{
	// dirty hack...
	if ( e->type == QWSEvent::Key) {
		QWSKeyEvent *ke = (QWSKeyEvent *)e;
		if (ke->simpleData.keycode == Qt::Key_Escape) {
			// avoid QPEApplication::qwsEventFilter
			return QApplication::qwsEventFilter(e);
		}
	}
	return QPEApplication::qwsEventFilter(e);
}
#else
#define	XqtApplication	QApplication
#endif

class MainThread //: public QThread
{
private:
	XqtApplication *ap;
	pthread_t	thr;

public:
	MainThread(int &argc, char **argv);
	void start();

protected:
	static void *run(void *arg) {
		XqtApplication *ap = (XqtApplication *)arg;
		ap->exec();
	}
};


MainThread::MainThread(int &argc, char **argv)
{
	ap = new XqtApplication(argc, argv);

	g_screen = new qtScreen;
	g_screen->showMaximized();

	ap->setMainWidget(g_screen);

	start();
};

void MainThread::start(void)
{
	pthread_create(&thr, NULL, this->run, (void*)ap);
}

static MainThread *g_mainThread = NULL;

extern "C"
void qtStartGuiThread(int argc, char *argv[])
{
	if (!g_mainThread) {
		g_mainThread = new MainThread(argc, argv);
	}
}

#if 0	/* test */
int main(int argc, char *argv[])
{
	qtStartGuiThread(argc, argv);

	g_mainThread->lock();
	sleep(10);
	g_mainThread->unlock();

	sleep(100000);
}
#endif
