<?php
//  ------------------------------------------------------------------------ //
//             --  XoopsHP Module --       Xoops e-Learning System           //
//                     Copyright (c) 2005 SUDOW-SOKEN                        //
//                      <http://www.mailpark.co.jp/>                         //
//  ------------------------------------------------------------------------ //
//               Based on XoopsHP1.01 by Yoshi, aka HowardGee.               //
//  ------------------------------------------------------------------------ //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//  ------------------------------------------------------------------------ //
include '../../../include/cp_header.php';

// Perms check
if ( !is_object($xoopsUser) || !is_object($xoopsModule) || !$xoopsUser->isAdmin($xoopsModule->mid()) ) {
    exit("Access Denied");
}

if ( file_exists("../language/".$xoopsConfig['language']."/main.php") ) {
    include "../language/".$xoopsConfig['language']."/main.php";
} else {
    include "../language/english/main.php";
}

/*********************************************************/
/* Sections Manager Functions                            */
/*********************************************************/
function sections($secid2show = 0) {
    global $xoopsConfig, $xoopsDB, $xoopsModule;
    xoops_cp_header();
    echo "<h4>"._AM_SECCONF."</h4>";
    include '../module_prefix.php';
    $result = $xoopsDB->query("select secid, secname, secdesc from ".$xoopsDB->prefix($module_prefix."_sections")." order by secname");
    if ($xoopsDB->getRowsNum($result) > 0) {
	$myts =& MyTextSanitizer::getInstance();
	echo "<hr /><h4>"._MD_CURACTIVESEC._MD_CLICK2EDIT."</h4>";
	echo "<table border='0' cellspacing='1' cellpadding ='3' class='outer'>";
	echo "<tr>";
	echo "<th>"._MD_SECNAMEC."</th>";
	echo "<th>"._MD_SECDESC."</th>";
	echo "<th>"._MD_LT_ACTION."</th>";
	echo "</tr>";
	while(list($secid, $secname, $secdesc) = $xoopsDB->fetchRow($result)) {
	    $secname=$myts->makeTboxData4Show($secname);
	    $secdesc=$myts->makeTboxData4Show($secdesc);
	    echo "<tr>";
	    echo "<td class='even'><b>".$secname."</b></td>";
	    echo "<td class='even'>".$secdesc."</td>";
	    echo "<td class='even'><a href=\"index.php?op=sectionedit&amp;secid=".$secid."\">"._MD_EDIT."</a></td>";
 	    echo "</tr>";
	}
	echo "</table>";
	echo "<br />";

	echo "<hr /><h4>"._MD_ADDARTICLE."</h4>";
	echo "<form enctype=\"multipart/form-data\" action=\"index.php\" method=\"post\">";
	echo "<b>"._MD_TITLEC."</b>";
	echo "<input class=textbox type=\"text\" name=\"title\" size=40 value=''><br />";

	include '../module_prefix.php';
	$result = $xoopsDB->query("select secid, secname from ".$xoopsDB->prefix($module_prefix."_sections")." order by secname");
	$checked = " checked='checked'"; // select first section by default
	echo "<b>" . _MD_SECNAMEC . "</b> <select name='secid'><option value='0' selected></option>";
	while(list($secid, $secname) = $xoopsDB->fetchRow($result)) {
	    $secname=$myts->makeTboxData4Show($secname);
	    echo "<option value='$secid'>$secname</option>";
	}
	?>

	</select><br />
	<b><?php echo _MD_CONTENTC; ?></b>
	<input type="hidden" name="MAX_FILE_SIZE" value="200000" />
	<input type="file" name="quizfile" /><br /><br />
	<input type="hidden" name="op" value="secarticleadd" />
	<input type="submit" value="<?php echo _MD_DOADDARTICLE; ?>" />
	</form>
	<br />
	<hr /><h4><?php echo _MD_LAST20ART; ?></h4>

	<?php
	echo "<form action=\"index.php\" method=\"post\">";
	echo "<b>" . _MD_SECNAMEC . "</b> <select name='secid'>";
	include '../module_prefix.php';
	$result = $xoopsDB->query("select secid, secname from ".$xoopsDB->prefix($module_prefix."_sections")." order by secname");

	while(list($secid, $secname) = $xoopsDB->fetchRow($result)) {
	    $secname=$myts->makeTboxData4Show($secname);
	    if (!$secid2show) {
		$secid2show = $secid;
	    }
	    if ($secid == $secid2show) {
		echo "<option value='$secid' selected>$secname</option>";
	    } else {
		echo "<option value='$secid'>$secname</option>";
	    }
	}
	?>

	</select>
	<input type="hidden" name="op" value="sections" />
	<input type="submit" value="<?php echo _MD_GO;?>" />
	</form>

	<?php
	include '../module_prefix.php';
	$result = $xoopsDB->query("select artid, secid, title from ".$xoopsDB->prefix($module_prefix."_quiz")." where secid=".$secid2show." order by title");
	echo "<table border='0' cellspacing='1' cellpadding ='3' class='outer'>";
	echo "<tr>";
	echo "<th>"._MD_TITLEC."</th>";
	echo "<th COLSPAN='2'>"._MD_LT_ACTION."</th>";
	echo "</tr>";
	while ( list($artid, $secid, $title) = $xoopsDB->fetchRow($result) ) {
	    $title = $myts->makeTboxData4Show($title);
	    include '../module_prefix.php';
	    $result2 = $xoopsDB->query("select secid, secname from ".$xoopsDB->prefix($module_prefix."_sections")." where secid='$secid'");
	    list($secid, $secname) = $xoopsDB->fetchRow($result2);
	    $secname = $myts->makeTboxData4Show($secname);
	    echo "<tr>"
		."<td class='even'><b>$title</b></td>"
		."<td class='even'><a href=index.php?op=secartedit&amp;artid=$artid>"._MD_EDIT."</a></td>"
		."<td class='even'><a href=index.php?op=secartdelete&amp;artid=$artid>"._MD_DELETE."</a></td>"
		."</tr>";
	}
	echo "</table>";
    }
    ?>

    <br />
    <hr /><h4><?php echo _MD_ADDNEWSEC; ?></h4>
    <?php echo "<form action=\"index.php\" method=\"post\">"; ?>
    <b><?php echo _MD_SECNAMEC; ?></b>  <?php echo _MD_MAXCHAR; ?><br />
    <input class="textbox" type="text" name="secname" size="40" maxlength="40" /><br /><br />
    <b><?php echo _MD_SECDESC; ?></b>  <?php echo _MD_EXDESC; ?><br />
    <input class="textbox" type="text" name="secdesc" size="40" maxlength="255" /><br /><br />
    <input type="hidden" name="op" value="sectionmake" />
    <input type="submit" value="<?php echo _MD_GOADDSECTION; ?>" />
    </form>

    <?php
}

function secartedit($artid) {
    global $xoopsDB, $xoopsConfig, $xoopsModule;
    $myts =& MyTextSanitizer::getInstance();
    xoops_cp_header();
    echo "<h4>"._AM_SECCONF."</h4>";
    include '../module_prefix.php';
    $result = $xoopsDB->query("select artid, secid, title, content from ".$xoopsDB->prefix($module_prefix."_quiz")." where artid='$artid'");
    list($artid, $secid, $title, $content) = $xoopsDB->fetchRow($result);
    $title = $myts->makeTboxData4Edit($title);
    $content = $myts->makeTareaData4Edit($content);
    ?>

    <hr /><h3><?php echo _MD_EDITARTICLE; ?></h3>
    <?php echo "<form enctype=\"multipart/form-data\" action=\"index.php\" method=\"post\">"; ?>
    <b><?php echo _MD_EDITARTID; ?>&nbsp;&nbsp;<?php echo "$artid"; ?></b><br /><br />
    <b><?php echo _MD_TITLEC; ?></b><input class="textbox" type="text" name="title" size="40" value="<?php echo "$title"; ?>" /><br />

    <?php
    echo "<b>" . _MD_SECNAMEC . "</b> <select name='secid'>";
    include '../module_prefix.php';
    $result2 = $xoopsDB->query("select secid, secname from ".$xoopsDB->prefix($module_prefix."_sections")." order by secname");
    while(list($secid2, $secname) = $xoopsDB->fetchRow($result2)) {
    $secname = $myts->makeTboxData4Show($secname);
    $che = "";
    if ($secid2==$secid) { $che = " selected"; }
	echo "<option value='$secid2'$che>$secname</option>";
    }
    echo "</select>";
    ?>

    <br />
    <b><?php echo _MD_CONTENTC; ?></b><?php echo _MD_READONLY; ?><br />
    <textarea class="textbox" name="content" cols="60" rows="10" readonly><?php echo "$content"; ?></textarea>
    <input type="hidden" name="MAX_FILE_SIZE" value="200000" /><br />
    <b><?php echo _MD_FILE2REPLACE; ?></b><input type="file" name="quizfile" /><br /><br />
    <input type="hidden" name="artid" value="<?php echo "$artid"; ?>" />
    <input type="hidden" name="op" value="secartchange" />

    <table border="0"><tr><td>
    <input type="submit" value="<?php echo _MD_SAVECHANGES; ?>" />
    </td></form>
    <?php echo "<form action=\"index.php\" method=\"post\">"; ?>
    <td>
    <input type="hidden" name="artid" value="<?php echo "$artid"; ?>" />
    <input type="hidden" name="op" value="secartdelete" />
    <input type="submit" value="<?php echo _MD_DELETE; ?>" />
    </td></form></tr></table>

    <?php
}

function sectionedit($secid) {
    global $xoopsDB, $xoopsConfig, $xoopsModule;
    xoops_cp_header();
    echo "<h4>"._AM_SECCONF."</h4><br />";
    $myts =& MyTextSanitizer::getInstance();
    include '../module_prefix.php';
    $result = $xoopsDB->query("select secid, secname, secdesc from ".$xoopsDB->prefix($module_prefix."_sections")." where secid=$secid");
    list($secid, $secname, $secdesc) = $xoopsDB->fetchRow($result);
    $secname = $myts->makeTboxData4Edit($secname);
    $secdesc = $myts->makeTboxData4Edit($secdesc);
    include '../module_prefix.php';
    $result2 = $xoopsDB->query("select artid from ".$xoopsDB->prefix($module_prefix."_quiz")." where secid=$secid");
    $number = $xoopsDB->getRowsNum($result2);
    ?>

    <h4><?php printf(_MD_EDITTHISSEC,$secname); ?></h4>
    <br />

    <?php
    $help = sprintf(_MD_THISSECHAS,$number);
    echo "$help";
    ?>

    <br /><br />
    <?php echo "<form action=\"index.php\" method=\"post\">"; ?><br />
    <b><?php echo _MD_SECNAMEC; ?></b> <?php echo _MD_MAXCHAR; ?><br />
    <input class="textbox" type="text" name="secname" size="40" maxlength="40" value="<?php echo "$secname"; ?>" /><br /><br />
    <b><?php echo _MD_SECDESC; ?></b> <?php echo _MD_EXDESC; ?><br />
    <input class="textbox" type="text" name="secdesc" size="40" maxlength="50" value="<?php echo "$secdesc"; ?>" /><br /><br />
    <input type="hidden" name="secid" value="<?php echo "$secid"; ?>" />
    <input type="hidden" name="op" value="sectionchange" />

    <table border="0"><tr><td>
    <input type="submit" value="<?php echo _MD_SAVECHANGES; ?>" />
    </td></form>
    <?php echo "<form action=\"index.php\" method=\"post\">"; ?>
    <td>
    <input type="hidden" name="secid" value="<?php echo "$secid"; ?>" />
    <input type="hidden" name="op" value="sectiondelete" />
    <input type="submit" value="<?php echo _MD_DELETE; ?>" />
    </td></form></tr></table>

    <?php
}

function cgi_replace($content) {
    global $xoopsDB, $xoopsModule;
    if (!ereg(_XD_FB_CODE4RESULTS_MARKER, $content)) {
	$content = ereg_replace(_XD_FB_CODE4RESULTS_INSERT, _XD_FB_CODE4RESULTS."\n\n" . _XD_FB_CODE4RESULTS_INSERT, $content);
	if (!ereg(_XD_FB_CODE4STARTUP, $content)) {
	    $content = ereg_replace(_XD_FB_CODE4STARTUP_INSERT, "\\0\n\n"._XD_FB_CODE4STARTUP."\n", $content);
	} else {
	    redirect_header("index.php",3,_MD_ERRORQUIZFILE);
	}
	if (!ereg(_XD_FB_CODE4SEND, $content)) {
	    $content = ereg_replace(_XD_FB_CODE4SEND_INSERT, "\\0\n\n"._XD_FB_CODE4SEND, $content);
	} else {
	    redirect_header("index.php",3,_MD_ERRORQUIZFILE);
	}
    }

    $content = ereg_replace("toLocaleString","toGMTString",$content);
    $action = XOOPS_URL . "/modules/" . $xoopsModule->dirname() . "/process_form.php";
    return(ereg_replace("var ResultForm = '<html><body><form name=\"Results\" action=\"[^\"]*\"", "var ResultForm = '<html><body><form name=\"Results\" action=\"$action\" accept-charset=\"EUC-JP\"", $content));
}


// URL GET_VARS OPTION
$op = '';

if (isset($HTTP_GET_VARS['op'])) {
    $op = trim($HTTP_GET_VARS['op']);
	$artid = (isset($HTTP_GET_VARS['artid'])) ? intval($HTTP_GET_VARS['artid']) : 0;
	$secid = (isset($HTTP_GET_VARS['secid'])) ? intval($HTTP_GET_VARS['secid']) : 0;
	$res_id = (isset($HTTP_GET_VARS['res_id'])) ? intval($HTTP_GET_VARS['res_id']) : 0;
} elseif (!empty($_POST['op'])) {
    $op = $_POST['op'];
    $artid = !empty($_POST['artid']) ? intval($_POST['artid']) : 0;
    $secid = !empty($_POST['secid']) ? intval($_POST['secid']) : 0;
    $res_id = !empty($_POST['res_id']) ? intval($_POST['res_id']) : 0;
}

switch ($op) {
    case "sections":
	sections($secid);
	break;

    case "sectionedit":
	sectionedit($secid);
	break;

    case "sectionmake":
	$myts =& MyTextSanitizer::getInstance();
	$secname = !empty($_POST['secname']) ? $myts->stripSlashesGPC($_POST['secname']) : '';
	if (empty($secname)) {
	    redirect_header("index.php", 2, _MD_ERRORSECNAME);
	}
	$secdesc = !empty($_POST['secdesc']) ? $myts->stripSlashesGPC($_POST['secdesc']) : '';
	include '../module_prefix.php';
	$newid = $xoopsDB->genId($xoopsDB->prefix($module_prefix."_sections")."_secid_seq");
	include '../module_prefix.php';
	$xoopsDB->query("INSERT INTO ".$xoopsDB->prefix($module_prefix."_sections")." (secid, secname, secdesc) VALUES ($newid, ".$xoopsDB->quoteString($secname).", ".$xoopsDB->quoteString($secdesc).")");
	redirect_header("index.php?op=sections",2,_MD_DBUPDATED);
	break;

    case "secartdelete":
	xoops_cp_header();
	echo "<h4>"._AM_SECCONF."</h4>";
	$myts =& MyTextSanitizer::getInstance();
	if (!empty($_POST['artid'])) {
		$artid = intval($_POST['artid']);
	} elseif (!empty($_GET['artid'])) {
		$artid = intval($_GET['artid']);
	} else {
		$artid = 0;
	}
	include '../module_prefix.php';
	$result = $xoopsDB->query("select title from ".$xoopsDB->prefix($module_prefix."_quiz")." where artid=$artid");
	list($title) = $xoopsDB->fetchRow($result);
	$title = $myts->makeTboxData4Show($title);
	xoops_confirm(array('op' => 'secartdelete_ok', 'artid' => $artid), 'index.php', sprintf(_MD_DELETETHISART,$title).'<br /><br />'._MD_RUSUREDELART);
	break;

    case 'secartdelete_ok':
	$artid = !empty($_POST['artid']) ? intval($_POST['artid']) : 0;
	if ($artid <= 0) {
	    redirect_header("index.php?op=sections",2,_MD_DBNOTUPDATED);
	}
	include '../module_prefix.php';
	$sql = sprintf("DELETE FROM %s WHERE artid = %u", $xoopsDB->prefix($module_prefix."_quiz"), $artid);
	$xoopsDB->query($sql);
	include '../module_prefix.php';
	$sql = sprintf("DELETE FROM %s WHERE quiz_id = %u", $xoopsDB->prefix($module_prefix."_results"), $artid);
	$xoopsDB->query($sql);
	redirect_header("index.php?op=sections",2,_MD_DBUPDATED);
	break;

    case "sectionchange":
	if ($secid <= 0) {
	    redirect_header("index.php?op=sections",2,_MD_DBNOTUPDATED);
	}
	$myts =& MyTextSanitizer::getInstance();
	$secname = !empty($_POST['secname']) ? $myts->stripSlashesGPC($_POST['secname']) : '';
	if (empty($secname)) {
	    redirect_header("index.php", 2, _MD_ERRORSECNAME);
	}
	$secdesc = !empty($_POST['secdesc']) ? $myts->stripSlashesGPC($_POST['secdesc']) : '';
	include '../module_prefix.php';
	$xoopsDB->query("update ".$xoopsDB->prefix($module_prefix."_sections")." set secname=".$xoopsDB->quoteString($secname).", secdesc=".$xoopsDB->quoteString($secdesc)." where secid=$secid");
	redirect_header("index.php?op=sections",2,_MD_DBUPDATED);
	break;

    case "secarticleadd":
	if ($secid <= 0) {
	    redirect_header("index.php?op=sections",2,_MD_ERRORSECNAME);
	}
	$myts =& MyTextSanitizer::getInstance();
	if (empty($_POST['title'])) {
	    redirect_header("index.php?op=sections",2,_MD_ERRORARTNAME);
	} else {
    	    $title = $myts->stripSlashesGPC($_POST['title']);
	}
	$title = $xoopsDB->quoteString($title);
	$content = is_uploaded_file($_FILES['quizfile']['tmp_name']) ? implode(file($_FILES['quizfile']['tmp_name'])) : '';
	if (empty($content)) {
	    redirect_header("index.php?op-sections",2,_MD_ERRORARTCONT);
	}
	$content = cgi_replace($content);
	$content = $xoopsDB->quoteString($content);
	$posted = $xoopsDB->quoteString(date("Y/m/d H:i:s"));
	$poster = $xoopsUser->getVar("uid");
	$results_to = $xoopsDB->quoteString($xoopsUser->getVar("email"));
	include '../module_prefix.php';
	$newid = $xoopsDB->genId($xoopsDB->prefix($module_prefix."_quiz")."_artid_seq");
	include '../module_prefix.php';
	$success = $xoopsDB->query("INSERT INTO ".$xoopsDB->prefix($module_prefix."_quiz")." (artid, secid, title, content, posted, poster, results_to, counter) VALUES ($newid, $secid, $title, $content, $posted, $poster, $results_to, 0)");
	if ( !$success ) {
	    xoops_cp_header();
	    echo "<table width='100%' border='0' cellspacing='1' class='outer'><tr><td class=\"odd\">";
	    echo "<a href='./index.php'><h4>"._AM_SECCONF."</h4></a>";
	    echo _MD_DBNOTUPDATED;
	    echo"</td></tr></table>";
	    xoops_cp_footer();
	    exit();
	}
	redirect_header("index.php?op=sections",2,_MD_DBUPDATED);
	break;

    case "secartedit":
	$artid = !empty($_REQUEST['artid']) ? intval($_REQUEST['artid']) : 0;
	if ($artid > 0) {
	    secartedit($artid);
	}
	break;

    case "secartchange":
	$artid = !empty($_POST['artid']) ? intval($_POST['artid']) : 0;
	if ($artid <= 0) {
	    redirect_header("index.php?op=sections",2,_MD_DBNOTUPDATED);
	}
	$myts =& MyTextSanitizer::getInstance();
	$title = !empty($_POST['title']) ? $myts->stripSlashesGPC($_POST['title']) : '';
	$content = is_uploaded_file($_FILES['quizfile']['tmp_name']) ? implode(file($_FILES['quizfile']['tmp_name'])) : '';
	if (empty($content)){
	    include '../module_prefix.php';
	    $xoopsDB->query("update ".$xoopsDB->prefix($module_prefix."_quiz")." set secid=$secid, title=".$xoopsDB->quoteString($title)." where artid=$artid");
	} else {
	    $content = cgi_replace($content);
	    include '../module_prefix.php';
	    $xoopsDB->query("update ".$xoopsDB->prefix($module_prefix."_quiz")." set secid=$secid, title=".$xoopsDB->quoteString($title).", content=".$xoopsDB->quoteString($content)." where artid=$artid");
	}
	redirect_header("index.php?op=sections",2,_MD_DBUPDATED);
	break;

    case "sectiondelete":
	xoops_cp_header();
	echo "<h4>"._AM_SECCONF."</h4>";
	xoops_confirm(array('op' => 'sectiondelete_ok', 'secid' => $secid), 'index.php', _MD_RUSUREDELSEC.'<br />'._MD_THISDELETESALL);
	break;

    case 'sectiondelete_ok':
	include '../module_prefix.php';
	$sql = sprintf("DELETE FROM %s WHERE secid = %u", $xoopsDB->prefix($module_prefix."_quiz"), $secid);
	$xoopsDB->query($sql);
	include '../module_prefix.php';
	$sql = sprintf("DELETE FROM %s WHERE secid = %u", $xoopsDB->prefix($module_prefix."_sections"), $secid);
	$xoopsDB->query($sql);
	redirect_header("index.php?op=sections",2,_MD_DBUPDATED);
	break;

    case "resultdelete":
	xoops_cp_header();
	echo "<h4>"._AM_SECCONF."</h4>";
	$myts =& MyTextSanitizer::getInstance();
	if (!empty($_POST['res_id'])) {
	    $res_id = intval($_POST['res_id']);
	} elseif (!empty($_GET['res_id'])) {
	    $res_id = intval($_GET['res_id']);
	} else {
	    $res_id = 0;
	}
	include '../module_prefix.php';
	$result = $xoopsDB->query("SELECT quiz_id, uid, score, timestamp FROM ".$xoopsDB->prefix($module_prefix."_results")." WHERE id=$res_id");
	list($quiz_id, $uid, $score, $timestamp) = $xoopsDB->fetchRow($result);
	include '../module_prefix.php';
	$result = $xoopsDB->query("SELECT title FROM ".$xoopsDB->prefix($module_prefix.'_quiz')." WHERE artid=$quiz_id");
	list($title) = $xoopsDB->fetchRow($result);
	$message = "<center><br />"._MD_RUSUREDELREC."<br /><br />";
	$message .= "<table border='1'><th>"._MD_LT_STUDENT."</th><th>"._MD_LT_TITLE."</th><th>"._MD_LT_SCORE."</th><th>"._MD_LT_DATE."</th></tr>";
	$message .= "<tr><td align='center'>".$xoopsUser->getUnameFromId($uid)."</td><td align='center'>$title</td><td align='center'>$score</td><td align='center'>$timestamp</td></tr>";
	$message .= "</table></center>";
	xoops_confirm(array('op' => 'resultdelete_ok', 'res_id' => $res_id, 'artid' => $quiz_id), 'index.php', $message);
	break;

    case "resultdelete_ok":
	$res_id = !empty($_POST['res_id']) ? intval($_POST['res_id']) : 0;
	$artid = !empty($_POST['artid']) ? intval($_POST['artid']) : 0;
	if ($res_id <= 0) {
	    redirect_header("index.php?op=sections",2,_MD_DBNOTUPDATED);
	}
	include '../module_prefix.php';
	$sql = sprintf("DELETE FROM %s WHERE id = %u", $xoopsDB->prefix($module_prefix."_results"), $res_id);
	$xoopsDB->query($sql);
	redirect_header("../index.php?op=viewresults&amp;artid=$artid",2,_MD_DBUPDATED);
	break;

    default:
	sections();
	break;
}

xoops_cp_footer();
?>
