<?php
// $Id: Validator_GooglemapCount.class.php,v 1.1.1.1 2009/01/05 08:39:18 ohwada Exp $

//=========================================================
// Googlemap Netcommons
// 2009-01-01 K.OHWADA
//=========================================================

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * Googlemap件数チェックバリデータクラス
 *
 * @package     NetCommons.validator
 * @author      Noriko Arai,Ryuji Masukawa
 * @copyright   2006-2007 NetCommons Project
 * @license     http://www.netcommons.org/license.txt  NetCommons License
 * @project     NetCommons Project, supported by National Institute of Informatics
 * @access      public
 */
class Googlemap_Validator_GooglemapCount extends Validator
{
    /**
     * Googlemap件数チェックバリデータ
     *
     * @param   mixed   $attributes チェックする値
     * @param   string  $errStr     エラー文字列
     * @param   array   $params     オプション引数
     * @return  string  エラー文字列(エラーの場合)
     * @access  public
     */
    function validate($attributes, $errStr, $params)
    {
// スクロール中は不要
		if ($attributes["scroll"] == _ON) {
			return;
		}

// partsレコード件数の取得
		$container =& DIContainerFactory::getContainer();
        $googlemapView =& $container->getComponent("googlemapView");
		$googlemapCount = $googlemapView->getGooglemapCount();
        if ($googlemapCount == 0) {
        	return $errStr;
        }

		$request =& $container->getComponent("Request");
		$request->setParameter("googlemapCount", $googlemapCount);
		
        return;
    }
}
?>