/* $Id: googlemap.js,v 1.3 2012/05/15 03:00:06 ohwada Exp $ */

// 2012-05-01 K.OHWADA
// API V3

/* =========================================================
 * Googlemap Netcommons
 * 2009-01-01 K.OHWADA
 * =========================================================
 */

var clsGooglemap = Class.create();
var googlemapCls = Array();

clsGooglemap.prototype = {
	initialize: function(id) {
		this.id = id;
		
		this.parts_id = null;
		this.currentGooglemapID = null;
		this.oldSortCol = null;
	},
	//カレントをハイライトしてラジオボタンをチェック状態にする
	checkCurrent: function() {
		var currentRow = $("googlemap_current_row" + this.currentGooglemapID + this.id);
		if (!currentRow) {
			return;
		}
		//指定したエレメントにスタイルのクラスを追加
		Element.addClassName(currentRow, "highlight");

		var current = $("googlemap_current" + this.currentGooglemapID + this.id);
		//カレントのラジオボタンのチェック状態にする
		current.checked = true;
	},
	//カレントを変更してハイライトする
	changeCurrent: function(googlemapID) {
		var oldCurrentRow = $("googlemap_current_row" + this.currentGooglemapID + this.id);
		if (oldCurrentRow) {
			//指定したところの指定したクラス名を削除する
			Element.removeClassName(oldCurrentRow, "highlight");
		}
		
		this.currentGooglemapID = googlemapID;
		var currentRow = $("googlemap_current_row" + this.currentGooglemapID + this.id);
		Element.addClassName(currentRow, "highlight");
		
		var post = {
			"action":"googlemap_action_edit_current",
			"parts_id":googlemapID
		};
		var params = new Object();
		//エラーが帰ってきたときの処理
		params["callbackfunc_error"] = function(res){
											commonCls.alert(res);
											commonCls.sendView(this.id, "googlemap_view_edit_list");
										}.bind(this);
		commonCls.sendPost(this.id, post, params);
	},
	//参照を押したときに呼び出される
	referGooglemap: function(event, parts_id) {
		var params = new Object();
		params["action"] = "googlemap_view_edit_preview";
		params["parts_id"] = parts_id;
		params["prefix_id_name"] = "popup_parts_reference" + parts_id;

		var popupParams = new Object();
		var top_el = $(this.id);
		popupParams['top_el'] = top_el;
		popupParams['target_el'] = top_el;
	
		commonCls.sendPopupView(event, params, popupParams);
	},
	//削除を押すときに呼び出される
	deleteGooglemap: function(parts_id, confirmMessage) {
		if (!commonCls.confirm(confirmMessage)) return false;
		
		var post = {
			"action":"googlemap_action_edit_delete",
			"parts_id":parts_id
		};
					
		var params = new Object();
		params["target_el"] = $(this.id);
		params["callbackfunc_error"] = function(res){
											commonCls.alert(res);
											commonCls.sendView(this.id, "googlemap_view_edit_list");
										}.bind(this);
		commonCls.sendPost(this.id, post, params);
	},
	//管理の編集を押す時に呼び出される。
	editGooglemap: function(parts_id) {
		var params = new Object();
		params["action"] = "googlemap_view_edit_modify";
		params["parts_id"] = parts_id;
		//paramsの情報を持ってactionに指定した場所を表示する
		commonCls.sendView(this.id, params);
	},
	//新規登録と編集のアクションを起こす
	insertParts: function(form_el) {
		var params = new Object();
		params["target_el"]=$(this.id);
		params["focus_flag"]=true;
		//googlemap/action/edit/entryにformから受け取った内容をつなげて送る
		var post="action=googlemap_action_edit_entry&" + Form.serialize(form_el);
		commonCls.sendPost(this.id, post, params);
	}
}