<?php
// $Id: View.class.php,v 1.3 2012/05/09 14:02:15 ohwada Exp $

// 2012-05-01 K.OHWADA
// API V3

//=========================================================
// Googlemap Netcommons
// 2009-01-01 K.OHWADA
//=========================================================

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * Googlemap取得コンポーネント
 *
 * @package     NetCommons Components
 * @author      Noriko Arai,Ryuji Masukawa
 * @copyright   2006-2007 NetCommons Project
 * @license     http://www.netcommons.org/license.txt  NetCommons License
 * @project     NetCommons Project, supported by National Institute of Informatics
 * @access      public
 */
class Googlemap_Components_View
{
	/**
	 * @var DIコンテナを保持
	 *
	 * @access	private
	 */
	var $_container = null;

	/**
	 * @var DBオブジェクトを保持
	 *
	 * @access	private
	 */
	var $_db = null;

	/**
	 * @var Requestオブジェクトを保持
	 *
	 * @access	private
	 */
	var $_request = null;

	/**
	 * コンストラクター
	 *
	 * @access	public
	 */
	function Googlemap_Components_View()
	{
		$this->_container =& DIContainerFactory::getContainer();
		$this->_db        =& $this->_container->getComponent("DbObject");
		$this->_request   =& $this->_container->getComponent("Request");
	}

	/**
	 * Googlemapが存在するか判断する
	 *
     * @return boolean	true:存在する、false:存在しない
	 * @access	public
	 */
	function googlemapExists() 
	{
		$params = array(
			$this->_request->getParameter("parts_id")
		);
		$sql = "SELECT parts_id ".
				"FROM {googlemap_parts} ".
				"WHERE parts_id = ? ";
		$googlemapIDs = $this->_db->execute($sql, $params);
		if ($googlemapIDs === false) {
			$this->_db->addError();
			return $googlemapIDs;
		}
		
		if (count($googlemapIDs) > 0) {
			return true;
		}

		return false;
	}

	/**
	 * Googlemapのpartsレコード件数を取得する
	 *
     * @return string	Googlemap件数
	 * @access	public
	 */
	function getGooglemapCount() 
	{
		$count = $this->_db->countExecute("googlemap_parts");
		return $count;
	}

	/**
	 * 現在配置されているGooglemapIDを取得する
	 *
     * @return string	配置されているGooglemapID
	 * @access	public
	 */
	function &getCurrentGooglemapID() 
	{
		$params = array($this->_request->getParameter("block_id"));		
		$sql = "SELECT parts_id ".
				"FROM {googlemap_block} ".
				"WHERE block_id = ?";
		$googlemapIDs = $this->_db->execute($sql, $params);
		if ($googlemapIDs === false) {
			//errorメッセージを追加
			$this->_db->addError();
			return $googlemapIDs;
		}

		return $googlemapIDs[0]["parts_id"];
	}

	/**
	 * Googlemapのpartsレコード一覧を取得する
	 *
     * @return array	Googlemap一覧データ配列
	 * @access	public
	 */
	function &getGooglemapList() 
	{
		$sortColumn = $this->_request->getParameter("sort_col");
		if (empty($sortColumn)) {
			$sortColumn = "parts_id";
		}
		$sortDirection = $this->_request->getParameter("sort_dir");
		if (empty($sortDirection)) {
			$sortDirection = "DESC";
		}
		$orderParams[$sortColumn] = $sortDirection;

// 一覧を取得する
		$sql = "SELECT * ".
				"FROM {googlemap_parts} ".
				$this->_db->getOrderSQL($orderParams);
		$rows = $this->_db->execute($sql);
		if ($rows === false) {
			$this->_db->addError();
			return false;
		}

// 編集権限を追加する
		$ret = array();
		foreach ($rows as $row) 
		{
			$row['has_edit_auth'] = $this->hasEditAuthority( $row['insert_user_id'] );
			$ret[] = $row;
		}

		return $ret;
	}

	/**
	 * Googlemapのblockのカレントレコードを取得する
	 *
     * @return string	partsデータ配列
	 * @access	public
	 */
	function getCurPartsData()
	{
		$id = $this->_request->getParameter("block_id");
		return $this->getCurPartsDataByBlockId( $id );
	}
	function getCurPartsDataByBlockId( $id )
	{
		$arr = $this->getCurPartsDataArrayByBlockId( $id );
		if( isset($arr[0]) ){
			return $arr[0];
		}
		return false;
	}
	function getCurPartsDataArrayByBlockId( $id )
	{
		$sql = "SELECT P.* ".
				"FROM {googlemap_parts} P ".
				"INNER JOIN {googlemap_block} B ".
				"ON B.parts_id = P.parts_id ".
				"WHERE B.block_id = ? ";
		$params = array( $id );
		$result = $this->_db->execute($sql, $params);
		if ($result === false) {
			$this->_db->addError();
			return false;
		}
		return $result;
	}

	/**
	 * Googlemapのpartsレコードを取得する
	 *
     * @return array	partsデータ配列
	 * @access	public
	 */
	function getPartsData()
	{
		$id = $this->_request->getParameter("parts_id");
		return $this->getPartsDataByPartsId( $id );
	}
	function getPartsDataByPartsId( $id )
	{
		$arr = $this->getPartsDataArrayByPartsId( $id );
		if( isset($arr[0]) ){
			return $arr[0];
		}
		return false;
	}
	function getPartsDataArrayByPartsId( $id )
	{
		$sql = "SELECT * ".
				"FROM {googlemap_parts} ".
				"WHERE parts_id= ? ";
		$params = array( $id );
		$result = $this->_db->execute($sql, $params);
		if ($result === false) {
			$this->_db->addError();
			return false;
		}
		return $result;
	}

	/**
	 * Googlemapの初期値を取得する
	 *
     * @return array	partsデータ配列
	 * @access	public
	 */
	function getPartsDataDefaultCreate()
	{
		$arr = array(
			'parts_latitude'  => GOOGLEMAP_DEFAULT_LATITUDE ,
			'parts_longitude' => GOOGLEMAP_DEFAULT_LONGITUDE ,
			'parts_zoom'      => GOOGLEMAP_DEFAULT_ZOOM ,
		);
		return $arr;
	}
	function getPartsDataDefaultLocation()
	{
		$arr = array(
			'parts_width'  => GOOGLEMAP_DEFAULT_WIDTH ,
			'parts_height' => GOOGLEMAP_DEFAULT_HEIGHT ,
		);
		return $arr;
	}

	/**
	 * 編集権限を取得する
	 *
	 * @param	array	$insetUserID	登録者ID
	 * @return boolean	true:権限有り、false:権限無し
	 * @access	public
	 */
	function hasEditAuthority( $inset_user_id )
	{
		$session  =& $this->_container->getComponent("Session");
		$_user_id = $session->getParameter("_user_id");
		$_auth_id = $session->getParameter("_user_auth_id");

// 投稿者 あるいは 管理者
		if ($inset_user_id == $_user_id || $_auth_id == _AUTH_ADMIN) {
			return true;
		}
	    return false;
	}

	/**
	 * Config テーブルのデータを取得する
	 *
     * @return array	データ配列
	 * @access	public
	 */
	function getConfig() 
	{
		$configView =& $this->_container->getComponent("configView");
		$module_id = $this->_request->getParameter("module_id");
		$config = $configView->getConfig($module_id, false);
		if ($config === false) {
    		return false;
    	}
    	$arr = array(
    		'list_row_count' => $config['list_row_count']['conf_value']
		);	
		return $arr;
	}
}
?>