<?php
// $Id: index.php,v 1.7 2011/04/30 12:58:46 ohwada Exp $

//================================================================
// Facebook Module
// 2011-03-01 K.OHWADA
//================================================================

//---------------------------------------------------------
// change log
// 2011-04-30 K.OHWADA
// set_user_param()
//---------------------------------------------------------

//---------------------------------------------------------
// header
//---------------------------------------------------------
include 'header.php';

//---------------------------------------------------------
// main
//---------------------------------------------------------
$xoops_cube_legacy = false;
if (defined('XOOPS_CUBE_LEGACY')) {
	$xoops_cube_legacy = true;
}

$code = isset($_GET['code']) ? $_GET['code'] : null; 
$msg  = isset($_GET['msg'])  ? $_GET['msg']  : null; 

$message = '';
$error   = '';
$feeds   = null;
$show_feeds  = false;
$feeds_error = '';

$description = $xoopsModuleConfig['description'] ;

// if NOT login
if (empty($xoopsUser)) {
	$xoopsOption['template_main'] = 'facebook_please_login.html';
	include XOOPS_ROOT_PATH.'/header.php';

	$xoopsTpl->assign('show_login_password', true );
	$xoopsTpl->assign('show_login_facebook', true );
	$xoopsTpl->assign('show_login_twitter',  
		facebook_module_exsists( 'twitter' ) );
	$xoopsTpl->assign('show_login_openid',   
		facebook_module_exsists( 'exauth_openid' ) );

	$xoopsTpl->assign('xoops_cube_legacy',   $xoops_cube_legacy );
	$xoopsTpl->assign('description',         $description);  
	$xoopsTpl->assign('lang_please_login',   _FACEBOOK_PLEASE_LOGIN );
	$xoopsTpl->assign('lang_login_password', _FACEBOOK_LOGIN_PASSWORD );
	$xoopsTpl->assign('lang_login_facebook', _FACEBOOK_LOGIN_FACEBOOK );
	$xoopsTpl->assign('lang_login_twitter',  _FACEBOOK_LOGIN_TWITTER );
	$xoopsTpl->assign('lang_login_openid',   _FACEBOOK_LOGIN_OPENID );
	include XOOPS_ROOT_PATH.'/footer.php';
	exit();
}

$uid = $xoopsUser->getVar('uid');

$service =& facebook_xoops_service::getInstance();
$exauth  =& $service->get_exauth_Instance();

$ret = $service->init();

// if NOT set App ID
if ( !$ret ) {
	$xoopsOption['template_main'] = 'facebook_error.html';
	include XOOPS_ROOT_PATH.'/header.php';
	$xoopsTpl->assign('error', _FACEBOOK_ERR_APP_ID );
	$xoopsTpl->assign('show_goto_admin', true );
	$xoopsTpl->assign('lang_goto_admin', _FACEBOOK_GOTO_ADMIN );
	include XOOPS_ROOT_PATH.'/footer.php';
	exit();
}

$ret = $service->set_user_param( $uid );

// if NOT set user param
if ( !$ret ) {
	$code  = $service->get_error_code();
	$error = $service->get_error_msg();

	$flag_exauth_id = false;
	if ( $code == -2 ) {
		$flag_exauth_id = true;
	}

	$xoopsOption['template_main'] = 'facebook_please_facebook.html';
	include XOOPS_ROOT_PATH.'/header.php';
	$xoopsTpl->assign('xoops_cube_legacy', $xoops_cube_legacy );
	$xoopsTpl->assign('error',             $error);
	$xoopsTpl->assign('flag_exauth_id',    $flag_exauth_id);  
	$xoopsTpl->assign('lang_please_facebook_id', _FACEBOOK_PLEASE_FACEBOOK_ID );
	$xoopsTpl->assign('lang_login_facebook',     _FACEBOOK_LOGIN_FACEBOOK );
	include XOOPS_ROOT_PATH.'/footer.php';
	exit();
}

$user = $service->get_user_me();

// if NOT get user info
if ( !$user ) {
	$error  = _FACEBOOK_ERR_USER;
	$error .= '<br />';
	$error .= $service->get_error_msg();

	$xoopsOption['template_main'] = 'facebook_error.html';
	include XOOPS_ROOT_PATH.'/header.php';
	$xoopsTpl->assign('error', $error );
	$xoopsTpl->assign('show_goto_admin', true );
	$xoopsTpl->assign('lang_goto_admin', _FACEBOOK_GOTO_ADMIN );
	include XOOPS_ROOT_PATH.'/footer.php';
	exit();
}

switch ($code)
{
	case 0:
		break;

	case 1:
		$message = _FACEBOOK_POST_SUCCESS;
		break;

	default:
		$error = $service->get_post_error( $code, $msg );
		break;
}

$token = $xoopsGTicket->issue();

$service->set_elapse_words( 
	_FACEBOOK_ELAPSE_FULL, 
	_FACEBOOK_ELAPSE_HOUR,
	_FACEBOOK_ELAPSE_MIN );

// read_stream
if ( $service->get_scope_read_stream() ) {
	$feeds = $service->get_me_feeds();

// if get News Feeds
	if ( is_array($feeds) ) {
		$show_feeds = true;

// if NOT get News Feeds
	} else {
		$feeds_error  = _FACEBOOK_ERR_FEEDS;
		$feeds_error .= '<br />';
		$feeds_error .= $service->get_error_msg();
	}
}

$xoopsOption['template_main'] = 'facebook_index.html';
include XOOPS_ROOT_PATH.'/header.php';

$xoopsTpl->assign('message',     $message );
$xoopsTpl->assign('error',       $error );
$xoopsTpl->assign('feeds',       $feeds );
$xoopsTpl->assign('show_feeds',  $show_feeds );
$xoopsTpl->assign('feeds_error', $feeds_error );
$xoopsTpl->assign('user',        $user ); 
$xoopsTpl->assign('token',       $token );
$xoopsTpl->assign('show_form',   $service->get_scope_publish_stream() );
$xoopsTpl->assign('lang_post',      _FACEBOOK_POST );
$xoopsTpl->assign('lang_post_what', _FACEBOOK_POST_WHAT );

include XOOPS_ROOT_PATH.'/footer.php';
exit();
// === main end ===

function facebook_module_exsists( $name )
{
	$module_handler =& xoops_gethandler('module');
	$module = $module_handler->getByDirname( $name );
	if ( is_object($module) ) {
		return true;
	}
	return false;
}

?>