<?php
// $Id: exauth_base.class.php,v 1.1 2011/04/30 19:32:45 ohwada Exp $

//================================================================
// Facebook Module
// 2011-04-30 K.OHWADA
//================================================================

class facebook_exauth_base
{
	var $_db = null;

	var $_error_code = 0;
	var $_error_msg  = null;

	var $_EXAUTH_TYPE = null;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function facebook_exauth_base()
{
	$this->_db =& Database::getInstance();
}

function get_error_code() 
{
	return $this->_error_code ;
}

function get_error_msg() 
{
	return $this->_error_msg ;
}

function set_exauth_type( $v ) 
{
	return $this->_EXAUTH_TYPE = $v;
}

//---------------------------------------------------------
// get exauth_id
//---------------------------------------------------------
function get_flag_exauth_id( $uid )
{
	$flag_exauth_id = false;
	$ret = $this->get_exauth_id_param( $uid );
	if ( $ret ) {
		return true;
	}
	return false;
}

function get_exauth_id( $uid )
{
	$param = $this->get_exauth_id_param( $uid );
	if ( !isset( $param['exauth_id'] ) ) {
		return false;
	}
	return $param['exauth_id'];
}

//---------------------------------------------------------
// get user_token
//---------------------------------------------------------
function get_exauth_plugin_user_value( $uid )
{
	$rows = $this->get_exauth_plugin_user_value_by_uid( $uid );
	if ( !is_array($rows) || !count($rows) ) {
		return false;
	}

	$arr = array();
    foreach( $rows as $row ) {
      	$arr[ $row['exauth_conf_name'] ] = $row['exauth_conf_value'] ;
    }
    return $arr;
}

//---------------------------------------------------------
// set user_token
//---------------------------------------------------------
function set_exauth_plugin_user_value( $uid, $params )
{
	$flag = false;
	foreach ( $params as $k => $v )
	{
		$rows = $this->get_exauth_plugin_user_value_by_uid_name( $uid, $k );

// no recred
		if ( !is_array($rows) || !count($rows) ) {
			$ret = $this->insert_exauth_plugin_user_value( $uid, $k, $v );
			if ( !$ret ) {
				$flag = true;
			}

// only one record
		} elseif ( count($rows) == 1 ) {
			$ret = $this->update_exauth_plugin_user_value( $uid, $k, $v );
			if ( !$ret ) {
				$flag = true;
			}

// two or more records
		} else {
			$ret1 = $this->delete_exauth_plugin_user_valueby_uid_name( $uid, $k );
			if ( $ret1 ) {
				$ret2 = $this->insert_exauth_plugin_user_value( $uid, $k, $v );
				if ( !$ret2 ) {
					$flag = true;
				}
			} else {
				$flag = true;
			}
		}
	}

	if ( $flag ) {
		return false;
	}
	return true;
}

//---------------------------------------------------------
// sql
//---------------------------------------------------------
function get_exauth_id_param( $uid )
{
	$sql  = "SELECT * FROM ";
	$sql .= $this->_db->prefix('exauth_id') ;
	$sql .= " WHERE `uid`=" . intval($uid);
	$sql .= " AND `exauth`=" . $this->_db->quoteString($this->_EXAUTH_TYPE) ;

	$rows = $this->get_rows_by_sql($sql);
	if ( !is_array($rows) || (count($rows) != 1 ) ) {
		return false;
	}

	return $rows[0];
}

function get_exauth_plugin_user_value_by_uid( $uid )
{
	$sql = "SELECT * FROM " ;
	$sql .=	$this->prefix_plugin_user_value();
 	$sql .= " WHERE ";
	$sql .= $this->build_sql_where_uid( $uid );

	return $this->get_rows_by_sql($sql);
}

function get_exauth_plugin_user_value_by_uid_name( $uid, $name )
{
	$sql = "SELECT * FROM " ;
	$sql .=	$this->prefix_plugin_user_value();
 	$sql .= " WHERE ";
	$sql .= $this->build_sql_where_uid_name( $uid, $name );

	return $this->get_rows_by_sql($sql);
}

function insert_exauth_plugin_user_value( $uid, $name, $value )
{
	$sql  =	"INSERT INTO " ;
	$sql .=	$this->prefix_plugin_user_value();
	$sql .=	" SET " . "`uid`=" . intval($uid) ;
	$sql .=	" , `exauth_conf_name`=".$this->_db->quoteString($name);
	$sql .=	" , `exauth_conf_value`=".$this->_db->quoteString($value);
	$sql .=	" , `exauth`=".$this->_db->quoteString($this->_EXAUTH_TYPE);

	return $this->_db->queryF($sql);
}

function update_exauth_plugin_user_value( $uid, $name, $value )
{
	$sql = "UPDATE ";
	$sql .=	$this->prefix_plugin_user_value();
	$sql .= " SET `exauth_conf_value`=" . $this->_db->quoteString($value);
	$sql .= " WHERE ";
	$sql .= $this->build_sql_where( $uid, $name );

	return $this->_db->queryF($sql);
}

function delete_exauth_plugin_user_value_by_uid_name( $uid, $name )
{
	$sql = "DELETE ";
	$sql .=	$this->prefix_plugin_user_value();
	$sql .= " WHERE ";
	$sql .= $this->build_sql_where_uid_name( $uid, $name );

	return $this->_db->queryF($sql);
}

function prefix_plugin_user_value()
{
	return $this->_db->prefix('exauth_plugin_user_value') ;
}

function build_sql_where_uid( $uid )
{
	$sql  = " `uid`=" . intval($uid);
    $sql .= " AND `exauth`=".$this->_db->quoteString($this->_EXAUTH_TYPE);

	return $sql;
}

function build_sql_where_uid_name( $uid, $name )
{
	$sql  = " `uid`=" . intval($uid);
    $sql .= " AND `exauth_conf_name`=".$this->_db->quoteString($name);
    $sql .= " AND `exauth`=".$this->_db->quoteString($this->_EXAUTH_TYPE);

	return $sql;
}

function get_rows_by_sql( $sql, $limit=0, $offset=0, $key=null, $force=false )
{
	$arr = array();

	$res = $this->_db->query( $sql, $limit, $offset, $force );
	if ( !$res ) { return false; }

	while ( $row = $this->_db->fetchArray($res) ) 
	{
		if ( $key && isset( $row[ $key ] ) ) {
			$arr[ $row[ $key ] ] = $row;
		} else {
			$arr[] = $row;
		}
	}
	return $arr; 
}

// === class end ===

}
?>