<?php
// $Id: Auth.class.php,v 1.3 2011/03/19 16:18:32 ohwada Exp $

//=========================================================
// Twitter Netcommons
// K.OHWADA 2010-08-01
//=========================================================

//---------------------------------------------------------
// change log
// 2011-03-01 K.OHWADA
// auth_is_login_or_redirect_location()
//---------------------------------------------------------

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * @package     NetCommons View
 * @author      Noriko Arai,Ryuji Masukawa
 * @copyright   2006-2007 NetCommons Project
 * @license     http://www.netcommons.org/license.txt  NetCommons License
 * @project     NetCommons Project, supported by National Institute of Informatics
 * @access      public
 */

include_once BASE_DIR."/webapp/modules/twitter/components/Service.class.php";

class Twitter_View_Main_Auth extends Action
{
	// コンポーネントを使用するため
	var $twitterView  = null;

    /**
     * Twitter モジュール
     *
     * @access  public
     */
//---------------------------------------------------------
// Twitter サーバーにリダイレクイトする
//---------------------------------------------------------
    function execute()
    {

// ログインしているか
// ログイン中のとき関連付けでなければ、リダイレクト
		$flag_login = $this->twitterView->auth_is_login_or_redirect_location();

// サービスの初期化
		$twitterService =& new Twitter_Components_Service();
		$ret = $twitterService->init();
		if ( !$ret ) {
			$this->twitterView->redirect_error_msg( 
				$twitterService->get_error_msg(),
				$flag_login );
			exit();
		}

// サービスへのログイン
		$twitterService->login( 
			$this->twitterView->get_base_url() );

// login から戻るときは 常にエラー
		$this->twitterView->redirect_error_msg( 
			$twitterService->get_error_msg(),
			$flag_login );
		exit();
	}

// === class end ===
}
?>