<?php
// $Id: Service.class.php,v 1.3 2011/03/28 10:04:31 ohwada Exp $

//=========================================================
// Twitter Netcommons
// K.OHWADA 2010-08-01
//=========================================================

//---------------------------------------------------------
// change log
// 2011-03-01 K.OHWADA
// $param_auth
//---------------------------------------------------------

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * @package     NetCommons Components
 * @author      Noriko Arai,Ryuji Masukawa
 * @copyright   2006-2007 NetCommons Project
 * @license     http://www.netcommons.org/license.txt  NetCommons License
 * @project     NetCommons Project, supported by National Institute of Informatics
 * @access      public
 */

if ( !defined('_TWITTER_LOADED') ) {

	define('_TWITTER_LOADED', '1' );
	define('TWITTER_DIR', BASE_DIR. '/webapp/modules/twitter/includes' );

	$pear_dir = TWITTER_DIR.'/PEAR';
	set_include_path( get_include_path() . PATH_SEPARATOR . $pear_dir );

	require_once 'Services/Twitter.php';
	require_once 'HTTP/OAuth/Consumer.php';
	require_once TWITTER_DIR.'/class/service.class.php';
}

/**
 * Twitter module auth class
 *
 */
class Twitter_Components_Service 
{
	var	$_container   = null ;
	var	$_modulesView = null ;
	var	$_configView  = null ;
 	var	$_usersView   = null;

	var	$_service = null;

	var	$_screen_name = null;

	var $_error_msg  = null;
	var $_error_code = 0;

/**
 * コンストラクター
 *
 * @access	public
 */
	function Twitter_Components_Service() 
	{
		$this->_container   =& DIContainerFactory::getContainer();
		$this->_modulesView =& $this->_container->getComponent("modulesView");
		$this->_configView  =& $this->_container->getComponent("configView");
 		$this->_usersView   =& $this->_container->getComponent("usersView");

		$this->_service =& new twitter_service();
	}

	function get_error_code() 
	{
		return $this->_error_code ;
	}

	function get_error_msg() 
	{
		return $this->_error_msg ;
	}

//---------------------------------------------------------
// 初期化
//---------------------------------------------------------
	function init() 
	{
		list( $key, $secret ) = $this->get_config_consumer_key();

		if( empty($key) || empty($secret) ) {
			$this->_error_msg = TWITTER_ERR_CONSUMER_KEY;
			return false;
		}

		$this->_service->set_consumer_key(    $key );
		$this->_service->set_consumer_secret( $secret );

		return true;
	}

//---------------------------------------------------------
// Twiiter サーバへのリダイレクト
//---------------------------------------------------------
	function login( $base_url )
	{
		$url_callback = $base_url.'/index.php?action=twitter_view_main_callback';

		$this->_service->set_flag_login( true );
		$this->_service->set_url_callback( $url_callback );

		$ret = $this->_service->login();
		if ( !$ret ) {
			$this->_error_code = $this->_service->get_error_code();
			$this->_error_msg  = $this->_service->get_error_msg();
			return false;
		}
		return true;
	}

//---------------------------------------------------------
// Twitter ID を取得する
//---------------------------------------------------------
	function callback()
	{
		$param_callback = $this->_service->callback();
		if ( !is_array($param_callback) ) {
			$this->_error_code = $this->_service->get_error_code();
			$this->_error_msg  = $this->_service->get_error_msg();
			return false;
		}

		$param_auth = array( 
			TWITTER_ITEM_NAME_ID     => $param_callback['screen_name'] ,
			TWITTER_ITEM_NAME_TOKEN  => $param_callback['token'] ,
			TWITTER_ITEM_NAME_SECRET => $param_callback['token_secret'] ,
		);
		return $param_auth;
	}

//---------------------------------------------------------
// ユーザのパラメータを設定する
//---------------------------------------------------------
	function set_user_param( $user_id ) 
	{
		list( $id, $token, $secret )
			= $this->get_user_token( $user_id );

		if ( empty($id) ||  empty($token) || empty($secret) ) {
			$this->_error_msg = TWITTER_ERR_TWITTER_ID;
			return false;
		}

		$this->_screen_name = $id;
		$this->_service->set_token(        $token );
		$this->_service->set_token_secret( $secret );

		return true;
	}

//---------------------------------------------------------
// ユーザ情報を取得する
//---------------------------------------------------------
	function get_home_user( $flag_convert=true  )
	{
		return $this->get_users_show( 
			$this->_screen_name, $flag_convert );
	}

	function get_users_show( $screen_name, $flag_convert=false  )
	{
		$param = array(
			'screen_name' => $screen_name ,
		);

		$user = $this->_service->get_users_show( $param );

		if ( !$user ) {
			$this->_error_code = $this->_service->get_error_code();
			$this->_error_msg  = $this->_service->get_error_msg();
			return false;
		}
		if ( $flag_convert ) {
			$user = $this->_service->object_to_array( $user );
		}
		return $user;
	}

//---------------------------------------------------------
// timeline を取得する
//---------------------------------------------------------
	function get_home_timeline( $flag_convert=true )
	{
		$items = $this->_service->get_home_timeline();
		if ( !$items ) {
			$this->_error_code = $this->_service->get_error_code();
			$this->_error_msg  = $this->_service->get_error_msg();
			return false;
		}
		if ( $flag_convert ) {
			$items = $this->_service->timeline_to_array( $items );
			$items = $this->_service->convert_timeline(  $items );
		}
		return $items;
	}

//---------------------------------------------------------
// tweet する
//---------------------------------------------------------
	function tweet( $status )
	{
		$ret = $this->_service->tweet( $status );
		if ( !$ret ) {
			$this->_error_code = $this->_service->get_error_code();
			$this->_error_msg  = $this->_service->get_error_msg();
			return false;
		}
		return true;
	}

//---------------------------------------------------------
// consumer_key を取得する
//---------------------------------------------------------
	function get_config_consumer_key()
	{
		$module_id = $this->get_module_id_by_dirname( 'twitter' );
        $config    = $this->get_module_config( $module_id );

		$consumer_key    = $this->get_config_by_key( $config, 'consumer_key' );
		$consumer_secret = $this->get_config_by_key( $config, 'consumer_secret' );

		return array( $consumer_key, $consumer_secret );
	}

	function get_config_by_key( $config, $key )
	{
		$val = isset($config[ $key ]['conf_value']) ? $config[ $key ]['conf_value'] : null;
		return $val;
	}

	function get_module_config( $module_id )
	{
       $config = $this->_configView->getConfig( $module_id, false );
		return $config;
	}

	function get_module_id_by_dirname( $dirname )
	{
	    $module = $this->_modulesView->getModuleByDirname( $dirname );
    	if ( isset($module['module_id']) ) {
			return $module['module_id'];	
		}
		return false;
	}

//---------------------------------------------------------
// user_token を取得する
//---------------------------------------------------------
	function get_user_token( $user_id )
	{
		$id     = $this->get_users_item_link( $user_id, TWITTER_ITEM_NAME_ID );
		$token  = $this->get_users_item_link( $user_id, TWITTER_ITEM_NAME_TOKEN );
		$secret = $this->get_users_item_link( $user_id, TWITTER_ITEM_NAME_SECRET );
		return array( $id, $token, $secret );
	}

	function get_users_item_link( $user_id, $name )
	{
		$item_id = $this->get_item_id_by_name( $name );
		if ( !$item_id ) {
			return false;
		}

		return $this->get_users_item_link_by_id( $user_id, $item_id );
	}

	function get_users_item_link_by_id( $user_id, $item_id )
	{
		$item = $this->_usersView->getUserItemLinkById( $user_id, $item_id );
		if ( isset($item['content']) ) {
			return $item['content'];
		}
		return false;
	}

	function get_item_id_by_name( $name )
	{
		$item_params = array(
			'item_name' => $name
		);

		$items = $this->_usersView->getItems( $item_params );

		$item_id = 0;
		if ( isset($items[0]['item_id']) ) {
			$item_id = $items[0]['item_id'];
		}

		if ( empty($item_id) ) {
			$this->_error_code = 241;
			return false;
		}

		return $item_id;
	}

// === class end ===
}
?>