<?php
// $Id: Tweet.class.php,v 1.4 2011/03/29 12:32:22 ohwada Exp $

//=========================================================
// Twitter Netcommons
// K.OHWADA 2010-08-01
//=========================================================

//---------------------------------------------------------
// change log
// 2011-03-01 K.OHWADA
// get_session_userid_or_redirect_location()
//---------------------------------------------------------

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * @package     NetCommons Action
 * @author      Noriko Arai,Ryuji Masukawa
 * @copyright   2006-2007 NetCommons Project
 * @license     http://www.netcommons.org/license.txt  NetCommons License
 * @project     NetCommons Project, supported by National Institute of Informatics
 * @access      public
 */

include_once BASE_DIR."/webapp/modules/twitter/components/Service.class.php";

class Twitter_Action_Main_Tweet extends Action
{
	// コンポーネントを受け取るため
	var $twitterView   = null;
	var $request       = null;

    /**
     * Twitter モジュール
     *
     * @access  public
     */
//---------------------------------------------------------
// 投稿を行う
//---------------------------------------------------------
    function execute()
    {

// user_id を取得する。
// 取得できないときは、リダイレクトする。
		$user_id = $this->twitterView->get_session_userid_or_redirect_location();

		$code = 0;
		$msg  = null;

// 本文を取得する
		$twitter_status = $this->request->getParameter('twitter_status');

// 空ならば
		if ( empty($twitter_status) ) {
			$this->twitterView->redirect_location_post( 
				11, TWITTER_ERR_TWEET_EMPTY );
			exit();
		}

// 140文字以上ならば
		if ( mb_strlen($twitter_status) > 140 ) {
			$this->twitterView->redirect_location_post(
				 11, TWITTER_ERR_TWEET_OVER_140 );
			exit();
		}

// サービスの初期化
		$twitterService =& new Twitter_Components_Service();
		$ret = $twitterService->init();
		if ( !$ret ) {
			$this->twitterView->redirect_location_post(
				 12, TWITTER_ERR_CONSUMER_KEY );
			exit();
		}

// ユーザの設定
		$ret = $twitterService->set_user_param( $user_id );
		if ( !$ret ) {
			$this->twitterView->redirect_location_post( 13 );
			exit();
		}

// 投稿
		$ret = $twitterService->tweet( $twitter_status );
 		if ( !$ret ) {
			$msg  = TWITTER_ERR_TWEET_POST ;
			$msg .= '<br />';
			$msg .= $twitterService->get_error_msg();
			$this->twitterView->redirect_location_post( 11, $msg );
		}

// 成功
		$this->twitterView->redirect_location_post( 1 );
		exit();
	}

// ===class end ===
}
?>