<?php

//=========================================================
// myalbum Module
// 2007-07-16 K.OHWADA <http://linux2.ohwada.net/>
//=========================================================

// 2008-01-10 K.OHWADA
// package to class
// myalbum can have the file except the photo
// clear mode
// W3C validation: real name in webMaster
// Piclens: not show madia:group

//---------------------------------------------------------
// usage
// rss.php?mode=xxx
// mode : leatst (default), random, clear ( admin only )
//---------------------------------------------------------

include 'header.php';

include_once XOOPS_ROOT_PATH.'/class/template.php';
include_once XOOPS_ROOT_PATH.'/modules/'.$mydirname.'/blocks/myalbum_rphoto.php';

//=========================================================
// class myalbum_build_rss
//=========================================================
class myalbum_build_rss
{
	var $_db;
	var $_myts;

	var $_DIRNAME;
	var $_MOD_PATH;
	var $_MOD_URL;

// http://www.rssboard.org/rss-specification#ltimagegtSubelementOfLtchannelgt
	var $_SITE_IMAGE_WIDTH_MAX      = 144;
	var $_SITE_IMAGE_WIDTH_DEFAULT  =  88;
	var $_SITE_IMAGE_HEIGHT_MAX     = 400;
	var $_SITE_IMAGE_HEIGHT_DEFAULT =  31;

// http://web.resource.org/rss/1.0/spec#s5.5.3
	var $_MAX_SUMMARY = 500;

	var $_SITE_AUTHOR_NAME_UID     = 1;
	var $_SITE_AUTHOR_NAME_DEFAULT = 'xoops';
	var $_SITE_IMAGE_LOGO          = 'images/logo.gif';

	var $_PHOTO_NUM   = 20;
	var $_MEDIA_GROUP = null;

	var $_CACHE_TIME_RAMDOM = 0;	// 1 min
	var $_CACHE_TIME_LATEST = 0;	// 1 hour
	var $_TEMPLATE_RANDOM;
	var $_TEMPLATE_LATEST;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function myalbum_build_rss( $dirname )
{
	$this->_db   =& Database::getInstance();
	$this->_myts =& MyTextSanitizer::getInstance();

	$this->_DIRNAME  = $dirname;
	$this->_MOD_PATH = XOOPS_ROOT_PATH .'/modules/'. $dirname;
	$this->_MOD_URL  = XOOPS_URL       .'/modules/'. $dirname;

	$this->_TEMPLATE_RANDOM = $this->_MOD_PATH.'/templates/rss_random.html';
	$this->_TEMPLATE_LATEST = $this->_MOD_PATH.'/templates/rss_leatest.html';
}

function &getInstance( $dirname )
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new myalbum_build_rss( $dirname );
	}
	return $instance;
}

//---------------------------------------------------------
// modify from backend.php
//---------------------------------------------------------
function build()
{
	global $xoopsConfig, $xoopsModule;

	$mode = '';
	if ( isset($_GET['mode']) )
	{
		$mode = $_GET['mode'];
	}

	switch ( $mode )
	{
		case 'clear':
			$this->_clear_compiled_tpl();
			exit();

		case 'random':
			$TEMPLATE   = $this->_TEMPLATE_RANDOM;
			$CACHE_TIME = $this->_CACHE_TIME_RAMDOM;
			break;

		case 'leatest':
		default:
			$TEMPLATE   = $this->_TEMPLATE_LATEST;
			$CACHE_TIME = $this->_CACHE_TIME_LATEST;
			break;
	}

	if (function_exists('mb_http_output')) 
	{
		mb_http_output('pass');
	}

	header ('Content-Type:text/xml; charset=utf-8');

	$tpl = new XoopsTpl();
	
	if ( $CACHE_TIME > 0 )
	{
		$tpl->xoops_setCaching(2);
		$tpl->xoops_setCacheTime( $CACHE_TIME );
	}

	if ( !$tpl->is_cached( $TEMPLATE ) || ($CACHE_TIME == 0) ) 
	{
		list( $width, $height ) = 
			$this->_get_site_image_logo_size( $this->_SITE_IMAGE_LOGO );

		$title = htmlspecialchars( $xoopsConfig['sitename'], ENT_QUOTES );
		$link  = XOOPS_URL.'/';
		$atom_link = 'http://' . $_SERVER['SERVER_NAME'] . $_SERVER['REQUEST_URI'];
		$webmaster = $xoopsConfig['adminmail'] .' ('. $this->_get_site_author_name() .')';

		$tpl->assign('channel_title',       $this->_utf8( $title ) );
		$tpl->assign('channel_link',        $this->_utf8( $link ) );
		$tpl->assign('channel_atom_link',   $this->_utf8( $atom_link ) );
		$tpl->assign('channel_description', $this->_utf8( htmlspecialchars($xoopsConfig['slogan'], ENT_QUOTES)));
		$tpl->assign('channel_lastbuild', date( 'r', time() ) );
		$tpl->assign('channel_webmaster',      $this->_utf8( $webmaster ) );
		$tpl->assign('channel_managingeditor', $this->_utf8( $webmaster ) );
		$tpl->assign('channel_category',  $this->_utf8( $xoopsModule->name() ) );
		$tpl->assign('channel_generator', 'XOOPS');
		$tpl->assign('channel_language',  _LANGCODE);
		$tpl->assign('channel_docs',      'http://backend.userland.com/rss/' );

		$tpl->assign('image_url',    XOOPS_URL.'/'.$this->_SITE_IMAGE_LOGO );
		$tpl->assign('image_title',  $this->_utf8( $title ) );
		$tpl->assign('image_link',   $this->_utf8( $link ) );
		$tpl->assign('image_width',  $width);
		$tpl->assign('image_height', $height);

		switch ( $mode )
		{
			case 'random':
				$items =& $this->_get_random();
				break;

			case 'leatest':
			default:
				$items =& $this->_get_latest();
				break;
		}

		foreach ($items as $item) 
		{
			$arr = array();
			foreach( $item as $k => $v )
			{
				$arr[$k] = $this->_utf8( $v );
			}
			$tpl->append('items', $arr);
		}
	}

	$tpl->display( $TEMPLATE );
}

function _get_site_image_logo_size( $logo )
{
	$dimention = getimagesize( XOOPS_ROOT_PATH.'/'.$logo );
	
	if (empty($dimention[0])) {
		$width = $this->_SITE_IMAGE_WIDTH_DEFAULT;
	} else {
		$width = ( $dimention[0] > $this->_SITE_IMAGE_WIDTH_MAX ) ? $this->_SITE_IMAGE_WIDTH_MAX : $dimention[0];
	}

	if (empty($dimention[1])) {
		$height = $this->_SITE_IMAGE_HEIGHT_DEFAULT;
	} else {
		$height = ( $dimention[1] > $this->_SITE_IMAGE_HEIGHT_MAX ) ? $this->_SITE_IMAGE_HEIGHT_MAX : $dimention[1];
	}

	return array( $width, $height );
}

function _get_site_author_name()
{
	$name = XoopsUser::getUnameFromId( $this->_SITE_AUTHOR_NAME_UID );
	if ( empty($name) )
	{
		$name = $this->_SITE_AUTHOR_NAME_DEFAULT;
	}
	return $name;
}

//---------------------------------------------------------
// modify from modules/whatsnew/plugins/myalbum/data.inc.php
//---------------------------------------------------------
function _get_latest()
{

//	setting $table_photos, $table_cat, $thumbs_dir
	include $this->_MOD_PATH .'/include/read_configs.php';

	$sql = "SELECT p.lid, p.cid, p.title as ptitle, p.ext, p.hits, p.submitter, p.date, t.description, c.title as ctitle FROM $table_photos p, $table_text t, $table_cat c WHERE t.lid=p.lid AND p.cid=c.cid AND p.status>0 ORDER BY p.date DESC";

	$result = $this->_db->query( $sql, $this->_PHOTO_NUM, 0 ) ;
	$ret = array() ;

	while( $row = $this->_db->fetchArray($result) ) 
	{
		$lid  = $row['lid'];
		$ext  = $row['ext'];
		$file = $lid.'.'.$ext;

		$context = $this->_myts->displayTarea( $row['description'], 0, 1, 1, 1, 1 );

		list($content_url, $content_width, $content_height, $content_type) =
			$this->_get_image_param( $photos_dir, $photos_url, $file );

		list($thumbnail_url, $thumbnail_width, $thumbnail_height, $thumbnail_type) =
			$this->_get_image_param( $thumbs_dir, $thumbs_url, $file );

		$item = array(
			'context'  => $context,
			'link'     => $this->_MOD_URL .'/photo.php?lid='. $lid ,
			'title'    => $row['ptitle'],
			'category' => $row['ctitle'],
			'pubdate'  => date('r', $row['date'] ), 
			'media_content_url'      => $content_url,
			'media_content_height'   => $content_height,
			'media_content_width'    => $content_width,
			'media_content_type'     => $content_type,
			'media_thumbnail_url'    => $thumbnail_url,
			'media_thumbnail_height' => $thumbnail_height,
			'media_thumbnail_width'  => $thumbnail_width,
		);

		$ret[] = $this->_format_item( $item );

	}

	return $ret;
}

//---------------------------------------------------------
// use b_myalbum_rphoto_show
//---------------------------------------------------------
function _get_random()
{
	$options = array(
		0 => $this->_DIRNAME,	// dirname
		1 => 140,	// box_size
		2 => $this->_PHOTO_NUM,	// photos_num
		3 => 0,		// category
		4 => 1,		// sub category
		5 => 60,	// cycle (sec)
		6 => 1,		// cols
	);

	$block = b_myalbum_rphoto_show( $options );

	include XOOPS_ROOT_PATH.'/modules/'.$this->_DIRNAME.'/include/read_configs.php';

	$ret = array();

	foreach( $block['photo'] as $photo )
	{
		$lid  = intval( $photo['lid'] );
		$cid  = intval( $photo['cid'] );
		$ext  = $photo['ext'];
		$file = $lid.'.'.$ext;

		$sql = "SELECT description FROM ".$table_text." WHERE lid=".$lid;
		$res = $this->_db->query( $sql );
		$row = $this->_db->fetchArray( $res );

		$context = $this->_myts->displayTarea( $row['description'] , 0 , 1 , 1 , 1 , 1 );
		$link    = $this->_MOD_URL.'/photo.php?lid='.$lid.'&amp;cid='.$cid;

		list($content_url, $content_width, $content_height, $content_type) =
			$this->_get_image_param( $photos_dir, $photos_url, $file );

		list($thumbnail_url, $thumbnail_width, $thumbnail_height, $thumbnail_type) =
			$this->_get_image_param( $thumbs_dir, $thumbs_url, $file );

		$item = array(
			'context'     => $context,
			'link'        => $link,
			'title'       => $photo['title'],
			'category'    => $photo['cat_title'],
			'pubdate'     => date('r', $photo['unixtime'] ), 
			'media_content_url'      => $content_url,
			'media_content_height'   => $content_height,
			'media_content_width'    => $content_width,
			'media_content_type'     => $content_type,
			'media_thumbnail_url'    => $thumbnail_url,
			'media_thumbnail_height' => $thumbnail_height,
			'media_thumbnail_width'  => $thumbnail_width,
		);

		$ret[] = $this->_format_item( $item );
	}

	return $ret ;
}

//---------------------------------------------------------
// utility
//---------------------------------------------------------
function _format_item( &$item )
{
	$arr =& $item;

	$context = $arr['context'];
	$summary = $this->_build_summary( $context, $this->_MAX_SUMMARY );

	$img  = '<img src="'. $arr['media_thumbnail_url'];
	$img .= '" width="'.  $arr['media_thumbnail_width'];
	$img .= '" height="'. $arr['media_thumbnail_height'];
	$img .= '" alt="'. $arr['title'] .'">';

	$desc = '<a href="'. $arr['link'] .'" target="_blank">'. $img .'</a><br />';

	if ( strlen($context) > $this->_MAX_SUMMARY ) {
		$desc .= $summary;
	} else {
		$desc .= $context;
	}

	$arr['guid']              = $arr['link'];
	$arr['description']       = htmlspecialchars($desc,    ENT_QUOTES);
	$arr['media_description'] = htmlspecialchars($summary, ENT_QUOTES);

	$arr['media_group'] = $this->_MEDIA_GROUP;
	$arr['media_title'] = $arr['title'];

	$arr['media_thumbnail_large_url']    = $arr['media_content_url'];
	$arr['media_thumbnail_large_height'] = $arr['media_content_height'];
	$arr['media_thumbnail_large_width']  = $arr['media_content_width'];

	return $arr;
}

function _get_image_param( $photos_dir, $photos_url, $file )
{
	$photo_path = $photos_dir.'/'.$file;
	$photo_url  = $photos_url.'/'.$file;

	$url     = '';
	$width   = 0;
	$height  = 0;
	$type    = '';

	if ( file_exists( $photo_path ) )
	{
		$url = $photo_url;
		list($width, $height, $type) = 
			$this->_get_image_size( $photo_path );
	}

	return array($url, $width, $height, $type);
}

function _get_image_size( $filename )
{
	$width  = '';
	$height = '';
	$type   = '';

	$size = getimagesize( $filename ) ;
	if ($size)
	{
		$width  = intval( $size[0] );
		$height = intval( $size[1] );
		$type   = $size['mime'];
	}

	return array($width, $height, $type);
}

function _build_summary( $str, $max )
{
	$str = str_replace(">",   "> ", $str);
	$str = strip_tags( $str );

	if ( strlen($str) > $max )
	{
		if ( function_exists('mb_strcut') ) {
			$str = mb_strcut($str, 0, $max);
		} else {
			$str = substr($str, 0, $max);
		}
		$str .= '...';
	}

	return $str;
}

function _utf8($str)
{
	if ( function_exists('mb_convert_encoding') ) {
		$str = mb_convert_encoding($str, 'UTF-8', _CHARSET);
	} else {
		$str = utf8_encode($str);
	}
	return $str;
}

//---------------------------------------------------------
// clear template
//---------------------------------------------------------
function _clear_compiled_tpl()
{
	global $xoopsUser, $xoopsModule;

	if ( is_object($xoopsUser) && $xoopsUser->isAdmin( $xoopsModule->mid() )) 
	{
		$tpl = new XoopsTpl();
		$tpl->clear_compiled_tpl( $this->_TEMPLATE_RANDOM );
		$tpl->clear_compiled_tpl( $this->_TEMPLATE_LATEST );
		echo "template cleared";
	}
}

// --- class end ---
}

//=========================================================
// main
//=========================================================

$myalbum_build_rss =& myalbum_build_rss::getInstance( $mydirname );
$myalbum_build_rss->build();
exit();

?>