<?php
// $Id: whatsnew_rss_builder.php,v 1.4 2007/05/16 09:35:54 ohwada Exp $

// 2007-05-12 K.OHWADA
// module dupulication
// change filename from whatsnew_build_rss.php

// 2006-06-20 K.OHWADA
// REQ 3873: login user can read RSS.
// add is_permit_show() is_use_cache()

// 2006-01-27 K.OHWADA
// REQ 3509: put into spacing in a summary

// 2005-11-16 K.OHWADA
// BUG 3193: error occur in kernel/user.php, if uid is null

// 2005-09-28 K.OHWADA
// change function to class

//=========================================================
// What's New Module
// class RSS builder
// 2004/08/20 K.OHWADA
//=========================================================

// === class begin ===
if( !class_exists('whatsnew_rss_builder') ) 
{

//=========================================================
// class whatsnew_rss_builder
//=========================================================
class whatsnew_rss_builder extends happy_linux_build_rss
{

// class
	var $_class_block;

	var $_config_data;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function whatsnew_rss_builder( $dirname )
{
	$WHATSNEW_ROOT_PATH = XOOPS_ROOT_PATH.'/modules/'.$dirname;
	$TEMPLATE_RDF       = $WHATSNEW_ROOT_PATH.'/templates/xml/build_rdf.html';
	$TEMPLATE_RSS       = $WHATSNEW_ROOT_PATH.'/templates/xml/build_rss.html';
	$TEMPLATE_ATOM      = $WHATSNEW_ROOT_PATH.'/templates/xml/build_atom.html';

	$this->happy_linux_build_rss();
	$this->set_dirname( $dirname );
	$this->set_rdf_template(  $TEMPLATE_RDF );
	$this->set_rss_template(  $TEMPLATE_RSS );
	$this->set_atom_template( $TEMPLATE_ATOM );
	$this->set_generator(  'XOOPS Whatsnew' );
	$this->set_category(   'Whatsnew' );
	$this->set_rdf_title(  'Whatsnew: RDF Feeds' );
	$this->set_rss_title(  'Whatsnew: RSS Feeds' );
	$this->set_atom_title( 'Whatsnew: ATOM Feeds' );
	$this->set_flag_force_build( 1 );	// always build

// class
	$this->_class_block =& whatsnew_show_block::getInstance();
	$this->_class_block->init( $dirname );

}
function &getInstance( $dirname )
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new whatsnew_rss_builder( $dirname );
	}
	return $instance;
}

//---------------------------------------------------------
// init
//---------------------------------------------------------
function init( $mode )
{
	$this->_load_config();
	$this->_init_site_info();

	$this->set_mode( $mode );
	$this->set_items( $this->_get_article() );
}

function _init_site_info()
{
	$this->set_site_name(         $this->_config_data['site_name'] );
	$this->set_site_url(          $this->_config_data['site_url'] );
	$this->set_site_desc(         $this->_config_data['site_desc'] );
	$this->set_site_tag(          $this->_config_data['site_tag'] );
	$this->set_site_author_name(  $this->_config_data['site_author'] );
	$this->set_site_author_email( $this->_config_data['site_email'] );

	$copyright = $this->build_site_copyright( $this->_config_data['site_author'] );
	$this->set_site_copyright( $copyright );

	if ( isset($this->_config_data['site_image_url']) && $this->_config_data['site_image_url'] )
	{
		$this->set_site_image_url(    $this->_config_data['site_image_url'] );
		$this->set_site_image_width(  $this->_config_data['site_image_width'] );
		$this->set_site_image_height( $this->_config_data['site_image_height'] );
		$this->set_site_image_title(  $this->_config_data['site_name'] );
		$this->set_site_image_link(   $this->_config_data['site_url'] );
	}
}

//---------------------------------------------------------
// common
//---------------------------------------------------------
function _build_common_item( $item )
{
	$mid = '';
	$aid = '';
	if ( isset($item['mod_id']) )  $mid = $item['mod_id'];
	if ( isset($item['id']) )      $aid = $item['id'];

	$entry_id = $this->build_entry_id( $mid, $aid );

// author
// BUG 3193: occure error in kernel/user.php, if uid is null
	$author_name  = '';
	$author_uri   = '';
	$author_email = '';
	if ( isset($item['uid']) && $item['uid'] )
	{
		$uid = intval( $item['uid'] );

		if ( $uid > 0 )
		{
			$user = new xoopsUser( intval($item['uid']) );
			$author_name  = $user->getvar('uname');
			$author_uri   = $user->getvar('url');
			if ( $user->getvar('user_viewemail') )
			{
				$author_email = $user->getvar('email');
			}
		}
	}

// title content 
	$title_xml    = $this->_build_xml_title(   $item['title'] );
	$content_xml  = $this->_build_xml_content( $item['description'] );
	$sum_xml      = $this->_build_xml_summary( $item['description'], 0, 0 );
	$category_xml = $this->_xml( $item['mod_name'] );

// sanitize
	$link_xml        = $this->_xml_url( $item['link'] );
	$author_name_xml = $this->_xml( $author_name );

// time
	if ( isset($item['modified']) )
	{
		$updated_unix = $item['modified'];
	}
	elseif( isset($item['time']) )
	{
		$updated_unix = $item['time'];
	}
	else
	{
		$updated_unix = time();
	}

	if ( isset($item['issued']) )
	{
		$published_unix = $item['issued'];
	}
	else
	{
		$published_unix = $updated_unix;
	}

	$published_rfc822_xml  = $this->_xml( date("r", $published_unix ) );
	$updated_rfc822_xml    = $this->_xml( date("r", $updated_unix ) );
	$published_iso8601_xml = $this->_xml( $this->_iso8601_date( $published_unix ) );
	$updated_iso8601_xml   = $this->_xml( $this->_iso8601_date( $updated_unix ) );

	$ret = array(
		'id'                => $aid,
		'link'              => $link_xml,
		'guid'              => $link_xml,
		'entry_id'          => $this->_xml( $entry_id ),
		'author_uri'        => $this->_xml_url( $author_uri ),
		'author_email'      => $this->_xml(     $author_email ),
		'author_name'       => $author_name_xml,
		'title'             => $title_xml,
		'summary'           => $sum_xml,
		'description'       => $sum_xml,
		'content'           => $content_xml,
		'category'          => $category_xml,
		'published_unix'    => $published_unix,    // unixtime
		'updated_unix'      => $updated_unix,  // unixtime
		'published_rfc822'  => $published_rfc822_xml,
		'date_rfc822'       => $published_rfc822_xml,
		'updated_rfc822'    => $updated_rfc822_xml,
		'published_iso8601' => $published_iso8601_xml,
		'date_iso8601'      => $published_iso8601_xml,
		'updated_iso8601'   => $updated_iso8601_xml,
		'dc_subject'        => $category_xml,
		'dc_creator'        => $author_name_xml,
		'dc_date'           => $published_iso8601_xml,
		'content_encoded'   => $content_xml,
	);

	return $ret;
}

//-----------------------------------------------
// use class show block
//-----------------------------------------------
function _load_config()
{
	$this->_config_data =& $this->_class_block->get_config_data();
}

function &_get_article()
{
	$ret =& $this->_class_block->collect_block_date('rss');
	return $ret;
}

// --- class end ---
}

// === class end ===
}

?>