<?php
// $Id: weblinks_link_check_handler.php,v 1.7 2007/03/06 02:01:51 ohwada Exp $

// 2007-03-01 K.OHWADA
// small change check()
// small change get_no_check()

// 2006-10-05 K.OHWADA
// use happy_linux
// remove refresh_link() refresh_site()
// use weblinks_locate_factory

// 2006-05-15 K.OHWADA
// use new handler

// 2006-01-01 K.OHWADA
// weblinks ver 1.0
// module depulication

//=========================================================
// WebLinks Module
// 2004-10-20 K.OHWADA
//=========================================================

//---------------------------------------------------------
// use rss_atom_collect_handler, cannot define in constructor
//---------------------------------------------------------

// === class begin ===
if( !class_exists('weblinks_link_check_handler') ) 
{

//=========================================================
// class weblinks_link_check_handler
// this class is used by command line
//=========================================================
class weblinks_link_check_handler
{
	var $flag_broken;	// view broken colum
	var $flag_echo;
	var $flag_echo_lid;

	var $flag_write;
	var $fp_result;

	var $total_site_rss;
	var $total_link;
	var $num_link_check;
	var $num_link_broken;
	var $num_clear_atomfeed;
	var $link_broken_arr;

	var $num_refresh_rss_url;
	var $num_refresh_rss_site;
	var $num_refresh_atom_site;
	var $num_refresh_atomfeed;

// handler
	var $_collect_hanlder;
	var $_link_handler;
	var $_atomfeed_handler;

// class constance
	var $_lang_local;
	var $_remote;

	var $_dirname;


//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_link_check_handler( $dirname )
{
	$this->_dirname = $dirname;

	$this->flag_broken   = 0;
	$this->flag_echo     = 1;
	$this->flag_write    = 0;
	$this->flag_echo_lid = 0;

	unset($this->fp_result);

// handler
	$this->_link_handler  =& weblinks_get_handler( 'link_basic',  $dirname );

// class constance
	$this->_locate  =& weblinks_locate_factory::getInstance( $dirname );
	$this->_remote  =& happy_linux_remote_file::getInstance();
}

//---------------------------------------------------------
// check link broken
//---------------------------------------------------------
function check($limit=0, $offset=0)
{
	$this->_locate->weblinks_init();

	$link_broken_count = 0;
	$link_broken_arr   = array();

	$this->total_link = $this->_link_handler->get_count_all();

	$lid_array =& $this->_link_handler->get_lid_array_all($limit, $offset);
	$lid_num   = count( $lid_array );
	$this->num_link_check = $lid_num;

// BUG 2827: RSS refresh: Invalid argument supplied for foreach()
	if ($lid_num == 0)
	{
		$data = $this->get_no_check();
		$this->echo_write_data($data);
		return true;	// no action
	}

	$lid_start = $lid_array[0];
	$lid_end   = $lid_array[$lid_num - 1];

	$time_start = time();

// --- check start ---
	$data = $this->get_check_html_start();
	$this->echo_write_data($data);

// proc by record
	foreach($lid_array as $lid)
	{
		$row =& $this->_link_handler->get_row_by_id($lid);
		$title    = $row['title'];
		$url      = $row['url'];
		$rss_flag = $row['rss_flag'];

		if ( $this->flag_echo_lid )
		{
			echo $lid."\n";
		}

// next, if url is null
		if (empty($url)) continue;

// link check
		if ( !$this->_remote->check_url($url) )
  		{
			$this->_link_handler->countup_broken($lid);

		    $link_broken_count ++;
		    $link_broken_arr[] = array($lid, $title, $url);
		}

	}

// --- check end ---
	$this->link_broken_arr     = $link_broken_arr;
	$this->num_link_broken     = $link_broken_count;

	$data = $this->get_check_html_end( $time_start, $lid_start, $lid_end);
	$this->echo_write_data($data);

	return true;	// OK
}

//---------------------------------------------------------
// print HTML for check
//---------------------------------------------------------
function get_check_html_start()
{
	$time_now  = $this->get_time_now();
	$text  = "<h4>"._WEBLINKS_ADMIN_LINK_BROKEN_CHECK."</h4>\n";
	$text .= _WEBLINKS_ADMIN_TIME_START." $time_now<br /><br />\n";
	return $text;
}

function get_check_html_end( $time_start, $lid_start, $lid_end)
{
	$time_now    = $this->get_time_now();
	$time_elapse = $this->get_time_elapse($time_start);

	$text  = '';

	if ($this->num_link_broken)
	{
		$text .= $this->get_check_table_start();

		foreach ($this->link_broken_arr as $broken)
		{
			list($lid, $title, $url) = $broken;
    		$text .= $this->get_check_table_line($lid, $title, $url);
		}

		$text .= $this->get_table_end();

		$link_broken = "<font color='red'>$this->num_link_broken</font>";
	}
	else
	{
		$link_broken = $this->num_link_broken;
	}

	$text .= _WEBLINKS_ADMIN_TIME_END." $time_now<br /><br />\n";
	$text .= "<table><tr>";
	$text .= "<tr><td>"._WEBLINKS_ADMIN_LINK_NUM_ALL."</td>";
	$text .= "<td>$this->total_link "._WEBLINKS_ADMIN_NUM."</td></tr>\n";
	$text .= "<tr><td>"._WEBLINKS_ADMIN_LINK_NUM_CHECK."</td>";

	if ($lid_start)
	{
		$text .= "<td>$this->num_link_check "._WEBLINKS_ADMIN_NUM." ( "._WLS_LINKID." $lid_start - $lid_end )</td></tr>\n";
	}
	else
	{
		$text .= "<td>$this->num_link_check "._WEBLINKS_ADMIN_NUM."</td></tr>\n";
	}

	$text .= "<tr><td>"._WEBLINKS_ADMIN_LINK_NUM_BROKEN."</td>";
	$text .= "<td>$link_broken "._WEBLINKS_ADMIN_NUM."</td></tr>\n";
	$text .= "<tr><td>"._WEBLINKS_ADMIN_NUM_REFRESH_RSS_URL."</td>";
	$text .= "<td>$this->num_refresh_rss_url "._WEBLINKS_ADMIN_NUM."</td></tr>\n";
	$text .= "<tr><td>"._WEBLINKS_ADMIN_TIME_ELAPSE."</td>";
	$text .= "<td>$time_elapse</td></tr>\n";
	$text .= "</table>\n";

	return $text;
}

function get_check_table_start()
{
	$text = _WEBLINKS_ADMIN_LINK_BROKEN_CHECK_NOTICE;
	$text .= _WEBLINKS_ADMIN_LINK_BROKEN_CHECK_GOOGLE;
	$text .= "<br />\n";
	$text .= "<table border='1'><tr>";
	$text .= "<th align='center'>"._WLS_LINKID."</th>";
	$text .= "<th align='center'>"._WLS_SITETITLE."</th>";
	$text .= "<th align='center'>"._WLS_SITEURL."</th>";

	if ($this->flag_broken)
	{	$text .= "<th align='center'>"._WEBLINKS_ADMIN_BROKEN."</th>";	}

	$text .= "</tr>\n";

	return $text;
}

function get_check_table_line($lid, $title, $url, $broken='')
{
	$link_id = sprintf("%03d",$lid);

	$modlink = XOOPS_URL.'/modules/'.$this->_dirname.'/admin/link_manage.php?op=modLink&lid='.$lid;
	$title   = htmlspecialchars($title);

	$text  = "<tr>";
	$text .= "<td><a href='$modlink'>$link_id</a></td>";

	$google_url = $this->_locate->build_google_search_url($title);
	$text  .= '<td><a href="'.$google_url.'" target="_blank">'.$title.'</a></td>';

	$text .= "<td><a href='$url' target='_blank'>$url</a></td>";

	if ($this->flag_broken)
	{	$text .= "<td>$broken</td>";	}

	$text .= "</tr>\n";

	return $text;
}

function get_table_end()
{
	return "</table><br />\n";
}

function echo_write_data($data)
{
	if ($this->flag_echo)
	{
		echo $data;
	}

	if ($this->flag_write)
	{
		fwrite($this->fp_result, $data);
	}
}

function get_no_check()
{
	$text  = "<h4>"._WEBLINKS_ADMIN_LINK_BROKEN_CHECK."</h4>\n";
	$text .= _WEBLINKS_ADMIN_NO_LINK_BROKEN_CHECK."<br /><br />\n";

	return $text;
}

//---------------------------------------------------------
// print HTML for refresh
//---------------------------------------------------------
function get_refresh_html_start()
{
	$time_now = $this->get_time_now();
	$text  = "<h4>"._WEBLINKS_ADMIN_RSS_REFRESH."</h4>\n";
	$text .= _WEBLINKS_ADMIN_TIME_START." $time_now<br /><br />\n";
	return $text;
}

function get_refresh_html_end( $time_start, $lid_start, $lid_end)
{
	$time_now    = $this->get_time_now();
	$time_elapse = $this->get_time_elapse($time_start);

	$text = '';

	if ($this->num_link_broken)
	{
		$text .= $this->get_refresh_table_start();

		foreach ($this->link_broken_arr as $broken)
		{
			list($lid, $title, $rss_url) = $broken;
    		$text .= $this->get_refresh_table_line($lid, $title, $rss_url);
		}

		$text .= $this->get_table_end();

		$link_broken = "<font color='red'>$this->num_link_broken</font>";
	}
	else
	{
		$link_broken = $this->num_link_broken;
	}

	$text .= _WEBLINKS_ADMIN_TIME_END." $time_now<br /><br />\n";
	$text .= "<table><tr>";
	$text .= "<tr><td>"._WLS_SITE_RSS."</td>";
	$text .= "<td>$this->total_site_rss "._WEBLINKS_ADMIN_NUM."</td></tr>\n";
	$text .= "<tr><td>"._WEBLINKS_ADMIN_LINK_NUM_CHECK."</td>";

	if ($lid_start)
	{
		$text .= "<td>$this->num_link_check "._WEBLINKS_ADMIN_NUM." ( "._WLS_LINKID." $lid_start - $lid_end )</td></tr>\n";
	}
	else
	{
		$text .= "<td>$this->num_link_check "._WEBLINKS_ADMIN_NUM."</td></tr>\n";
	}

	$text .= "<tr><td>"._WEBLINKS_ADMIN_LINK_NUM_BROKEN."</td>";
	$text .= "<td>$link_broken "._WEBLINKS_ADMIN_NUM."</td></tr>\n";
	$text .= "<tr><td>"._WEBLINKS_ADMIN_NUM_REFRESH_RSS_SITE."</td>";
	$text .= "<td>$this->num_refresh_rss_site "._WEBLINKS_ADMIN_NUM."</td></tr>\n";
	$text .= "<tr><td>"._WEBLINKS_ADMIN_NUM_REFRESH_ATOMFEED."</td>";
	$text .= "<td>$this->num_refresh_atomfeed "._WEBLINKS_ADMIN_NUM."</td></tr>\n";
	$text .= "<tr><td>"._WEBLINKS_NUM_RSS_CLEAR_ATOMFEED."</td>";
	$text .= "<td>$this->num_clear_atomfeed "._WEBLINKS_ADMIN_NUM."</td></tr>\n";
	$text .= "<tr><td>"._WEBLINKS_ADMIN_TIME_ELAPSE."</td>";
	$text .= "<td>$time_elapse</td></tr>\n";
	$text .= "</table>\n";

	return $text;
}


function get_refresh_table_start()
{
	$text  = "<br />\n";
	$text .= "<table border='1'><tr>";
	$text .= "<th align='center'>"._WLS_LINKID."</th>";
	$text .= "<th align='center'>"._WLS_SITETITLE."</th>";
	$text .= "<th align='center'>"._WLS_RSS_URL."</th>";
	$text .= "</tr>\n";

	return $text;
}

function get_refresh_table_line($lid, $title, $rss_url)
{
	$link_id = sprintf("%03d",$lid);

	$modlink = XOOPS_URL.'/modules/'.$this->_dirname.'/admin/link_manage.php?op=modLink&lid='.$lid;
	$title   = htmlspecialchars($title);

	$text  = "<tr>";
	$text .= "<td><a href='$modlink'>$link_id</a></td>";
	$text .= "<td>$title</td>";
	$text .= "<td><a href='$rss_url' target='_blank'>$rss_url</a></td>";
	$text .= "</tr>\n";

	return $text;
}

function get_no_refresh()
{
	$text  = "<h4>"._WEBLINKS_ADMIN_RSS_REFRESH."</h4>\n";
	$text .= _WEBLINKS_ADMIN_NO_RSS_REFRESH."<br />\n";

	return $text;
}

//---------------------------------------------------------
// time
//---------------------------------------------------------
function get_time_now()
{
	$text = date("Y-m-d H:i:s");
	return $text;
}

function get_time_elapse($time_start)
{
	$time = time() - $time_start;
	$min  = intval($time/60);
	$sec  = $time - 60*$min;
	$text = sprintf(_WEBLINKS_ADMIN_MIN_SEC, $min, $sec);
	return $text;
}

//---------------------------------------------------------
// set and get parameter
//---------------------------------------------------------
function set_flag_broken($value)
{
	$this->flag_broken = intval($value);
}

function set_flag_echo($value)
{
	$this->flag_echo = intval($value);
}

function set_flag_echo_lid($value)
{
	$this->flag_echo_lid = intval($value);
}

function set_write($fp)
{
	$this->fp_result  = $fp;
	$this->flag_write = 1;
}

function get_link_count_all()
{
	$count = $this->_link_handler->get_count_all();
	return $count;
}

// --- class end ---
}

// === class end ===
}

?>