<?php
// $Id: weblinks_banner_handler.php,v 1.3 2007/05/10 00:59:21 ohwada Exp $

// 2007-05-06 K.OHWADA
// remove image_list_width

// 2007-03-01 K.OHWADA
// change build_show_image

//=========================================================
// WebLinks Module
// 2006-12-10 K.OHWADA
//=========================================================

// === class begin ===
if( !class_exists('weblinks_banner_handler') ) 
{

//=========================================================
// class weblinks_banner_handler
//=========================================================
class weblinks_banner_handler extends happy_linux_error
{
	var $_DIRNAME;

	var $_config_handler;
	var $_link_handler;
	var $_remote_image;
	var $_image_size;
	var $_strings;

	var $_conf;

//-----------------------------------------------
// This is for lower compatibility of mylinks
//-----------------------------------------------
	var $_DIR_SHOTS = 'images/shots/';

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_banner_handler( $dirname )
{
	$this->happy_linux_error();

	$this->_DIRNAME = $dirname;

	$this->_config_handler =& weblinks_get_handler('config2_basic', $dirname );
	$this->_link_handler   =& weblinks_get_handler( 'link_basic',     $dirname );
	$this->_remote_image   =& happy_linux_remote_image::getInstance();
	$this->_image_size     =& happy_linux_image_size::getInstance();
	$this->_strings        =& happy_linux_strings::getInstance();

	$this->_conf =& $this->_config_handler->get_conf();
}

//---------------------------------------------------------
// show banner
//---------------------------------------------------------
function &build_show_image( $banner, $width, $height )
{
	$image_url    = '';
	$link_width   = 0;
	$link_height  = 0;
	$list_width   = 0;
	$list_height  = 0;

	if ( $banner )
	{
		$image_url = $this->_assume_banner_url($banner);

// size exist
		if ($width && $height)
		{
			list ($list_width, $list_height) 
				= $this->_image_size->adjust_size($width, $height, $this->_conf['list_image_width'], $this->_conf['list_image_height'] );

			list ($link_width, $link_height) 
				= $this->_image_size->adjust_size($width, $height, $this->_conf['link_image_width'], $this->_conf['link_image_height'] );
		}

		$image_url = $this->_strings->sanitize_url($image_url);
	}

	$arr = array(
		'image_url'          => $image_url,
		'image_link_width'   => $link_width,
		'image_link_height'  => $link_height,
		'image_list_width'   => $list_width,
		'image_list_height'  => $list_height,
	);

	return $arr;
}

function _assume_banner_url($banner)
{
	if ( empty($banner) ) { return $banner; }

// URL style: "http://" or "https://"
	$url = $banner;
	if ( preg_match("|^https?://|", $url) )
	{
		return $url;
	}

// abbreviated style
	$url  = XOOPS_URL       . $banner;
	$file = XOOPS_ROOT_PATH . $banner;

// if exist 
	$fp = fopen($file, "r");
	if ($fp)
	{
		return $url;
	}

// mylinks style
	$url  = XOOPS_URL       . '/modules/'.$this->_DIRNAME.'/'.$this->_DIR_SHOTS.'/'.$banner;
	$file = XOOPS_ROOT_PATH . '/modules/'.$this->_DIRNAME.'/'.$this->_DIR_SHOTS.'/'.$banner;

// if exist 
	$fp = fopen($file, "r");
	if ($fp)
	{
		return $url;
	}

	return false;
}

//---------------------------------------------------------
// get banner size
//---------------------------------------------------------
function &get_remote_banner_size( $banner )
{
	$size = array(0, 0, 0, '');

	if ( empty($banner) )
	{
		return $size;
	}

	$url = $this->_assume_banner_url($banner);

	$size =& $this->_remote_image->get_image_size($url);
	if (!$size)
	{
		$this->_set_error_code( $this->_remote_image->getErrorCode() );
		$this->_set_errors(     $this->_remote_image->getErrors() );
	}

	return $size;
}

// --- class end ---
}

// === class end ===
}

?>