<?php
// $Id: index.php,v 1.13 2007/03/06 02:01:50 ohwada Exp $

// 2007-03-01 K.OHWADA
// assign weblinks_category_navi
// expand subcategories
// happy_linux_time

// 2006-10-14 K.OHWADA
// show execution time

// 2006-10-01 K.OHWADA
// use happy_linux
// use rssc WEBLINKS_RSSC_USE

// 2006-09-24 K.OHWADA
// BUG 4278: cannot set no link list on the top page

// 2006-05-15 K.OHWADA
// new handler

// 2006-03-26 K.OHWADA
// REQ 3807: Description in main page

// 2006-01-01 K.OHWADA
// weblinks ver 1.0
// module depulication

//================================================================
// WebLinks Module
// 2004/01/14 K.OHWADA
//================================================================

include 'header.php';

$weblinks_view_handler  =& weblinks_get_handler( 'link_view',     WEBLINKS_DIRNAME );
$weblinks_rssc_handler  =& weblinks_get_handler( 'rssc',          WEBLINKS_DIRNAME );
$weblinks_template      =& weblinks_template::getInstance( WEBLINKS_DIRNAME );

//---------------------------------------------------------
// config check
//---------------------------------------------------------
$is_admin = $weblinks_view_handler->is_admin();
if ( $is_admin )
{
	include_once XOOPS_ROOT_PATH.'/modules/happy_linux/class/config_base_handler.php';
	include_once XOOPS_ROOT_PATH.'/modules/happy_linux/class/config_store_handler.php';
	include_once WEBLINKS_ROOT_PATH.'/class/weblinks_config2_define_handler.php';
	include_once WEBLINKS_ROOT_PATH.'/class/weblinks_linkitem_define_handler.php';
	include_once WEBLINKS_ROOT_PATH.'/class/weblinks_config_check_handler.php';

	$weblinks_check_handler =& weblinks_get_handler( 'config_check',  WEBLINKS_DIRNAME );

	if ( !$weblinks_check_handler->check_init() )
	{
		include XOOPS_ROOT_PATH.'/header.php';
		$weblinks_check_handler->print_style_sheet();
		$weblinks_check_handler->print_form_init( 'admin/index.php' );
		include XOOPS_ROOT_PATH.'/footer.php';
		exit();
	}

	if ( $is_admin && !$weblinks_check_handler->check_version() )
	{
		include XOOPS_ROOT_PATH.'/header.php';
		$weblinks_check_handler->print_style_sheet();
		$weblinks_check_handler->print_form_upgrade( 'admin/index.php' );
		include XOOPS_ROOT_PATH.'/footer.php';
		exit();
	}
}

//---------------------------------------------------------
// main
//---------------------------------------------------------
$MAX_CATEGORY_COLS = 3;

// --- template start ---
// xoopsOption[template_main] should be defined before including header.php
$xoopsOption['template_main'] = WEBLINKS_DIRNAME."_index.html";
include XOOPS_ROOT_PATH.'/header.php';

$conf = $weblinks_view_handler->get_config();
$conf_cat_sub         = $conf['cat_sub'];
$conf_cat_img_mode    = $conf['cat_img_mode'];
$conf_newlinks        = $conf['newlinks'];
$conf_rss_max_summary = $conf['rss_max_summary'];
$conf_rss_new         = $conf['rss_new'];

$weblinks_view_handler->set_highlight( true );
$weblinks_view_handler->set_keyword_by_request();
$keywords = $weblinks_view_handler->get_keywords_urlencode();

// Index
$weblinks_template->set_keywords_urlencode( $keywords );
$weblinks_template->assignIndex();
$weblinks_template->assignDisplayLink();
$weblinks_template->assignSearch();

// REQ 3807: Description in main page
$weblinks_template->assignHeader( true );

$xoopsTpl->assign('keywords',  $keywords);

// --- category list ---
$weblinks_view_handler->init();

$pid          = 0;
$flag_image   = 1;
$flag_catpath = 0;
$category_list = $weblinks_view_handler->get_category_list_by_pid($pid, $flag_image, $flag_catpath, $conf_cat_sub);

$show_category_navi = 0;
$category_navi      = '';
if ( is_array($category_list) && count($category_list) )
{
	$show_category_navi = 1;
	$category_navi = $weblinks_template->fetch_category_navi( $category_list, $conf_cat_img_mode, $MAX_CATEGORY_COLS, $keywords );
}

$xoopsTpl->assign('show_category_navi',     $show_category_navi);
$xoopsTpl->assign('weblinks_category_navi', $category_navi);

// --- link list ---
$total_link = $weblinks_view_handler->get_link_count_public();
$xoopsTpl->assign('lang_thereare', sprintf(_WLS_THEREARE, $total_link));

// BUG 4278: cannot set no link list on the top page
$show_links_list = 0;
$links_list      = '';

if ($conf_newlinks)
{
	$link_list =& $weblinks_view_handler->get_link_list_latest( $conf_newlinks );
	if ( is_array($link_list) && count($link_list) )
	{
		$show_links_list = 1;
		$links_list = $weblinks_template->fetch_links_list( $link_list );
	}
}

$xoopsTpl->assign('show_links_list',     $show_links_list);
$xoopsTpl->assign('weblinks_links_list', $links_list);

// --- atomfeed list ---
$show_new_atomfeed = 0;
$show_feeds_list   = 0;

if ( WEBLINKS_RSSC_USE && $conf_rss_new )
{
	$show_new_atomfeed = 1;
	$weblinks_rssc_handler->set_feed_max_summary(  $conf_rss_max_summary );
	$feed_list = $weblinks_rssc_handler->get_feed_list_latest( $conf_rss_new );

	if ( is_array($feed_list) && count($feed_list) )
	{
		foreach ($feed_list as $feed) 
		{
			$xoopsTpl->append('feeds', $feed);
		}

		$show_feeds_list = 1;
	}
}

$xoopsTpl->assign('show_new_atomfeed', $show_new_atomfeed);
$xoopsTpl->assign('show_feeds_list',   $show_feeds_list);

$xoopsTpl->assign('execution_time', $happy_linux_time->get_elapse_time() );
include XOOPS_ROOT_PATH.'/footer.php';
exit();
// --- main end ---

?>