<?php
// $Id: weblinks_plugin.php,v 1.1 2007/02/27 14:50:16 ohwada Exp $

//=========================================================
// WebLinks Module
// 2007-02-20 K.OHWADA
//=========================================================

// === class begin ===
if( !class_exists('weblinks_plugin') ) 
{

//=========================================================
// class weblinks_plugin
//=========================================================
class weblinks_plugin
{
	var $_DIRNAME;
	var $_conf;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_plugin($dirname)
{
	$this->_DIRNAME = $dirname;

	$config_handler =& weblinks_get_handler( 'config2_basic',  $dirname );
	$this->_conf    =& $config_handler->get_conf();
}

function &getInstance($dirname)
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new weblinks_plugin($dirname);
	}

	return $instance;
}

//=========================================================
// function 
//=========================================================
function &get_forum_sel_options()
{
	$arr2    = array();
	$arr2[0] = '---';

	$forum_sel =& weblinks_plugin_forum_sel();
	if ( is_array($forum_sel) && count($forum_sel) )
	{
		foreach ($forum_sel as $k => $v)
		{
			$arr2[$k] = $v['description'];
		}
	}

	$arr3 = array_flip($arr2);
	return $arr3;
}

function get_forum_sel_value_by_conf($conf_name, $key)
{
	$val = false;

	$conf_forum_sel = $this->_conf[$conf_name];
	$forum_sel =& weblinks_plugin_forum_sel();

	if ( isset($forum_sel[ $conf_forum_sel ]) )
	{
		$sel =& $forum_sel[ $conf_forum_sel ];
		if ( isset($sel[$key]) )
		{
			$val = $sel[$key];
		}
	}

	return $val;
}

function &get_forums_by_conf($conf_name)
{
	$plugin_name = $this->get_forum_sel_value_by_conf($conf_name, 'name');
	$arr =& $this->get_plugin_forums( $plugin_name );
	return $arr;
}

function &get_options_by_conf($conf_name)
{
	$arr2    = array();
	$arr2[0] = '---';

	$plugin_name = $this->get_forum_sel_value_by_conf($conf_name, 'name');

	$arr1 =& $this->get_plugin_forums( $plugin_name );
	if ( is_array($arr1) && count($arr1) )
	{
		foreach ($arr1 as $k => $v)
		{
			$arr2[$k] = $v;
		}
	}
	$arr3 = array_flip($arr2);
	return $arr3;
}

function &get_threads_by_conf( $conf_name, $forum_id, $thread_limit=1, $post_limit=1, $post_order_num=0 )
{
	$plugin_name = $this->get_forum_sel_value_by_conf($conf_name, 'name');
	if ( empty($plugin_name) )
	{
		$false = false;
		return $false;
	}

	switch ($post_order_num)
	{
		case 0:
			$post_order = 'DESC';
			break;

		case 0:
		default:
			$post_order = 'ASC';
			break;
	}

	$thread_start = 0;
	$post_start   = 0;

	$arr =& $this->get_plugin_threads( $plugin_name, $forum_id, $thread_limit, $thread_start, $post_limit, $post_start );
	return $arr;
}

function &get_plugin_forums( $plugin_name )
{
	$arr = array();
	$file = '/modules/'.$this->_DIRNAME.'/plugins/'.$plugin_name.'.php';
	$func = 'weblinks_plugin_forums_'.$plugin_name;

	if ( file_exists( XOOPS_ROOT_PATH.'/'.$file ) )
	{
		include_once XOOPS_ROOT_PATH.'/'.$file;
	}
	else
	{
		return $arr;
	}

	if ( function_exists($func) )
	{
		$arr =& $func();
	}

	return $arr;
}

function &get_plugin_threads( $plugin_name, $forum_id, $thread_limit=1, $thread_start=0, $post_limit=1, $post_start=0, $post_order='DESC' )
{
	$arr = array();
	$file = '/modules/'.$this->_DIRNAME.'/plugins/'.$plugin_name.'.php';
	$func = 'weblinks_plugin_threads_'.$plugin_name;

	if ( file_exists( XOOPS_ROOT_PATH.'/'.$file ) )
	{
		include_once XOOPS_ROOT_PATH.'/'.$file;
	}
	else
	{
		return $arr;
	}

	if ( function_exists($func) )
	{
		$arr =& $func($forum_id, $thread_limit, $thread_start, $post_limit, $post_start, $post_order);
	}

	return $arr;
}

// --- class end ---
}

// === class end ===
}

?>