<?php
// $Id: weblinks_menu.php,v 1.3 2006/10/30 15:05:16 ohwada Exp $

// 2006-10-30 K.OHWADA
// BUG 4344: Error message: Table 'weblinks_config2' doesn't exist
// add exists_table()

// 2006-05-15 K.OHWADA
// this is new file

//=========================================================
// WebLinks Module
// 2006-05-15 K.OHWADA
//=========================================================

// === class begin ===
if( !class_exists('weblinks_menu') ) 
{

//=========================================================
// class weblinks_menu
// this class is used by xoops_version.php
// this class handle MySQL table directly
// this class does not use another class
//=========================================================
class weblinks_menu
{
// class instance
	var $_db;

	var $_table_config;
	var $_table_category;

// variable
	var $_config_cached;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_menu( $dirname )
{
// class instance
	$this->_db =& Database::getInstance();

	$this->_table_config   = $this->_db->prefix( $dirname.'_config2' );
	$this->_table_category = $this->_db->prefix( $dirname.'_category' );

	$this->load();
}

function &getInstance( $dirname )
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new weblinks_menu( $dirname );
	}

	return $instance;
}

//=========================================================
// function for MySQL table
//=========================================================
function load()
{
	static $flag_init_load;

	if ( !isset($flag_init_load) ) 
	{
		$flag_init_load = 1;

		$arr =& $this->get_config();

		if ( isset( $arr['auth_submit'] ) )
		{
			$arr['auth_submit_arr'] = unserialize( $arr['auth_submit'] );
		}

		$this->_config_cached = $arr;
	}
}

function get_by_name($name)
{
	if ( isset( $this->_config_cached[$name] ) )
	{
		$ret = $this->_config_cached[$name];
		return $ret;
	}

	return false;
}

//---------------------------------------------------------
// get from DB
//---------------------------------------------------------
function &get_config()
{
	$arr = array();

// BUG 4344: Error message: Table 'weblinks_config2' doesn't exist
	if ( $this->exists_table( $this->_table_config ) )
	{
		$sql = 'SELECT * FROM '.$this->_table_config.' ORDER BY conf_id ASC';
		$res = $this->_db->query( $sql );

		while ( $row = $this->_db->fetchArray($res) )
		{
			$arr[ $row['conf_name'] ] = $row['conf_value'];
		}
	}

	return $arr;
}

function &get_top_category()
{
	$arr = array();

	$sql = 'SELECT * FROM '.$this->_table_category.' WHERE pid=0 ORDER BY orders, cid';
	$res = $this->_db->query( $sql );

	while ( $row = $this->_db->fetchArray($res) )
	{
		$arr[] = $row;
	}

	return $arr;
}

//---------------------------------------------------------
// exists table
//---------------------------------------------------------
function exists_table($table)
{
	$sql = "SHOW TABLES";

	$res = $this->_db->queryF($sql); 
	if ( !$res ) 
	{	return false;	}

	$table_name = strtolower( $table );

	while ($myrow = $this->_db->fetchRow($res)) 
	{
		$name = strtolower( $myrow[0] );

		if ( $name == $table_name )
		{
			return true;
		}
	}

	return false;
}

//---------------------------------------------------------
// get param
//---------------------------------------------------------
function show_submit()
{
	$ret = $this->get_perm_submit();
	return $ret;
}

function show_hits()
{
	$ret = $this->get_by_name('use_hits');
	return $ret;
}

function show_rating()
{
	$ret = $this->get_by_name('use_ratelink');
	return $ret;
}

function &get_catlist()
{
	$arr = array();

	if ( $this->get_by_name('show_catlist') )
	{
		$arr =& $this->get_top_category();
	}

	return $arr;
}

//---------------------------------------------------------
// permission
//---------------------------------------------------------
function get_perm_submit()
{
	if ( $this->is_xoops_module_admin() )
	{
		return true;
	}

	$auth_arr = $this->get_by_name('auth_submit_arr');
	if ( !is_array($auth_arr) )
	{
		return false;
	}

	$groups = $this->get_xoops_groups();

	if ( array_intersect( $auth_arr, $groups ) )
	{
		return true;
	}

	return false;
}

//---------------------------------------------------------
// xoops system parameter
//---------------------------------------------------------
function is_xoops_module_admin()
{
	global $xoopsUser, $xoopsModule;

	if ( is_object($xoopsUser) && is_object($xoopsModule) )
	{
		if ( $xoopsUser->isAdmin( $xoopsModule->mid() )) 
		{
			return true;
		}
	}

	return false;
}

function get_xoops_groups()
{
	global $xoopsUser;
	$groups = array();

	if ( is_object($xoopsUser) )
	{
		$groups = $xoopsUser->getGroups();
	}
	else
	{
		$groups = array( XOOPS_GROUP_ANONYMOUS );
	}

	return $groups;
}

// --- class end ---
}

// === class end ===
}

?>