<?php
// $Id: weblinks_linkitem_define_handler.php,v 1.4 2006/12/22 15:17:05 ohwada Exp $

// 2006-12-10 K.OHWADA
// add data_type save_mode search_mode
// add time_publish textarea1
// add get_save_mode_list() get_search_list()

// 2006-10-01 K.OHWADA
// renewal order
// use rssc
// add rssc_lid
// google map

// 2006-05-15 K.OHWADA
// this is new file
// use new handler

//================================================================
// WebLinks Module
// this file contain 2 class
//   weblinks_linkitem_define
//   weblinks_linkitem_define_handler
// 2006-05-15 K.OHWADA
//================================================================

// === class begin ===
if( !class_exists('weblinks_linkitem_define_handler') ) 
{

//=========================================================
// class weblinks_linkitem_define
//=========================================================
class weblinks_linkitem_define
{
// user_mode
//   0: not use
//   1: use
//   2: indispensable
//
// conf_form
//   0: not show
//   1: show
//   2: fixed
//
// save_mode
//   0: admin & user cannot save 
//   1: admin & user can save
//   2: admin can save, user cannot

	var $_cached = array();

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_linkitem_define()
{
	// dummy
}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new weblinks_linkitem_define();
	}

	return $instance;
}

//---------------------------------------------------------
// function
//---------------------------------------------------------
function &get_define()
{

//---------------------------------------------------------
// basic config
//---------------------------------------------------------
	 $config[1]['name']       = 'mid';
	 $config[1]['title']      = _WEBLINKS_MID;
	 $config[1]['user_mode']  = 1;
	 $config[1]['user_form']  = 'mid';
	 $config[1]['admin_form'] = 'mid';
	 $config[1]['conf_form']  = 0;

	 $config[2]['name']       = 'lid';
	 $config[2]['title']      = _WLS_LINKID;
	 $config[2]['user_mode']  = 1;
	 $config[2]['user_form']  = 'lid';
	 $config[2]['admin_form'] = 'lid';
	 $config[2]['conf_form']  = 0;
	 $config[2]['save_mode']  = 1;

// rssc
	 $config[3]['name']       = 'rssc_lid';
	 $config[3]['title']      = _WEBLINKS_RSSC_LID;
	 $config[3]['user_mode']  = 1;
	 $config[3]['user_form']  = 'none';
	 $config[3]['admin_form'] = 'rssc_lid';
	 $config[3]['conf_form']  = 0;

	 $config[4]['name']       = 'uid';
	 $config[4]['title']      = _WEBLINKS_USERID;
	 $config[4]['user_mode']  = 0;
	 $config[4]['user_form']  = 'none';
	 $config[4]['admin_form'] = 'uid';
	 $config[4]['conf_form']  = 0;

	 $config[5]['name']       = 'time_create';
	 $config[5]['title']      = _WEBLINKS_CREATE;
	 $config[5]['user_mode']  = 0;
	 $config[5]['admin_form'] = 'time_create';
	 $config[5]['conf_form']  = 0;

	 $config[6]['name']       = 'time_update';
	 $config[6]['title']      = _WLS_LASTUPDATE;
	 $config[6]['user_mode']  = 0;
	 $config[6]['user_form']  = 'none';
	 $config[6]['admin_form'] = 'time_update';
	 $config[6]['conf_form']  = 2;
	 $config[6]['options']    = array(
		_WLS_NOTTIMEUPDATE => 0,
		_WLS_TIMEUPDATE    => 1
	);

	 $config[101]['name']        = 'time_publish';
	 $config[101]['title']       = _WEBLINKS_TIME_PUBLISH;
	 $config[101]['user_mode']   = 0;
	 $config[101]['admin_form']  = 'time_publish';
	 $config[101]['conf_form']   = 2;
	 $config[101]['data_type']  = 'int_time_select';
	 $config[101]['save_mode']   = 2;

	 $config[102]['name']        = 'time_expire';
	 $config[102]['title']       = _WEBLINKS_TIME_EXPIRE;
	 $config[102]['user_mode']   = 0;
	 $config[102]['admin_form']  = 'time_expire';
	 $config[102]['conf_form']   = 2;
	 $config[102]['data_type']  = 'int_time_select';
	 $config[102]['save_mode']   = 2;

	 $config[7]['name']       = 'recommend';
	 $config[7]['title']      = _WLS_SITE_RECOMMEND;
	 $config[7]['user_mode']  = 0;
	 $config[7]['user_form']  = 'none';
	 $config[7]['admin_form'] = 'checkbox';
	 $config[7]['data_type']  = 'int_checkbox';
	 $config[7]['conf_form']  = 0;
	 $config[7]['save_mode']  = 2;
	 $config[7]['options']     = array(
		_WLS_SITE_RECOMMEND => 1,
	);

	 $config[8]['name']       = 'mutual';
	 $config[8]['title']      = _WLS_SITE_MUTUAL;
	 $config[8]['user_mode']  = 0;
	 $config[8]['user_form']  = 'none';
	 $config[8]['admin_form'] = 'checkbox';
	 $config[8]['data_type']  = 'int_checkbox';
	 $config[8]['conf_form']  = 0;
 	 $config[8]['save_mode']  = 2;
	 $config[8]['options']     = array(
		_WLS_SITE_MUTUAL => 1,
	);

	 $config[9]['name']       = 'cids';
	 $config[9]['title']      = _WLS_CATEGORY;
	 $config[9]['user_mode']  = 0;
	 $config[9]['user_form']  = 'none';
	 $config[9]['admin_form'] = 'none';
	 $config[9]['conf_form']  = 0;

	 $config[11]['name']        = 'title';
	 $config[11]['title']       = _WLS_SITETITLE;
	 $config[11]['user_mode']   = 2;
	 $config[11]['user_form']   = 'text';
	 $config[11]['admin_form']  = 'text';
	 $config[11]['conf_form']   = 2;
	 $config[11]['save_mode']   = 1;
	 $config[11]['search_mode'] = 1;

	 $config[12]['name']       = 'cat';
	 $config[12]['title']      = _WLS_CATEGORY;
	 $config[12]['user_mode']  = 2;
	 $config[12]['user_form']  = 'cat';
	 $config[12]['admin_form'] = 'cat';
	 $config[12]['conf_form']  = 2;

	 $config[13]['name']        = 'url';
	 $config[13]['title']       = _WLS_SITEURL;
	 $config[13]['user_mode']   = 2;
	 $config[13]['user_form']   = 'url';
	 $config[13]['admin_form']  = 'url';
	 $config[13]['conf_form']   = 1;
	 $config[13]['save_mode']   = 1;
	 $config[13]['search_mode'] = 1;

	 $config[14]['name']       = 'description';
	 $config[14]['title']      = _WLS_DESCRIPTION;
	 $config[14]['user_mode']  = 2;
	 $config[14]['user_form']  = 'desc';
	 $config[14]['admin_form'] = 'desc';
	 $config[14]['conf_form']  = 1;
	 $config[14]['save_mode']  = 1;

	 $config[15]['name']       = 'dohtml';
	 $config[15]['title']      = 'dohtml';
	 $config[15]['user_mode']  = 0;
	 $config[15]['user_form']  = 'none';
	 $config[15]['admin_form'] = 'none';
	 $config[15]['data_type']  = 'int_checkbox';
	 $config[15]['conf_form']  = 0;
	 $config[15]['options']    = array(
		_WEBLINKS_DOHTML => 1,
	);

	 $config[16]['name']       = 'dosmiley';
	 $config[16]['title']      = 'dosmiley';
	 $config[16]['user_mode']  = 0;
	 $config[16]['user_form']  = 'none';
	 $config[16]['admin_form'] = 'none';
	 $config[16]['data_type']  = 'int_checkbox';
	 $config[16]['conf_form']  = 0;
	 $config[16]['options']    = array(
		_WEBLINKS_DOSMILEY => 1,
	);

	 $config[17]['name']       = 'doxcode';
	 $config[17]['title']      = 'doxcode';
	 $config[17]['user_mode']  = 0;
	 $config[17]['user_form']  = 'none';
	 $config[17]['admin_form'] = 'none';
	 $config[17]['data_type']  = 'int_checkbox';
	 $config[17]['conf_form']  = 0;
	 $config[17]['options']    = array(
		_WEBLINKS_DOXCODE => 1,
	);

	 $config[18]['name']       = 'doimage';
	 $config[18]['title']      = 'doimage';
	 $config[18]['user_mode']  = 0;
	 $config[18]['user_form']  = 'none';
	 $config[18]['admin_form'] = 'none';
	 $config[18]['data_type']  = 'int_checkbox';
	 $config[18]['conf_form']  = 0;
	 $config[18]['options']    = array(
		_WEBLINKS_DOIMAGE => 1,
	);

	 $config[19]['name']       = 'dobr';
	 $config[19]['title']      = 'dobr';
	 $config[19]['user_mode']  = 0;
	 $config[19]['user_form']  = 'none';
	 $config[19]['admin_form'] = 'none';
	 $config[19]['data_type']  = 'int_checkbox';
	 $config[19]['conf_form']  = 0;
	 $config[19]['options']    = array(
		_WEBLINKS_DOBREAK => 1,
	);

	 $config[21]['name']       = 'broken';
	 $config[21]['title']      = _WLS_BROKEN_COUNTER;
	 $config[21]['user_mode']  = 0;
	 $config[21]['user_form']  = 'none';
	 $config[21]['admin_form'] = 'broken';
	 $config[21]['conf_form']  = 0;
	 $config[21]['save_mode']  = 2;

//---------------------------------------------------------
// admin can change title & mode
//---------------------------------------------------------
	 $config[31]['name']       = 'banner';
	 $config[31]['title']      = _WLS_BANNERURL;
	 $config[31]['user_mode']  = 1;
	 $config[31]['user_form']  = 'url';
	 $config[31]['admin_form'] = 'banner';
	 $config[31]['conf_form']  = 1;
	 $config[31]['save_mode']  = 1;

	 $config[32]['name']       = 'width';
	 $config[32]['title']      = 'width';
	 $config[32]['user_mode']  = 0;
	 $config[32]['user_form']  = 'none';
	 $config[32]['admin_form'] = 'banner_size';
	 $config[32]['conf_form']  = 0;

	 $config[33]['name']       = 'height';
	 $config[33]['title']      = 'height';
	 $config[33]['user_mode']  = 0;
	 $config[33]['user_form']  = 'none';
	 $config[33]['admin_form'] = 'banner_size';
	 $config[33]['conf_form']  = 0;

	 $config[34]['name']       = 'rss_url';
	 $config[34]['title']      = _WLS_RSS_URL;
	 $config[34]['user_mode']  = 1;
	 $config[34]['user_form']  = 'rss_url';
	 $config[34]['admin_form'] = 'rss_url';
	 $config[34]['conf_form']  = 1;

	 $config[35]['name']       = 'rss_flag';
	 $config[35]['title']      = 'rss_flag';
	 $config[35]['user_mode']  = 1;
	 $config[35]['user_form']  = 'none';
	 $config[35]['admin_form'] = 'none';
	 $config[35]['conf_form']  = 0;
	 $config[35]['options']    = array(
		_WLS_RSS_URL_0 => 0,
		_WLS_RSS_URL_2 => 2,
		_WLS_RSS_URL_1 => 1,
		_WLS_RSS_URL_3 => 3,
	);

	 $config[36]['name']       = 'name';
	 $config[36]['title']      = _WLS_NAME;
	 $config[36]['user_mode']  = 1;
	 $config[36]['user_form']  = 'name';
	 $config[36]['admin_form'] = 'name';
	 $config[36]['conf_form']  = 1;
	 $config[36]['save_mode']  = 1;

	 $config[37]['name']       = 'nameflag';
	 $config[37]['title']      = 'nameflag';
	 $config[37]['user_mode']  = 0;
	 $config[37]['user_form']  = 'none';
	 $config[37]['admin_form'] = 'none';
	 $config[37]['conf_form']  = 0;
	 $config[37]['save_mode']  = 1;
	 $config[37]['options']    = array(
		_WLS_NOTPUBLIC => 0,
		_WLS_PUBLIC    => 1,
	);

	 $config[38]['name']       = 'mail';
	 $config[38]['title']      = _WLS_EMAIL;
	 $config[38]['user_mode']  = 1;
	 $config[38]['user_form']  = 'mail';
	 $config[38]['admin_form'] = 'mail';
	 $config[38]['conf_form']  = 1;
	 $config[38]['save_mode']  = 1;

	 $config[39]['name']       = 'mailflag';
	 $config[39]['title']      = 'mailflag';
	 $config[39]['user_mode']  = 0;
	 $config[39]['user_form']  = 'none';
	 $config[39]['admin_form'] = 'none';
	 $config[39]['conf_form']  = 0;
	 $config[39]['save_mode']  = 1;
	 $config[39]['options']    = array(
		_WLS_NOTPUBLIC => 0,
		_WLS_PUBLIC    => 1,
	);

	 $config[41]['name']        = 'company';
	 $config[41]['title']       = _WLS_COMPANY;
	 $config[41]['user_mode']   = 1;
	 $config[41]['user_form']   = 'text';
	 $config[41]['admin_form']  = 'text';
	 $config[41]['conf_form']   = 1;
	 $config[41]['save_mode']   = 1;
	 $config[41]['search_mode'] = 1;

	 $config[42]['name']        = 'zip';
	 $config[42]['title']       = _WLS_ZIP;
	 $config[42]['user_mode']   = 1;
	 $config[42]['user_form']   = 'text';
	 $config[42]['admin_form']  = 'text';
	 $config[42]['conf_form']   = 1;
	 $config[42]['save_mode']   = 1;
	 $config[42]['search_mode'] = 1;

	 $config[43]['name']        = 'state';
	 $config[43]['title']       = _WLS_STATE;
	 $config[43]['user_mode']   = 1;
	 $config[43]['user_form']   = 'text';
	 $config[43]['admin_form']  = 'text';
	 $config[43]['conf_form']   = 1;
	 $config[43]['save_mode']   = 1;
	 $config[43]['search_mode'] = 1;

	 $config[44]['name']        = 'city';
	 $config[44]['title']       = _WLS_CITY;
	 $config[44]['user_mode']   = 1;
	 $config[44]['user_form']   = 'text';
	 $config[44]['admin_form']  = 'text';
	 $config[44]['conf_form']   = 1;
	 $config[44]['save_mode']   = 1;
	 $config[44]['search_mode'] = 1;

	 $config[45]['name']        = 'addr';
	 $config[45]['title']       = _WLS_ADDR;
	 $config[45]['user_mode']   = 1;
	 $config[45]['user_form']   = 'text';
	 $config[45]['admin_form']  = 'text';
	 $config[45]['conf_form']   = 1;
	 $config[45]['save_mode']   = 1;
	 $config[45]['search_mode'] = 1;

	 $config[46]['name']        = 'addr2';
	 $config[46]['title']       = _WLS_ADDR2;
	 $config[46]['user_mode']   = 1;
	 $config[46]['user_form']   = 'text';
	 $config[46]['admin_form']  = 'text';
	 $config[46]['conf_form']   = 1;
	 $config[46]['save_mode']   = 1;
	 $config[46]['search_mode'] = 1;

	 $config[47]['name']        = 'tel';
	 $config[47]['title']       = _WLS_TEL;
	 $config[47]['user_mode']   = 1;
	 $config[47]['user_form']   = 'text';
	 $config[47]['admin_form']  = 'text';
	 $config[47]['conf_form']   = 1;
	 $config[47]['save_mode']   = 1;
	 $config[47]['search_mode'] = 1;

	 $config[48]['name']        = 'fax';
	 $config[48]['title']       = _WLS_FAX;
	 $config[48]['user_mode']   = 1;
	 $config[48]['user_form']   = 'text';
	 $config[48]['admin_form']  = 'text';
	 $config[48]['conf_form']   = 1;
	 $config[48]['save_mode']   = 1;
	 $config[48]['search_mode'] = 1;

	 $config[49]['name']       = 'map_use';
	 $config[49]['title']      = _WEBLINKS_MAP_USE;
	 $config[49]['user_mode']  = 1;
	 $config[49]['user_form']  = 'yesno';
	 $config[49]['admin_form'] = 'yesno';
	 $config[49]['conf_form']  = 1;
	 $config[49]['save_mode']  = 1;

// google map: hacked by wye
	 $config[51]['name']        = 'gm_latitude';
	 $config[51]['title']       = _WEBLINKS_GM_LATITUDE;
	 $config[51]['user_mode']   = 0;
	 $config[51]['user_form']   = 'gm_latitude';
	 $config[51]['admin_form']  = 'gm_latitude';
	 $config[51]['conf_form']   = 1;
	 $config[51]['save_mode']   = 1;

	 $config[52]['name']        = 'gm_longitude';
	 $config[52]['title']       = _WEBLINKS_GM_LONGITUDE;
	 $config[52]['user_mode']   = 0;
	 $config[52]['user_form']   = 'text';
	 $config[52]['admin_form']  = 'text';
	 $config[52]['conf_form']   = 1;
	 $config[52]['save_mode']   = 1;

	 $config[53]['name']        = 'gm_zoom';
	 $config[53]['title']       = _WEBLINKS_GM_ZOOM;
	 $config[53]['user_mode']   = 0;
	 $config[53]['user_form']   = 'text';
	 $config[53]['admin_form']  = 'text';
	 $config[53]['conf_form']   = 1;
	 $config[53]['save_mode']   = 1;

// etc
	 $config[61]['name']        = 'etc1';
	 $config[61]['title']       = _WEBLINKS_ETC.' 1';
	 $config[61]['user_mode']   = 0;
	 $config[61]['user_form']   = 'text';
	 $config[61]['admin_form']  = 'text';
	 $config[61]['conf_form']   = 1;
	 $config[61]['save_mode']   = 1;
	 $config[61]['search_mode'] = 1;

	 $config[62]['name']        = 'etc2';
	 $config[62]['title']       = _WEBLINKS_ETC.' 2';
	 $config[62]['user_mode']   = 0;
	 $config[62]['user_form']   = 'text';
	 $config[62]['admin_form']  = 'text';
	 $config[62]['conf_form']   = 1;
	 $config[62]['save_mode']   = 1;
	 $config[62]['search_mode'] = 1;

	 $config[63]['name']        = 'etc3';
	 $config[63]['title']       = _WEBLINKS_ETC.' 3';
	 $config[63]['user_mode']   = 0;
	 $config[63]['user_form']   = 'text';
	 $config[63]['admin_form']  = 'text';
	 $config[63]['conf_form']   = 1;
	 $config[63]['save_mode']   = 1;
	 $config[63]['search_mode'] = 1;

	 $config[64]['name']        = 'etc4';
	 $config[64]['title']       = _WEBLINKS_ETC.' 4';
	 $config[64]['user_mode']   = 0;
	 $config[64]['user_form']   = 'text';
	 $config[64]['admin_form']  = 'text';
	 $config[64]['conf_form']   = 1;
	 $config[64]['save_mode']   = 1;
	 $config[64]['search_mode'] = 1;

	 $config[65]['name']        = 'etc5';
	 $config[65]['title']       = _WEBLINKS_ETC.' 5';
	 $config[65]['user_mode']   = 0;
	 $config[65]['user_form']   = 'text';
	 $config[65]['admin_form']  = 'text';
	 $config[65]['conf_form']   = 1;
	 $config[65]['save_mode']   = 1;
	 $config[65]['search_mode'] = 1;

	 $config[66]['name']        = 'usercomment';
	 $config[66]['title']       = _WLS_USER_COMMENT;
	 $config[66]['description'] = _WLS_NOT_DISPLAY;
	 $config[66]['user_mode']   = 1;
	 $config[66]['user_form']   = 'textarea';
	 $config[66]['admin_form']  = 'textarea';
	 $config[66]['conf_form']   = 1;
	 $config[66]['save_mode']   = 1;
 
	 $config[91]['name']       = 'textarea1';
	 $config[91]['title']      = _WEBLINKS_TEXTAREA.' 1';;
	 $config[91]['user_mode']  = 0;
	 $config[91]['user_form']  = 'none';
	 $config[91]['admin_form'] = 'dhtml';
	 $config[91]['conf_form']  = 2;
	 $config[91]['save_mode']  = 2;

	 $config[92]['name']       = 'dohtml1';
	 $config[92]['title']      = 'dohtml1';
	 $config[92]['user_mode']  = 0;
	 $config[92]['user_form']  = 'none';
	 $config[92]['admin_form'] = 'none';
	 $config[92]['data_type']  = 'int_checkbox';
	 $config[92]['conf_form']  = 0;
	 $config[92]['save_mode']  = 2;
	 $config[92]['options']    = array(
		_WEBLINKS_DOHTML => 1,
	);

	 $config[93]['name']       = 'dosmiley1';
	 $config[93]['title']      = 'dosmiley1';
	 $config[93]['user_mode']  = 0;
	 $config[93]['user_form']  = 'none';
	 $config[93]['admin_form'] = 'none';
	 $config[93]['data_type']  = 'int_checkbox';
	 $config[93]['conf_form']  = 0;
	 $config[93]['save_mode']  = 2;
	 $config[93]['options']    = array(
		_WEBLINKS_DOSMILEY => 1,
	);

	 $config[94]['name']       = 'doxcode1';
	 $config[94]['title']      = 'doxcode1';
	 $config[94]['user_mode']  = 0;
	 $config[94]['user_form']  = 'none';
	 $config[94]['admin_form'] = 'none';
	 $config[94]['data_type']  = 'int_checkbox';
	 $config[94]['conf_form']  = 0;
	 $config[94]['save_mode']  = 2;
	 $config[94]['options']    = array(
		_WEBLINKS_DOXCODE => 1,
	);

	 $config[95]['name']       = 'doimage1';
	 $config[95]['title']      = 'doimage1';
	 $config[95]['user_mode']  = 0;
	 $config[95]['user_form']  = 'none';
	 $config[95]['admin_form'] = 'none';
	 $config[95]['data_type']  = 'int_checkbox';
	 $config[95]['conf_form']  = 0;
	 $config[95]['save_mode']  = 2;
	 $config[95]['options']    = array(
		_WEBLINKS_DOIMAGE => 1,
	);

	 $config[96]['name']       = 'dobr1';
	 $config[96]['title']      = 'dobr1';
	 $config[96]['user_mode']  = 0;
	 $config[96]['user_form']  = 'none';
	 $config[96]['admin_form'] = 'none';
	 $config[96]['data_type']  = 'checkbox';
	 $config[96]['conf_form']  = 0;
	 $config[96]['save_mode']  = 2;
	 $config[96]['options']    = array(
		_WEBLINKS_DOBREAK => 1,
	);

	 $config[97]['name']       = 'textarea2';
	 $config[97]['title']      = _WEBLINKS_TEXTAREA.' 2';;
	 $config[97]['user_mode']  = 0;
	 $config[97]['user_form']  = 'none';
	 $config[97]['admin_form'] = 'textarea';
	 $config[97]['conf_form']  = 2;
	 $config[97]['save_mode']  = 2;
	 $config[97]['order']      = 65;

	 $config[68]['name']       = 'passwd';
	 $config[68]['title']      = _US_PASSWORD;
	 $config[68]['user_mode']  = 1;
	 $config[68]['user_form']  = 'passwd';
	 $config[68]['admin_form'] = 'passwd';
	 $config[68]['conf_form']  = 2;

	 $config[69]['name']        = 'notify';
	 $config[69]['title']       = _WLS_OPTIONS;
	 $config[69]['user_mode']   = 1;
	 $config[69]['user_form']   = 'notify';
	 $config[69]['admin_form']  = 'notify';
	 $config[69]['conf_form']   = 0;
	 $config[69]['options']     = array(
		_WLS_NOTIFYAPPROVE => 1,
	);

//---------------------------------------------------------
// admin cannot change
//---------------------------------------------------------
	 $config[71]['name']       = 'hits';
	 $config[71]['title']      = _WLS_HITS;
	 $config[71]['user_mode']  = 0;
	 $config[71]['user_form']  = 'none';
	 $config[71]['admin_form'] = 'label';
	 $config[71]['conf_form']  = 2;
	 $config[71]['save_mode']  = 1;

	 $config[72]['name']       = 'rating';
	 $config[72]['title']      = _WLS_RATING;
	 $config[72]['user_mode']  = 0;
	 $config[72]['user_form']  = 'none';
	 $config[72]['admin_form'] = 'label_float';
	 $config[72]['conf_form']  = 2;
	 $config[72]['save_mode']  = 1;

	 $config[73]['name']       = 'votes';
	 $config[73]['title']      = _WLS_VOTE;
	 $config[73]['user_mode']  = 0;
	 $config[73]['user_form']  = 'none';
	 $config[73]['admin_form'] = 'label_float';
	 $config[73]['conf_form']  = 0;
	 $config[73]['save_mode']  = 1;

	 $config[74]['name']       = 'comments';
	 $config[74]['title']      = _COMMENTS;
	 $config[74]['user_mode']  = 0;
	 $config[74]['user_form']  = 'none';
	 $config[74]['admin_form'] = 'label';
	 $config[74]['conf_form']  = 2;
	 $config[74]['save_mode']  = 1;

	 $config[75]['name']        = 'admincomment';
	 $config[75]['title']       = _WLS_ADMINCOMMENT;
	 $config[75]['user_mode']   = 0;
	 $config[75]['user_form']   = 'none';
	 $config[75]['admin_form']  = 'admincomment';
	 $config[75]['conf_form']   = 2;
	 $config[75]['save_mode']   = 1;
	 $config[75]['search_mode'] = 1;

//---------------------------------------------------------
// admin cannot change
// program create automatically
//---------------------------------------------------------
	 $config[81]['name']       = 'search';
	 $config[81]['title']      = 'search';
	 $config[81]['user_mode']  = 0;
	 $config[81]['user_form']  = 'none';
	 $config[81]['admin_form'] = 'none';
	 $config[81]['conf_form']  = 0;

	 $config[82]['name']       = 'mark';
	 $config[82]['title']      = 'mark';
	 $config[82]['user_mode']  = 0;
	 $config[82]['user_form']  = 'none';
	 $config[82]['admin_form'] = 'none';
	 $config[82]['conf_form']  = 0;

	 $config[83]['name']       = 'rss_xml';
	 $config[83]['title']      = 'rss_xml';
	 $config[83]['user_mode']  = 0;
	 $config[83]['user_form']  = 'none';
	 $config[83]['admin_form'] = 'none';
	 $config[83]['conf_form']  = 0;

	 $config[84]['name']       = 'rss_update';
	 $config[84]['title']      = 'rss_update';
	 $config[84]['user_mode']  = 0;
	 $config[84]['user_form']  = 'none';
	 $config[84]['user_form']  = 'time';
	 $config[84]['conf_form']  = 0;

	 $config[85]['name']       = 'approve';
	 $config[85]['title']      = 'approve';
	 $config[85]['user_mode']  = 0;
	 $config[85]['user_form']  = 'none';
	 $config[85]['admin_form'] = 'hidden';
	 $config[85]['conf_form']  = 0;

//---------------------------------------------------------
// textartea    (91-99)
// time_publish (101-109)
//---------------------------------------------------------

	return $config;
}

//---------------------------------------------------------
// load
//---------------------------------------------------------
function load()
{
	$this->_cached = $this->get_define();
	return $this->_cached;
}

function get_cache_by_itemid_key($id, $key)
{
	if ( isset( $this->_cached[$id][$key] ) )
	{
		$val = $this->_cached[$id][$key];
		return $val;
	}

	return false;
}

// --- class end ---
}


//=========================================================
// class weblinks_linkitem_define_handler
//=========================================================
class weblinks_linkitem_define_handler
{
	var $_linkitem_handler; 
	var $_linkitem_define;

// cache
	var $_cached_by_itemid = array();
	var $_cached_by_name   = array();

	var $_is_module_admin;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_linkitem_define_handler( $dirname )
{
	$this->_linkitem_handler =& weblinks_get_handler('linkitem', $dirname);
	$this->_linkitem_define  =& weblinks_linkitem_define::getInstance();

	$system =& happy_linux_system::getInstance();
	$this->_is_module_admin = $system->is_module_admin();
}

function &getInstance( $dirname )
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new weblinks_linkitem_define_handler( $dirname );
	}

	return $instance;
}

//---------------------------------------------------------
// load
//---------------------------------------------------------
function &load()
{
	$def_arr = $this->_linkitem_define->load();
	$this->_linkitem_handler->load();

	$this->_cached_by_itemid = array();
	$this->_cached_by_name   = array();

	foreach ($def_arr as $id => $def )
	{
		$name        = $this->_linkitem_define->get_cache_by_itemid_key($id, 'name');
		$title_def   = $this->_linkitem_define->get_cache_by_itemid_key($id, 'title');
		$desc        = $this->_linkitem_define->get_cache_by_itemid_key($id, 'description');
		$user_form   = $this->_linkitem_define->get_cache_by_itemid_key($id, 'user_form');
		$admin_form  = $this->_linkitem_define->get_cache_by_itemid_key($id, 'admin_form');
		$conf_form   = $this->_linkitem_define->get_cache_by_itemid_key($id, 'conf_form');
		$save_mode   = $this->_linkitem_define->get_cache_by_itemid_key($id, 'save_mode');
		$search_mode = $this->_linkitem_define->get_cache_by_itemid_key($id, 'search_mode');
		$data_type   = $this->_linkitem_define->get_cache_by_itemid_key($id, 'data_type');
		$opt         = $this->_linkitem_define->get_cache_by_itemid_key($id, 'options');
		$title       = $this->_linkitem_handler->get_cache_by_itemid_key($id, 'title');
		$user_mode   = $this->_linkitem_handler->get_cache_by_itemid_key($id, 'user_mode');

		$arr = array(
			'item_id'     => $id,
			'name'        => $name,
			'title'       => htmlspecialchars($title, ENT_QUOTES),
	 		'user_mode'   => $user_mode,
			'title_def'   => $title_def,
			'description' => $desc,
	 		'user_form'   => $user_form,
	 		'admin_form'  => $admin_form,
	 		'conf_form'   => $conf_form,
	 		'user_mode'   => $user_mode,
	 		'save_mode'   => $save_mode,
	 		'search_mode' => $search_mode,
	 		'data_type'   => $data_type,
	 		'options'     => $opt,
		);

		$this->_cached_by_itemid[ $id ] = $arr;
		$this->_cached_by_name[ $name ] = $arr;
	}

	return $this->_cached_by_itemid;

}

//---------------------------------------------------------
// get cache
//---------------------------------------------------------
function &get_cached_by_itemid()
{
	return $this->_cached_by_itemid;
}

function &get_cached_by_name()
{
	return $this->_cached_by_name;
}

function get_by_itemid($id, $key)
{
	if ( isset( $this->_cached_by_itemid[$id][$key] ) )
	{
		$val = $this->_cached_by_itemid[$id][$key];
		return $val;
	}

	return false;
}

function get_by_name($name, $key)
{
	if ( isset( $this->_cached_by_name[$name][$key] ) )
	{
		$val = $this->_cached_by_name[$name][$key];
		return $val;
	}

	return false;
}

function build_caption_by_itemid($id, $flag=0, $extra='')
{
	$mode      = $this->get_by_itemid($id, 'user_mode');
	$title     = $this->get_by_itemid($id, 'title');
	$title_def = $this->get_by_itemid($id, 'title_def');
	$desc      = $this->get_by_itemid($id, 'description');
	$cap       = $this->build_caption($title, $desc, $title_def, $mode, $flag, $extra);
	return $cap;
}

function build_caption($title, $desc='', $title_def='', $mode=0, $flag=0, $extra='')
{
	if ($mode == 2)
	{
		$cap = "<span style='font-weight:bold;'> * $title * </span>";
	}
	else
	{
		$cap = "<span style='font-weight:normal;'>".$title."</span>";
	}

	if ( $flag &&( $title != $title_def ) )
	{
		$cap .= "<br />\n";
		$cap .= "<span style='font-weight:normal;'> ( ".$title_def." ) </span>";
	}

	if ( $extra )
	{
		$cap .= "<br />\n";
		$cap .= "<span style='font-weight:normal;'>".$extra."</span>";
	}

	if ($desc)
	{
		$cap .= "<br /><br />\n";
		$cap .= "<span style='font-weight:normal;'>".$desc."</span>";
	}

	return $cap;
}

function &get_save_mode_list()
{
	$list = array();

	foreach ($this->_cached_by_name as $name => $item)
	{
		$flag = false;

		if ( ($item['save_mode'] == 1) && ( ($item['user_mode'] > 0)||$this->_is_module_admin) )
		{
			$flag = true;
		}
		elseif ( ($item['save_mode'] == 2) && $this->_is_module_admin )
		{
			$flag = true;
		}

		$list[$name] = $flag;
	}

	$list['nameflag'] = $list['name'];
	$list['mailflag'] = $list['mail'];
	$list['width']    = $list['banner'];
	$list['height']   = $list['banner'];

	return $list;
}

function &get_search_list()
{
	$list = array();
	foreach ($this->_cached_by_name as $name => $item)
	{
		if ( $item['search_mode'] )
		{
			$list[$name] = true;
		}
	}
	return $list;
}

// --- class end ---
}

// === class end ===
}

?>