<?php
// $Id: weblinks_link_view_edit.php,v 1.4 2006/12/22 17:20:51 ohwada Exp $

// 2006-12-10 K.OHWADA
// use banner_handler
// add build_show_basic()
// add build_show_flag_time_publish()

// 2006-10-14 K.OHWADA
// use weblinks_highlight

// 2006-09-20 K.OHWADA
// this new file
// use rssc WEBLINKS_RSSC_USE

//=========================================================
// WebLinks Module
// this file contain 2 class
//   weblinks_link_view
//   weblinks_link_edit
// 2006-09-20 K.OHWADA
//=========================================================

// === class begin ===
if( !class_exists('weblinks_link_view') ) 
{

//=========================================================
// class weblinks_link_view_edit
//=========================================================
class weblinks_link_view extends happy_linux_basic
{
	var $_DIRNAME;

// handler
	var $_config_handler;
	var $_link_handler;
	var $_category_handler;
	var $_catlink_handler;
	var $_link_catlink_handler;
	var $_rssc_handler;
	var $_banner_handler;

// class
	var $_system;
	var $_image_size;
	var $_highlight;

// local
	var $_conf;
	var $_link_obj;

//-----------------------------------------------
// This is for lower compatibility of mylinks
//-----------------------------------------------
//	var $_DIR_SHOTS = 'images/shots/';

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_link_view( $dirname )
{
	$this->happy_linux_basic();

	$this->_DIRNAME = $dirname;

	$this->_config_handler       =& weblinks_get_handler('config2_basic', $dirname );
	$this->_link_handler         =& weblinks_get_handler('link',          $dirname );
	$this->_category_handler     =& weblinks_get_handler('category',      $dirname );
	$this->_catlink_handler      =& weblinks_get_handler('catlink',       $dirname );
	$this->_link_catlink_handler =& weblinks_get_handler('link_catlink',  $dirname );
	$this->_rssc_handler         =& weblinks_get_handler('rssc',          $dirname );
	$this->_banner_handler       =& weblinks_get_handler('banner',        $dirname );

	$this->_lang         =& happy_linux_language_factory::getInstance();
	$this->_system       =& happy_linux_system::getInstance();
	$this->_image_size   =& happy_linux_image_size::getInstance();

	$this->_highlight    =& happy_linux_highlight::getInstance();
	$this->_highlight->set_replace_callback( 'happy_linux_highlighter_by_class' );
	$this->_highlight->set_class( 'weblinks_highlight' );

	$this->_conf = $this->_config_handler->get_conf();
}

//---------------------------------------------------------
// set object
//---------------------------------------------------------
function set_object( &$obj )
{
	$this->_link_obj =& $obj;
}

//---------------------------------------------------------
// show
//---------------------------------------------------------
function build_show( $flag_highlight=false, $keyword_array=null )
{
	$this->build_show_basic();
	$this->build_show_desc(       $flag_highlight, $keyword_array );
	$this->build_show_desc_short( $flag_highlight, $keyword_array );

	$lid = $this->_link_obj->get('lid');
	$this->build_show_catpaths_by_lid($lid);
	$this->build_show_mail_by_lid($lid);

	$this->build_show_rss_url();

// dont show
	$this->set('name',        '');
	$this->set('mail',        '');
	$this->set('passwd',      '');
	$this->set('search',      '');
	$this->set('rss_xml',     '');
	$this->set('usercomment', '');
}

function build_show_basic()
{
	$this->build_show_link_obj();
	$this->build_show_name_mail_disp();
	$this->build_show_votes_disp();
	$this->build_show_rating_disp();
	$this->build_show_flag_recommend_mutual();
	$this->build_show_flag_new_update_pop();
	$this->build_show_flag_url();
	$this->build_show_image();
	$this->build_show_modify();
	$this->build_show_flag_admin();
	$this->build_show_time_publish();
	$this->build_show_time_expire();
	$this->build_show_flag_broken();
	$this->build_show_flag_gm_use();
}

function build_show_link_obj()
{
	$arr_1 =& $this->_link_obj->getVarAll('s');
	$arr_2 =& $this->_build_array_time();
	$arr_3 =& $this->_build_array_addr_urlencode();

	$arr_show = array_merge($arr_1, $arr_2, $arr_3);
	$this->set_vars( $arr_show );

	$this->set('textarea1', $this->_link_obj->textarea1_disp() );
	$this->set('textarea2', $this->_link_obj->textarea2_disp() );

}

function &_build_array_time()
{
// link obj
	$time_create  = $this->_link_obj->get('time_create');
	$time_update  = $this->_link_obj->get('time_update');

	$arr = array(
		'create'          => formatTimestamp($time_create, 'm'),
		'create_long'     => formatTimestamp($time_create, 'l'),
		'create_middle'   => formatTimestamp($time_create, 'm'),
		'create_short'    => formatTimestamp($time_create, 's'),
		'create_mysql'    => formatTimestamp($time_create, 'mysql'),
		'update'          => formatTimestamp($time_update, 'm'),
		'update_long'     => formatTimestamp($time_update, 'l'),
		'update_middle'   => formatTimestamp($time_update, 'm'),
		'update_short'    => formatTimestamp($time_update, 's'),
		'update_mysql'    => formatTimestamp($time_update, 'mysql'),
	);

	return $arr;
}

function &_build_array_addr_urlencode()
{
// Mapfan disregards a space or subsequent ones. 

	$zip   = $this->_link_obj->get('zip');
	$state = $this->_link_obj->get('state');
	$city  = $this->_link_obj->get('city');
	$addr  = $this->_link_obj->get('addr');
	$addr2 = $this->_link_obj->get('addr2');

	$flag_addr         = 0;
	$en_join           = '';
	$jp_join           = '';
	$en_urlencode      = '';
	$jp_urlencode      = '';
	$en_utf8_urlencode = '';
	$jp_utf8_urlencode = '';
	$en_csz            = '';
	$en_csz_urlencode  = '';

	if ( $state || $city || $addr || $addr2 )
	{
		$flag_addr = 1;	
	}

	if ( $city && $state && $zip)
	{
		$en_csz = $city.', '.$state.' '.$zip;
	}
	elseif ( $city && $state)
	{
		$en_csz = $city.', '.$state;
	}
	elseif ( $city && $zip)
	{
		$en_csz = $city.', '.$zip;
	}

	$en_csz_urlencode = urlencode( $en_csz );

	if ( $state || $city || $addr)
	{
		$en_join = $addr.' '.$en_csz;
		$jp_join = $state . $city . $addr;
		$en_utf8 = happy_linux_convert_to_utf8($en_join);
		$jp_utf8 = happy_linux_convert_to_utf8($jp_join);
		$en_urlencode      = urlencode( $en_join );
		$jp_urlencode      = urlencode( $jp_join );
		$en_utf8_urlencode = urlencode( $en_utf8 );
		$jp_utf8_urlencode = urlencode( $jp_utf8 );
	}

	$arr = array(
		'flag_addr'              => $flag_addr,
		'addr_urlencode'         => urlencode( $addr ),
		'addr2_urlencode'        => urlencode( $addr2 ),
		'city_urlencode'         => urlencode( $city ),
		'state_urlencode'        => urlencode( $state ),
		'zip_urlencode'          => urlencode( $zip ),
		'addr_utf8_urlencode'    => urlencode( happy_linux_convert_to_utf8( $addr ) ),
		'addr2_utf8_urlencode'   => urlencode( happy_linux_convert_to_utf8( $addr2 ) ),
		'city_utf8_urlencode'    => urlencode( happy_linux_convert_to_utf8( $city ) ),
		'state_utf8_urlencode'   => urlencode( happy_linux_convert_to_utf8( $state ) ),
		'zip_utf8_urlencode'     => urlencode( happy_linux_convert_to_utf8( $zip ) ),
		'addr_en_join'           => $en_join,
		'addr_jp_join'           => $jp_join,
		'addr_en_urlencode'      => $en_urlencode,
		'addr_jp_urlencode'      => $jp_urlencode,
		'addr_en_utf8_urlencode' => $en_utf8_urlencode,
		'addr_jp_utf8_urlencode' => $jp_utf8_urlencode,
		'addr_en_csz'            => $en_csz,
		'addr_en_csz_urlencode'  => $en_csz_urlencode,
	);

	return $arr; 
}

function build_show_name_mail_disp()
{
	$name_disp = $this->_link_obj->name_disp( 's' );
	$mail_disp = $this->_link_obj->mail_disp( 's' );

	if ( empty($name_disp) && $mail_disp )
	{
		$name_disp = 'Email';
	}

	$this->set('name_disp', $name_disp );
	$this->set('mail_disp', $mail_disp );
}

function build_show_votes_disp()
{
	$votes = $this->_link_obj->get('votes');
	if ($votes == 1) 
	{
		$votes_disp = _WLS_ONEVOTE;
	} 
	else
	{
		$votes_disp = sprintf(_WLS_NUMVOTES, $votes);
	}
	$this->set('votes_disp', $votes_disp);
}

function build_show_rating_disp()
{
	$DECIMALS = 2;
	$rating   = $this->_link_obj->get('rating');
	$this->set('rating_disp', number_format($rating, $DECIMALS) );
}

function build_show_flag_recommend_mutual()
{
	$recommend = $this->_link_obj->get('recommend');
	$mutual    = $this->_link_obj->get('mutual');
	$this->set('flag_recommend', $recommend );
	$this->set('flag_mutual',    $mutual );
}

function build_show_flag_new_update_pop()
{
	$time_create = $this->_link_obj->get('time_create');
	$time_update = $this->_link_obj->get('time_update');
	$hits        = $this->_link_obj->get('hits');

	$flag_new    = 0;
	$flag_update = 0;
	$flag_pop    = 0;

	if ( $this->_conf['newdays'] > 0 )
	{
		$startdate = time() - (86400 * $this->_conf['newdays'] );

		if ( $startdate < $time_create ) 
		{
			$flag_new = 1;
		}
		elseif ( $startdate < $time_update )
		{
			$flag_update = 1;
		}
	}

	if ( $this->_conf['popular'] > 0 )
	{
		if ( $hits >= $this->_conf['popular'] )
		{
			$flag_pop = 1;
		}
	}

	$this->set('flag_new',    $flag_new);
	$this->set('flag_update', $flag_update);
	$this->set('flag_pop',    $flag_pop);	
}

function build_show_flag_url()
{
	$url = $this->_link_obj->get('url');
	$flag_url = 0;

	if ( $url && $this->_conf['view_url'] )
	{
		$flag_url = $this->_conf['view_url'];
	}

	$this->set('flag_url', $flag_url);
}

function build_show_desc( $flag_highlight=false, $keyword_array=null )
{
	$text = $this->_link_obj->description_disp();
	if ($flag_highlight)
	{
		$text = $this->_highlight->build_highlight_keyword_array($text, $keyword_array);
	}
	$this->set('description', $text);
}

function build_show_desc_short( $flag_highlight=false, $keyword_array=null )
{
	$text = $this->_link_obj->description_disp();
	$text = $this->replace_return_to_space($text);
	$text = $this->strip_space($text);

	if (strlen($text) > $this->_conf['descshort'] )
	{
		$text = $this->strip_tags_for_text($text);
		$text = $this->shorten_text($text, $this->_conf['descshort'], $keyword_array );
		$text = $this->sanitize_text($text);
	}

	if ($flag_highlight)
	{
		$text = $this->_highlight->build_highlight_keyword_array($text, $keyword_array);
	}

	$this->set('desc_short', $text);
}

function build_show_modify()
{
	$uid = $this->_link_obj->get('uid');
	$this->set('show_modify', $this->_config_handler->show_modify( $uid ) );
}

function build_show_flag_admin()
{
	$flag_admin = 0;
	if ( $this->_system->is_module_admin() )
	{
		$flag_admin = 1;
	}

	$this->set('flag_admin', $flag_admin);
}

function build_show_catpaths_by_lid($lid)
{
	$cid_arr = $this->_catlink_handler->get_cid_array_by_lid($lid);
	$this->build_show_catpaths_by_cid_arr($cid_arr);
}

function build_show_catpaths_by_cid_arr($cid_arr)
{
	$show_catpaths = false;
	$catpaths      = null;

	if ( is_array($cid_arr) && count($cid_arr) )
	{
		$catpaths = $this->_category_handler->build_parent_path_multi($cid_arr);
	}

	if ( is_array($catpaths) && count($catpaths) )
	{
		$show_catpaths = true;
	}

	$this->set('show_catpaths', $show_catpaths);
	$this->set('catpaths',      $catpaths);
}



function build_show_time_publish()
{
	$time_publish = $this->_link_obj->get('time_publish');
	$flag = 0;
	if ( ($time_publish == 0) || ($time_publish < time() ) )
	{
		$flag = 1;
	}
	$this->set('flag_time_publish', $flag);
	$this->set('time_publish_long', formatTimestamp($time_publish, 'l') );
}

function build_show_time_expire()
{
	$time_expire = $this->_link_obj->get('time_expire');
	$flag = 0;
	if ( ($time_expire == 0) || ($time_expire > time() ) )
	{
		$flag = 1;
	}
	$this->set('flag_time_expire', $flag);
	$this->set('time_expire_long', formatTimestamp($time_expire, 'l') );
}

function build_show_flag_broken()
{
	$broken = $this->_link_obj->get('broken');
	$flag = 0;
	if ( ($broken == 0) || ($broken < $this->_conf['broken_threshold'] ) )
	{
		$flag = 1;
	}
	$this->set('flag_broken', $flag);
}

function build_show_flag_gm_use()
{
	$lat  = $this->_link_obj->get('gm_latitude');
	$lng  = $this->_link_obj->get('gm_longitude');
	$zoom = $this->_link_obj->get('gm_zoom');

	$flag = 0;
	if ( $this->_conf['gm_use'] && $this->_conf['gm_apikey'] && (($lat != 0)||($lng != 0)||($zoom != 0)) )
	{
		$flag = 1;
	}
	$this->set('flag_gm_use', $flag);
}

//---------------------------------------------------------
// mail
//---------------------------------------------------------
function build_show_mail_by_lid($lid)
{
	$mail_subject = '';
	$mail_body    = '';

	if ($lid)
	{
		list($mail_subject, $mail_body) 
			= $this->build_show_link_mail_by_lid($lid);
	}

	$this->set('mail_subject', $mail_subject);
	$this->set('mail_body',    $mail_body);
}

function build_show_link_mail_by_lid($lid)
{
	$sitename = $this->_system->get_sitename();
	$subject  = sprintf(_WLS_INTRESTLINK,  $sitename);
	$body     = sprintf(_WLS_INTLINKFOUND, $sitename).": ".$this->build_show_single_link_by_lid($lid);

// --- effective only in Japanese environment ---
// convert EUC-JP to SJIS
	$subject = $this->_lang->convert_telafriend_subject($subject);
	$body    = $this->_lang->convert_telafriend_body($body);

	$subject = rawurlencode($subject);
	$body    = rawurlencode($body);

	return array($subject, $body);
}

function build_show_single_link_by_lid($lid)
{
	$link = XOOPS_URL.'/modules/'.$this->_DIRNAME.'/singlelink.php?lid='.$lid;
	return $link;
}

//---------------------------------------------------------
// banner
//---------------------------------------------------------
function build_show_image()
{
	$arr =& $this->_banner_handler->build_show_image( $this->_link_obj );

	$this->set('image_url',          $arr['image_url'] );
	$this->set('image_link_width',   $arr['image_link_width'] );
	$this->set('image_link_height',  $arr['image_link_height'] );
	$this->set('image_list_width',   $arr['image_list_width'] );
	$this->set('image_list_height',  $arr['image_list_height'] );
	$this->set('image_list_width_5', $arr['image_list_width_5'] );
}

//---------------------------------------------------------
// rss url
//---------------------------------------------------------
function build_show_rss_url()
{
	$url  = '';
	$flag = 0;

	$rssc_lid = $this->_link_obj->get('rssc_lid');

	if ( WEBLINKS_RSSC_USE && $rssc_lid )
	{
		list($url, $flag)
			= $this->_rssc_handler->get_rss_url_flag($rssc_lid);
	}

	$this->set('rss_url',  $this->sanitize_url($url) );
	$this->set('rss_flag', $flag);
}

//---------------------------------------------------------
// build preview
//---------------------------------------------------------
function build_preview_catpaths_by_post( &$post )
{
	$cid_arr  = $this->_link_obj->get_cid_array_by_post( $post );
	$catpaths = $this->_category_handler->build_parent_path_multi($cid_arr);

	if ( is_array($catpaths) && count($catpaths) )
	{
		$show_catpaths = true;
	}

	$this->set('show_catpaths', $show_catpaths);
	$this->set('catpaths',      $catpaths);
}

//---------------------------------------------------------
// for rss
//---------------------------------------------------------
function build_rss( $flag_user=false )
{
	$this->set_vars( $this->_link_obj->getVarAll('n') );

// link
	$lid  = $this->_link_obj->get('lid');
	$link = XOOPS_URL.'/modules/'.$this->_DIRNAME.'/singlelink.php?lid='.$lid;
	$this->set('link', $link );

	$this->set('content', $this->_link_obj->description_disp() );

// author_name
	$uid = $this->_link_obj->get('uid');

	$author_name  = '';
	$author_email = '';
	$author_uri   = '';

	if ( $flag_user && $uid )
	{
		$user = $this->_system->get_user_by_uid( $uid );
		$author_name  = $user['uname'];
		$author_email = $user['email'];
		$author_uri   = $user['url'];
	}

	$this->set('author_name',  $author_name);
	$this->set('author_email', $author_email);
	$this->set('author_uri',   $author_uri);

// category
	$cid_arr  = $this->_catlink_handler->get_cid_array_by_lid($lid);
	$category = $this->_category_handler->get_cache_var_title($cid_arr[0], 'n');
	$this->set('category', $category);
}

// --- class end ---
}

//=========================================================
// class weblinks_link_edit
//=========================================================
class weblinks_link_edit extends weblinks_link_view
{
// class
	var $_post;

// conf
	var $_conf_desc_option;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_link_edit( $dirname )
{
	$this->weblinks_link_view( $dirname );

	$this->_post  =& happy_linux_post::getInstance();

	$this->_conf_desc_option = $this->_config_handler->has_auth_desc_option();

}

//---------------------------------------------------------
// submit
//---------------------------------------------------------
function build_submit()
{
	$link_obj =& $this->_link_handler->create();
	$this->set_object($link_obj);
	$this->set_vars( $link_obj->getVarAll('s') );

// user param
	$user = $this->_system->get_user_param();
	$this->set('uid',   $user['uid'] );
	$this->set('name',  $user['uname'] );
	$this->set('mail',  $user['email'] );

	$this->build_submit_cid_arr();
	$this->set('notify', 1);
	$this->build_password_by_post();
	$this->build_submit_rss_url();
}

function build_submit_cid_arr()
{
	$cid_arr = array();
	if ( isset($_GET['cid']) )
	{
		$cid_arr = array($_GET['cid']);
	}
	$this->set('cid_arr', $cid_arr);
}

function build_submit_rss_url()
{
	$rss_flag  = 0;

	if ( WEBLINKS_RSSC_USE )
	{
		$rss_flag = $this->_rssc_handler->get_rss_flag_default();
	}

	$this->set('rss_url',  '');
	$this->set('rss_flag', $rss_flag);
	$this->build_rss_opt();
}

function build_rss_opt()
{
	$rss_opt  = array();

	if ( WEBLINKS_RSSC_USE )
	{
		$rss_opt = $this->_rssc_handler->get_rss_opt();
	}

	$this->set('rss_opt', $rss_opt);
}

function build_password_by_post()
{
	$passwd_new = $this->_post->get_post_text('passwd_new');
	$passwd_2   = $this->_post->get_post_text('passwd_2');

	list($passwd_old, $flag_passwd, $flag_code)
		= $this->_post->get_post_get_passwd_old();

	$this->set('passwd_new',  $passwd_new);
	$this->set('passwd_2',    $passwd_2);
	$this->set('passwd_old',  $passwd_old);
}

//---------------------------------------------------------
// submit preview
//---------------------------------------------------------
function build_submit_preview()
{
	$link_obj =& $this->_link_handler->create();
	$this->set_object($link_obj);

	$this->build_preview_by_post();
	$this->build_password_by_post();
	$this->build_rss_url_by_post();
}

function build_preview_by_post()
{
	$save_obj =& new weblinks_link_save( $this->_DIRNAME );
	$save_obj->assign_add_object( $_POST );
	$this->set_vars( $save_obj->getVarAll('f') );
	$this->set('cid_arr',  $save_obj->get_cid_array() );
	$this->set('notify',   $this->_post->get_post_int('notify') );
}

function build_rss_url_by_post()
{
	$rss_flag = $this->_post->get_post_int('rss_flag');
	$rss_url  = $this->_post->get_post_url('rss_url');
	$rss_url  = $this->sanitize_url($rss_url);

	$this->set('rss_flag', $rss_flag );
	$this->set('rss_url',  $rss_url );

	$this->build_rss_opt();
}

//---------------------------------------------------------
// admin modify
//---------------------------------------------------------
function build_modify($lid, $flag_owner=false)
{
	$this->set_vars( $this->_link_obj->getVarAll('e') );

// hidden value, when NOT owner
	if ( !$flag_owner )
	{
		$this->build_name_edit_for_others();
		$this->build_mail_edit_for_others();
	}

	$this->build_modify_cid_arr_by_lid($lid);
	$this->set('notify', 0);
	$this->build_password_by_post();
	$this->build_modify_rss_url();

}

function build_name_edit_for_others()
{
	$nameflag = $this->_link_obj->get('nameflag');

	$name_edit     = '';
	$nameflag_edit = 0;

	if ($nameflag == 1)
	{
		$name_edit     = $this->_link_obj->getVar('name');
		$nameflag_edit = 1;
	}

	$this->set('name',     $name);
	$this->set('nameflag', $nameflag_edit);
}

function mail_edit_for_others()
{
	$mailflag = $this->_link_obj->get('mailflag');

	$mail_edit     = '';
	$mailflag_edit = 0;

	if ($mailflag == 1)
	{
		$mail_edit     =  $this->_link_obj->getVar('mail');
		$mailflag_edit = 1;
	}

	$this->set('mail',     $mail);
	$this->set('mailflag', $mailflag_edit);
}

function build_modify_cid_arr_by_lid($lid)
{
	$cid_arr   = $this->_catlink_handler->get_cid_array_by_lid($lid);
	$this->set('cid_arr', $cid_arr);
}

function build_modify_rss_url()
{
	$this->build_show_rss_url();
	$this->build_rss_opt();
}

//---------------------------------------------------------
// modify preview
//---------------------------------------------------------
function build_modify_preview()
{
	$this->build_preview_by_post();
	$this->build_password_by_post();
	$this->build_rss_url_by_post();
}

//---------------------------------------------------------
// admin submit
//---------------------------------------------------------
function build_admin_submit()
{
	$this->build_submit();
}

//---------------------------------------------------------
// admin submit preview
//---------------------------------------------------------
function build_admin_submit_preview()
{
	$link_obj =& $this->_link_handler->create();
	$this->set_object($link_obj);
	$this->build_admin_preview_by_post();

	$this->build_rss_url_by_post();
}

function build_admin_preview_by_post()
{
	$this->build_preview_by_post();
	$this->build_desc_disp();

	$this->set('time_update_flag_update', $this->_post->get_post_int('time_update_flag_update') );
}

function build_desc_disp()
{
	$this->set('desc_disp',  $this->_link_obj->description_disp() );
}

//---------------------------------------------------------
// admin modify
//---------------------------------------------------------
function build_admin_modify($lid)
{
	$this->set_vars( $this->_link_obj->getVarAll('e') );

	$this->build_desc_disp();
	$this->build_modify_cid_arr_by_lid($lid);
	$this->set('time_update_flag_update', 0);

	$this->build_modify_rss_url();

}

//---------------------------------------------------------
// admin modify preview
//---------------------------------------------------------
function build_admin_modify_preview()
{
	$this->build_admin_preview_by_post();
	$this->build_admin_modify_preview_uid();

	$this->build_rss_url_by_post();
}

function build_admin_modify_preview_uid()
{
	if ( $muid = $this->_link_obj->is_set('muid') )
	{
		$muid = $this->_link_obj->get('muid');
		$this->set('uid', $muid);
	}
}

//---------------------------------------------------------
// admin approve
//---------------------------------------------------------
function build_admin_approve()
{
	$this->set_vars( $this->_link_obj->getVarAll('e') );

	$this->build_admin_approve_cid_arr();
	$this->build_admin_approve_uid();

	$this->set('time_update_flag_update', 1);
	$this->set('approve',    1);

	$this->build_rss_opt();
}

function build_admin_approve_cid_arr()
{
	$cid_arr =& $this->_link_obj->cid_array();
	$this->set('cid_arr', $cid_arr);
}

function build_admin_approve_uid()
{
	$muid = $this->_link_obj->get('muid');
	$this->set('uid', $muid);
}

//---------------------------------------------------------
// admin approve preview
//---------------------------------------------------------
function build_admin_approve_preview()
{
	$this->build_admin_preview_by_post();
	$this->set('approve', 1);
}

//---------------------------------------------------------
// admin approve modify
//---------------------------------------------------------
function build_admin_approve_modify()
{
	$this->set_vars( $this->_link_obj->getVarAll('e') );

	$this->build_desc_disp();
	$this->build_admin_approve_cid_arr();
	$this->build_admin_approve_uid();

	$this->set('time_update_flag_update', 1);
	$this->set('approve',    1);

	$this->build_rss_opt();
}

//---------------------------------------------------------
// admin approve modify preview
//---------------------------------------------------------
function build_admin_approve_modify_preview()
{
	$this->build_admin_preview_by_post();
	$this->set('approve', 1);
}

//---------------------------------------------------------
// build_preview
//---------------------------------------------------------
function build_preview_for_template( $cid_arr )
{
	$this->build_show_basic();
	$this->build_show_desc_short();

// catpaths
	$this->build_show_catpaths_by_cid_arr($cid_arr);

// mail
	$this->set('mail_subject', '');
	$this->set('mail_body',    '');

// dont show
	$this->set('name',        '');
	$this->set('mail',        '');
	$this->set('passwd',      '');
	$this->set('search',      '');
	$this->set('rss_xml',     '');
	$this->set('usercomment', '');
}

// --- class end ---
}

// === class end ===
}

?>