<?php
// Calculate the beginning and ending of the navigator range
$begin = max($navigator["page"] - $navigator["spread"], 1);
$end = min($navigator["page"] + $navigator["spread"], $navigator["maxPages"]);

// If we're pinned at the beginning or the end, expand as far as we can
// in the opposite direction
if ($begin == 1 && $end <= $navigator["maxPages"]) {
	$end = min(2 * $navigator["spread"], $navigator["maxPages"]);
}
if ($end == $navigator["maxPages"]) {
	$begin = max(1, $end - 2 * $navigator["spread"]);
}

// If the border color is not passed in, we do a white one

$url = $navigator["url"];
if (!strstr($url, "?")) {
	$url .= "?";
}

$imageDir = $gallery->app->photoAlbumURL."/images";

#-- 'page numbers' cell ---                  
$current = $navigator["page"];
echo "Page ";
for ($i = $begin; $i <= $end; $i++) {
	if ($i == $current) {
		$number = "<b>$i</b>";
		$leftdot = ' &raquo;';
	} else {
		$navLinks[$i]['url'] = $url."&".$navigator[pageVar]."=".$i;
		$number = "<a href=".$url."&".$navigator[pageVar]."=$i title=\"Page $i\">$i</a>";
		if (($i-1) == $navigator["page"]) {
			$leftdot = '&laquo ';
		}
	}

	$navLinks[$i]['page'] = $i;
	$navLinks[$i]['leftdot'] = $leftdot;
	
	echo "&nbsp;$leftdot&nbsp;";
	echo "$number";
}

if ($end == $current) {
	$rightdot = '&laquo; ';
	$navLinks[$current]['rightdot'] = $rightdot;
}
echo "&nbsp;$rightdot&nbsp;";
$xoopsTpl->assign('navLinks', $navLinks);
?>    
