<?php
include '../../../include/cp_header.php';
if ( file_exists("../language/".$xoopsConfig['language']."/main.php") ) {
	include "../language/".$xoopsConfig['language']."/main.php";
} else {
	include "../language/english/main.php";
}
if ( file_exists("../language/".$xoopsConfig['language']."/modinfo.php") ) {
	include "../language/".$xoopsConfig['language']."/modinfo.php";
} else {
	include "../language/english/modinfo.php";
}

function ShowMain() {
    global $xoopsDB, $xoopsModule;

	xoops_cp_header();
	echo "<h4>"._MI_GALLERY_ADMIN_CONF."</h4>";
	echo " - <a href='".XOOPS_URL."/modules/system/admin.php?fct=preferences&amp;op=showmod&amp;mod=".$xoopsModule->getVar('mid')."'>"._MI_GALLERY_ADMIN_PREFS."</a>";
	echo "<br />"._MI_GALLERY_ADMIN_PREFSDESC;
	echo "<br /><br />";
	echo " - <a href='index.php?op=check_netpbm'>"._MI_GALLERY_ADMIN_CHECKNETPBM."</a>";
	echo "<br />"._MI_GALLERY_ADMIN_CHECKNETPBMDESC;
	echo "<br /><br />";
	echo " - <a href='index.php?op=check_imagemagick'>"._MI_GALLERY_ADMIN_CHECKIMAGICK."</a>";
	echo "<br />"._MI_GALLERY_ADMIN_CHECKIMAGICKDESC;
	echo "<br /><br />";
	echo " - <a href='index.php?op=check_orphan'>"._MI_GALLERY_ADMIN_CHECKORPHANS."</a>";
	echo "<br />"._MI_GALLERY_ADMIN_ORPHANDESC;
	echo "<br /><br />";
	xoops_cp_footer();
}

function admin_CheckNetPBM() {
	global $xoopsUser, $xoopsModule, $xoopsModuleConfig;
	xoops_cp_header();
	require('../check_netpbm.php');
	xoops_cp_footer();
}

function admin_CheckImageMagick() {
	global $xoopsUser, $xoopsModule, $xoopsModuleConfig;
	xoops_cp_header();
	require('../check_imagemagick.php');
	xoops_cp_footer();
}

function admin_OrphanCheck() {
	global $xoopsDB;
	xoops_cp_header();
	echo '<h4>'._MD_GALLERY_ADMIN_ORPHANCHECK.'</h4>';

	// Look for problems in comment records
	$sql = 'select count(*) from '.$xoopsDB->prefix('xoopscomments').' where com_exparams like \'%xoops_imageid=%\'';
	$result = $xoopsDB->query($sql);
	list($total_bad_comment_exparams) = $xoopsDB->fetchRow($result);
	if ($total_bad_comment_exparams > 0) {
		printf(_MD_GALLERY_ADMIN_COMMENTCHECK, $total_bad_comment_exparams);
	} else {
		echo _MD_GALLERY_ADMIN_COMMENTNONE;
	}

	// Orphaned records - Get total record count
	$sql = 'select count(*) from '.$xoopsDB->prefix('xoopsgallery_image');
	$result = $xoopsDB->query($sql);
	list($total_record_count) = $xoopsDB->fetchRow($result);
	printf("<br /><br /><p>"._MD_GALLERY_ADMIN_ORPHANSEARCHING."</p>", $total_record_count);
	unset($result);

	// Orphaned records - Get list
	$sql = 'select * FROM '.$xoopsDB->prefix('xoopsgallery_image');
	$result = $xoopsDB->query($sql);
	$bad_id_list = "";
    if ( $total_record_count > 0 ) {
		while(list($image_id, $image_name, $image_ext, $image_type, $image_albumdir, $image_basedir, $image_created, $image_comments) = $xoopsDB->fetchRow($result)) {
			$fname = $image_basedir.'/'.$image_albumdir.'/'.$image_name.'.'.$image_ext;
			if (!file_exists($fname)) {
				$bad_id_list .= ','.$image_id;
				echo _MD_GALLERY_ADMIN_ORPHANFOUND." $fname ($image_id)<br />";
			}
		}
	}
	if (strlen($bad_id_list) == 0) {
		echo _MD_GALLERY_ADMIN_ORPHANNONE;
	} else {
		$bad_id_list = substr($bad_id_list, 1);
	}
	
	if (strlen($bad_id_list) || $total_bad_comment_exparams > 0) {
		// Confirm remove bad records
	
		echo "<br /><br /><form action=\"index.php\" method=\"POST\">\n";
		echo "<input type=\"hidden\" name=\"op\" value=\"remove_orphan\"></input>";
		echo "<input type=\"hidden\" name=\"bad_id_list\" value=\"$bad_id_list\"></input>";
		echo "<br />"._MD_GALLERY_ADMIN_ORPHANCONF."<br />  <input type=\"submit\" value=\""._MD_GALLERY_ADMIN_ORPHANCONFBTN."\"></form>\n";
		echo "</form>";
	}
	xoops_cp_footer();
}

function admin_RemoveOrphan() {
	global $xoopsDB;
	xoops_cp_header();
	echo '<h4>'._MD_GALLERY_ADMIN_ORPHANREMOVE.'</h4>';

	// Fix for bad comment exparams (refetch count because I'm too lazy to look up affected rows)
	$sql = 'select count(*) from '.$xoopsDB->prefix('xoopscomments').' where com_exparams like \'%xoops_imageid=%\'';
	$result = $xoopsDB->query($sql);
	list($total_bad_comment_exparams) = $xoopsDB->fetchRow($result);
	if ($total_bad_comment_exparams > 0) {
		printf("<br />"._MD_GALLERY_ADMIN_COMMENTFIX."<br />", $total_bad_comment_exparams);
		$sql = 'update '.$xoopsDB->prefix('xoopscomments').' set com_exparams = replace(com_exparams, \'xoops_imageid\', \'unused_data\') where com_exparams like \'%xoops_imageid=%\'';
		$result = $xoopsDB->query($sql);
	}

	// remove any orphans found
	$bad_id_arry = explode(',', $_POST['bad_id_list']);
	$count = count($bad_id_arry);
	if ($count && $bad_id_arry[0] != "") {
		$xoopsgalleryimage_handler =& xoops_getmodulehandler('image');
		for ($i = 0; $i < $count; $i++) {
			echo '<br />'._MD_GALLERY_ADMIN_ORPHANREMOVEID.' '.$bad_id_arry[$i];
			$xoopsgallery_image =& $xoopsgalleryimage_handler->get($bad_id_arry[$i]);
			if (is_object($xoopsgallery_image)) {
				$xoopsgalleryimage_handler->delete($xoopsgallery_image);
				xoops_comment_delete($GLOBALS['xoopsModule']->getVar('mid'), $bad_id_arry[$i]);
			}
		}
	}
	echo '<br /><br />'._MD_GALLERY_ADMIN_ORPHANREMOVECOMPLETE;
	xoops_cp_footer();
}

if(!isset($_POST['op'])) {
	$op = isset($_GET['op']) ? $_GET['op'] : 'main';
} else {
	$op = $_POST['op'];
}
switch ($op) {
case 'check_netpbm':
	admin_CheckNetPBM();
	break;
case 'check_imagemagick':
	admin_CheckImageMagick();
	break;
case 'check_orphan':
	admin_OrphanCheck();
	break;
case 'remove_orphan':
	admin_RemoveOrphan();
	break;
case 'main':
default:
	ShowMain();
	break;
}
?>