<?php
// $Id: data.inc.php,v 1.6 2005/11/01 13:11:39 ohwada Exp $

// 2005-11-01 K.OHWADA
// BUG 3152: show twice of limit

// 2005-10-23 K.OHWADA
// categoy, uid, permission

// 2005-09-28 K.OHWADA
// BUG 3037: XML format error

// 2005-09-15 K.OHWADA
// use UNIX_TIMESTAMP

// 2005-07-14 K.OHWADA
// change description in french style to universal style

//================================================================
// What's New Module
// get aritciles from module
// for piCal 0.8 <http://www.peak.ne.jp/xoops/>
// 2005-06-28 Ayou42 <http://ayou42.free.fr/>
//================================================================

function piCal_new($limit=0, $offset=0)
{
    global $xoopsDB;

	$URL_MOD = XOOPS_URL."/modules/piCal";

	$myts =& MyTextSanitizer::getInstance();

	$module_handler = &xoops_gethandler('module');
	$module = $module_handler->getByDirname('piCal');
	$mid    = $module->getVar('mid');

	$gperm_handler = &xoops_gethandler('groupperm');

	global $xoopsUser;
	if ( is_object($xoopsUser) )
	{
		$groups  = $xoopsUser->getGroups();
		$isadmin = $xoopsUser->isadmin( $mid ) ;
	}
	else
	{
		$groups  = XOOPS_GROUP_ANONYMOUS;
		$isadmin = false;
	}

// use UNIX_TIMESTAMP
//	$sql = "SELECT id, summary, location, description, dtstamp, start, end as last_modified FROM " . $xoopsDB->prefix( 'pical_event' ) . " ORDER BY dtstamp DESC";

	$sql1 = "SELECT id, uid, summary, location, description, categories, start, end, UNIX_TIMESTAMP(dtstamp) as dtstamp FROM ".$xoopsDB->prefix('pical_event')." ORDER BY dtstamp DESC";

// get twice records 
	$res1 = $xoopsDB->query($sql1, 2*$limit, $offset);

	$i = 0;
	$ret = array();

	while( $row1 = $xoopsDB->fetchArray($res1) )
	{
		$ret[$i] = array();

		$id = $row1['id'];
		$cid_arr_1 = split(",", $row1['categories']);

// remove garbage 
		$cid_arr_2 = array();
		foreach ($cid_arr_1 as $cid)
		{
			$cid = intval($cid);

			if ($cid)
			{
				$cid_arr_2[] = $cid;
			}
		}

		if ( count($cid_arr_2) )
		{
			$flag_perm = false;
			asort($cid_arr_2);

// permission
			foreach ($cid_arr_2 as $cid)
			{
				$cid = intval($cid);

// remove garbage 
				if ($cid == 0)  continue;
			
	 			if ( $gperm_handler->checkRight('pical_cat', $cid, $groups, $mid) )
	 			{
	 				$flag_perm = true;
	 				break;
	 			}
	 		}

// check NG
			if ( !$isadmin && !$flag_perm )  continue;

			$sql2 = "SELECT * FROM ".$xoopsDB->prefix('pical_cat' )." WHERE cid =".$cid;
			$row2 = $xoopsDB->fetchArray( $xoopsDB->query($sql2) );

			$ret[$i]['cat_link'] = $URL_MOD."/?cid=".$cid;
			$ret[$i]['cat_name'] = $row2['cat_title'];
		}

// BUG 3037: XML format error
		$ret[$i]['link'] = $URL_MOD."/index.php?action=View&amp;event_id=".$id;

		$ret[$i]['title'] = $row1['summary'];

// time
// use UNIX_TIMESTAMP
		$ret[$i]['time'] = $row1['dtstamp'];

// description
		$desc = '';

		if ( $row1['description'] )
		{
			$desc .= $row1['description'].": ";
		}

		if ( $row1['location'] )
		{
			$desc .= $row1['location'].": ";
		}

		if ( $row1['start'] )
		{
			$desc .= date("Y-m-d H:i", $row1['start']);
		}

		if ( $row1['end'] )
		{
			$desc .= " - ".date("Y-m-d Y H:i", $row1['end']);
		}

		$ret[$i]['description'] = $desc;

// atom feed
		$ret[$i]['uid'] = $row1['uid'];
		$ret[$i]['id']  = intval($id);

		$i++;

// BUG 3152: show twice of limit
		if ($i >= $limit)  break;
	}

	return $ret;
}

?>
