<?php
// $Id: whatsnew_module_handler.php,v 1.3 2005/10/22 08:12:41 ohwada Exp $

//================================================================
// What's New Module
// class module handler
// 2005-10-01 K.OHWADA
//================================================================

class Whatsnew_Module_Handler extends XoopsObjectHandler
{
	var $_table;
	var $_class_name;
	var $_flag_print_db_error;

// init
	var $_module_mid_cache = array();

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function Whatsnew_Module_Handler()
{
	XoopsObjectHandler::XoopsObjectHandler( $GLOBALS['xoopsDB'] );

	$this->_table = $this->db->prefix('whatsnew_module');
	$this->_class_name = 'whatsnew_module_table';

	$this->_flag_print_db_error = 1;

// load to cache
	$this->load();

}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new Whatsnew_Module_Handler();
	}

	return $instance;
}


//---------------------------------------------------------
// load to cache
//---------------------------------------------------------
function load()
{

// create from MySQL
	$sql = 'SELECT * FROM '.$this->_table.' ORDER BY mid ASC';

	$res = $this->db->query($sql, 0, 0);
	if ( !$res )
	{
		$this->_print_db_error($sql);
		return false;
	}

// list from MySQL
	while ( $myrow = $this->db->fetchArray($res) ) 
	{
		$mid = $myrow['mid'];

		$module = $this->create( false );	// not new
		$module->assignVars($myrow);
		$this->_module_mid_cache[$mid] =& $module;

		unset($module);
	}
}

//---------------------------------------------------------
// function
//---------------------------------------------------------
function &create($isNew = true)
{
	$module = new $this->_class_name();

	if ($isNew) 
	{
		$module->setNew();
	}

	return $module;
}

function insert( &$module )
{
	if ( !$this->_check_class( $module ) )  return false;

	if ( !$module->isDirty() )   return true;
	if ( !$module->cleanVars() ) return false;
	if ( !$module->isNew() )     return false;

	foreach ($module->cleanVars as $k => $v)
	{	${$k} = $v;	}

	$sql = sprintf("INSERT INTO %s (mid, dirname, block_show, block_limit, rss_show, rss_limit, block_icon, aux_int_1, aux_int_2, aux_text_1, aux_text_2) VALUES (%u, %s, %u, %u, %u, %u, %s, %u, %u, %s, %s)", $this->_table, $mid, $this->db->quoteString($dirname), $block_show, $block_limit, $rss_show, $rss_limit, $this->db->quoteString($block_icon), $aux_int_1, $aux_int_2, $this->db->quoteString($aux_text_1), $this->db->quoteString($aux_text_2) );

//	echo "$sql <br>";

	if ( !$result = $this->db->query($sql) )
	{
		$this->_print_db_error($sql);
		return false;
	}

	if ( !empty($this->_module_mid_cache[$mid]) ) 
	{
		unset ($this->_module_mid_cache[$mid]);
	}

	return true;
}

function update( &$module )
{
	if ( !$this->_check_class( $module ) )  return false;

	if ( !$module->isDirty() )   return true;
	if ( !$module->cleanVars() ) return false;

	foreach ($module->cleanVars as $k => $v)
	{	${$k} = $v;	}

	$sql = sprintf("UPDATE %s SET dirname = %s, block_show = %u, block_limit = %u, rss_show = %u, rss_limit = %u, block_icon = %s, aux_int_1 = %u, aux_int_2 = %u, aux_text_1 = %s, aux_text_2 = %s WHERE mid = %u", $this->_table, $this->db->quoteString($dirname), $block_show, $block_limit, $rss_show, $rss_limit, $this->db->quoteString($block_icon), $aux_int_1, $aux_int_2, $this->db->quoteString($aux_text_1), $this->db->quoteString($aux_text_2), $mid);

//	echo "$sql <br>";

	if ( !$result = $this->db->query($sql) ) 
	{
		$this->_print_db_error($sql);
		return false;
	}

	if ( !empty($this->_module_mid_cache[$mid]) ) 
	{
		unset ($this->_module_mid_cache[$mid]);
	}

	return true;
}

function delete( &$module )
{
	if ( !$this->_check_class( $module ) )  return false;

	$mid = $module->getVar('mid');
	$sql = sprintf("DELETE FROM %s WHERE mid = %u", $this->_table, $mid);

	if ( !$result = $this->db->query($sql) )
	{
		$this->_print_db_error($sql);
		return false;
	}

	if ( !empty($this->_module_mid_cache[$mid]) ) 
	{
		unset ($this->_module_mid_cache[$mid]);
	}

	return true;
}

function &get_all()
{
	return $this->_module_mid_cache;
}

function &get($mid)
{
	$mid = intval($mid);
	if ($mid <= 0)  return false;

	if ( isset($this->_module_mid_cache[$mid]) ) 
	{
		return $this->_module_mid_cache[$mid];
	}

	return false;
}

function get_num()
{
	$sql = "SELECT count(*) FROM ". $this->_table;

	$result = $this->db->query($sql);
	if ( !$result )
	{
		$this->_print_db_error($sql);
		return false;
	}

	$array = $this->db->fetchRow( $result );
	$num   = $array[0];
	if (empty($num)) $num = 0;

	return $num;
}

function _check_class( &$module )
{
	if (strtolower(get_class($module)) == $this->_class_name) 
	{
		return true;
	}

	return false;
}


//---------------------------------------------------------
// debug
//---------------------------------------------------------
function _print_db_error($sql='')
{
	if ( !$this->_flag_print_db_error )  return;

	if ($sql)
	{
		echo "sql: $sql <br />\n";
	}

	echo "error: ".$this->db->error()," <br />\n";	
}

// --- class end ---
}

?>