<?php
// $Id: functions.php,v 1.4 2005/10/28 11:56:05 ohwada Exp $

// 2005-10-20 K.OHWADA
// REQ 3110: Add in this category
// BUG 3111: timeout occurs in popular site if many top categories

// 2005-09-01 K.OHWADA
// POST & GET variables

// 2005-01-20 K.OHWADA
// assignIndex()
// w3c validation: "selected='selected'"

// 2004-11-28 K.OHWADA
// delete function printSubmitForm()
// delete function clearError(), setError(), getErrorFlag(), showError()
// delete function convJs(), makePasswd()

// 2004-11-22 K.OHWADA
// delete function presume_agent()
// second guidance bar

// 2004-11-20 K.OHWADA
// printSubmitForm()
//   maxlength of url 80 -> 250
//   arbitrary item

// 2004-10-24 K.OHWADA
// mutual site, recommend site 
// change procedure of banner image
//   move getImageWidthHeight() to class
// change procedure of oderby
//   move convertorderbydefault() and others to class 
// use system lang file
//   _WLS_SR_xx -> _SR_xx
// ratelink_use
// RSS/ATOM URL
// user comment
// add function getXoopsUname(), getXoopsEmail()

// 2004/08/10 K.OHWADA
// add function printSubmitForm, presume_agent
// delete function assignSubmitLink

//================================================================
// functions
// 2004/01/23 K.OHWADA
//================================================================

include_once XOOPS_ROOT_PATH."/include/xoopscodes.php";

//-------------------------------------------------------------------
// POST & GET variables
//-------------------------------------------------------------------
function get_post($key, $default='')
{
	if ( isset($_POST[$key]) )
	{
		$val = $_POST[$key];
	}
	else
	{
		$val = $default;
	}

	return $val;
}

function get_get($key, $default='')
{
	if ( isset($_GET[$key]) )
	{
		$val = $_GET[$key];
	}
	else
	{
		$val = $default;
	}

	return $val;
}

function get_post_get($key, $default='')
{
	if ( isset($_POST[$key]) )
	{
		$val = $_POST[$key];
	}
	elseif ( isset($_GET[$key]) )
	{
		$val = $_GET[$key];
	}
	else
	{
		$val = $default;
	}

	return $val;
}

function get_post_int($key, $default=0)
{
	if ( isset($_POST[$key]) )
	{
		$val = $_POST[$key];
	}
	else
	{
		$val = $default;
	}

	return intval($val);
}

function get_get_int($key, $default=0)
{
	if ( isset($_GET[$key]) )
	{
		$val = $_GET[$key];
	}
	else
	{
		$val = $default;
	}

	return intval($val);
}

function get_post_get_int($key, $default=0)
{
	if ( isset($_POST[$key]) )
	{
		$val = $_POST[$key];
	}
	elseif ( isset($_GET[$key]) )
	{
		$val = $_GET[$key];
	}
	else
	{
		$val = $default;
	}

	return intval($val);
}

//-------------------------------------------------------------------
// assign template
//-------------------------------------------------------------------
function assignIndex()
{
	global $xoopsTpl;

	global $xoopsModuleConfig;
	$TOPTEN_LINKS = intval($xoopsModuleConfig['topten_links']);

	$xoopsTpl->assign('logoshow',       $xoopsModuleConfig['logoshow']);
	$xoopsTpl->assign('titleshow',      $xoopsModuleConfig['titleshow']);

	global $XOOPS_LANGUAGE;
	$xoopsTpl->assign('xoops_language', $XOOPS_LANGUAGE);

	global $MODULE_NAME, $MODULE_URL;
	$xoopsTpl->assign('module_name',    $MODULE_NAME);
	$xoopsTpl->assign('module_url',     $MODULE_URL);

	global $lang;
	$happy_linux_url = $lang->get_happy_linux_url();
	$xoopsTpl->assign('happy_linux_url',  $happy_linux_url );

// total count
	global $tbl_link, $tbl_atomfeed;
	$total_site_recommend = $tbl_link->getNumByMark('recommend');
	$total_site_mutual    = $tbl_link->getNumByMark('mutual');
	$total_site_rss       = $tbl_link->getNumRssFlag();
	$total_atomfeed       = $tbl_atomfeed->getNumAll();

	$xoopsTpl->assign('total_site_recommend', $total_site_recommend);
	$xoopsTpl->assign('total_site_mutual',    $total_site_mutual);
	$xoopsTpl->assign('total_site_rss',       $total_site_rss);
	$xoopsTpl->assign('total_atomfeed',       $total_atomfeed);

// BUG 3111: timeout occurs in popular site if many top categories
	$xoopsTpl->assign('total_site_topten', "top".$TOPTEN_LINKS);

// search
	$and = "selected='selected'";
	$xoopsTpl->assign('search_and',     $and);
	$xoopsTpl->assign('search_or',      '');
	$xoopsTpl->assign('search_exact',   '');
	$xoopsTpl->assign('search_query',   '');

// REQ 3110: Add in this category
	if ( isset($_GET['cid']) )
	{
		$xoopsTpl->assign('cid', $_GET['cid']);
	}

// --- lang ---
	$xoopsTpl->assign('lang_search',   _WLS_SEARCH);
	$xoopsTpl->assign('lang_all',      _SR_ALL);
	$xoopsTpl->assign('lang_any',      _SR_ANY);
	$xoopsTpl->assign('lang_exact',    _SR_EXACT);
	$xoopsTpl->assign('lang_nomatch',  _WLS_NOMATCH);

// guidance bar
	$xoopsTpl->assign('lang_main',           _WLS_MAIN);
	$xoopsTpl->assign('lang_submitlink',     _WLS_SUBMIT_NEW_LINK);
	$xoopsTpl->assign('lang_site_popular',   _WLS_SITE_POPULAR);	
	$xoopsTpl->assign('lang_site_highrate',  _WLS_SITE_HIGHRATE);
	$xoopsTpl->assign('lang_site_recommend', _WLS_SITE_RECOMMEND);
	$xoopsTpl->assign('lang_site_mutual',    _WLS_SITE_MUTUAL);

// second guidance bar
	$xoopsTpl->assign('lang_catlist',        _WLS_CATLIST);
	$xoopsTpl->assign('lang_site_rss',       _WLS_SITE_RSS);
	$xoopsTpl->assign('lang_atomfeed',       _WLS_ATOMFEED);
	$xoopsTpl->assign('lang_site_random',    _WLS_SITE_RANDOM);

// index.php
	$xoopsTpl->assign('lang_new_sitelist',   _WLS_NEW_SITELIST);
	$xoopsTpl->assign('lang_new_atomfeed',   _WLS_NEW_ATOMFEED);

}

function assignDisplayLink()
{
	global $xoopsTpl;
	global $tbl_link;

	$tbl_link->assignDisplayLink($xoopsTpl);
}


//-------------------------------------------------------------------
// misc
//-------------------------------------------------------------------
function highlight_number($num)
{
	if ($num>0)
	{
		$num = "<span style='color: #ff0000; font-weight: bold'>$num</span>";
	}

	return $num;
}

//-------------------------------------------------------------------
// for debug
//-------------------------------------------------------------------
function getmicrotime()
{ 
	list($usec, $sec) = explode(" ",microtime()); 
	return ((float)$sec + (float)$usec); 
} 

function print_time($str='')
{
	global $time_start, $time_prev;

	$time = getmicrotime();

	if (empty($time_start)) $time_start = $time;
	if (empty($time_prev))  $time_prev  = $time;

	$time1 = $time - $time_start;
	$time2 = $time - $time_prev;
	$time_prev = $time;

	print "$str: $time1: $time2 <br />";
}
   
?>
