<?php
// $Id: topten.php,v 1.4 2005/10/28 11:56:02 ohwada Exp $

// 2005-10-20 K.OHWADA
// BUG 3111: timeout occurs in popular site if many top categories
// add get_rankings_each() get_rankings_mixed()

// 2005-09-04 K.OHWADA
// BUG 2932: dont work correctly when register_long_arrays = off

// 2004-12-12 K.OHWADA
// correspond to order of category arrange

// 2004-11-20 K.OHWADA
// add assignDisplayLink()

// 2004/08/10 K.OHWADA
// enable to install this module two or more. 

//================================================================
// view top ten
// use class weblinksCategory, weblinksLink
// 2004/01/23 K.OHWADA
//================================================================

include "header.php";

// enable to install this module two or more. 

$weblinks_topten_error = '';

$TOPTEN_STYLE = intval($xoopsModuleConfig['topten_style']);
$MAX_LINKS    = intval($xoopsModuleConfig['topten_links']);

if ( $TOPTEN_STYLE )
{
	$xoopsOption['template_main'] = $MODULE_DIRNAME."_topten_mixed.html";
}
else
{
	$xoopsOption['template_main'] = $MODULE_DIRNAME."_topten.html";
}

include XOOPS_ROOT_PATH."/header.php";

// BUG 2932: dont work correctly when register_long_arrays = off
$rate = get_get_int('rate');

//generates top 10 charts by rating and hits for each main category
if( $rate == 1 )
{
	$title  = _WLS_SITE_HIGHRATE;
	$sort   = _WLS_RATING;
	$sortDB = "rating";
}
else
{
	$title  = _WLS_SITE_POPULAR;
	$sort   = _WLS_HITS;
	$sortDB = "hits";
}

assignIndex();
assignDisplayLink();

$topten_title = sprintf(_WLS_TOPTEN_TITLE, $title, $MAX_LINKS);

$xoopsTpl->assign('lang_topten_title', $topten_title);
$xoopsTpl->assign('lang_sortby',       $sort);

if ( $TOPTEN_STYLE )
{
	$rankings = get_rankings_mixed($sortDB);
}
else
{
	$rankings = get_rankings_each($sortDB);
}

$xoopsTpl->assign('rankings', $rankings);

if ( $weblinks_topten_error )
{
	$xoopsTpl->assign('lang_topten_error', $weblinks_topten_error);
}

include XOOPS_ROOT_PATH.'/footer.php';
exit();
// --- main end ---


function get_rankings_each($sortDB)
{
	global $xoopsModuleConfig;
	$MAX_CATS  = intval($xoopsModuleConfig['topten_cats']);
	$MAX_LINKS = intval($xoopsModuleConfig['topten_links']);

	global $tbl_link, $tbl_category;
	global $weblinks_topten_error;

	$i = 0;
	$arr      = array();
	$rankings = array();

	$tbl_category->getAll();
	$cid_arr = $tbl_category->getCidArrayByPid(0);

	$weblinks_topten_error = '';
	if ( count($cid_arr) > $MAX_CATS )
	{
		$weblinks_topten_error = sprintf(_WLS_TOPTEN_ERROR, $MAX_CATS);
	}

	foreach ($cid_arr as $cid)
	{
		$ctitle  = $tbl_category->getValueByCid($cid, 'title', 'S');

		$rankings[$i]['cid']   = $cid;
		$rankings[$i]['title'] = sprintf(_WLS_TOPTEN_TITLE, $ctitle, $MAX_LINKS);

// get all child cat ids for a given cat id
		$rank = 1;

		$array = array_merge(array($cid), $tbl_category->getAllChildId($cid));

		$orderby = "$sortDB DESC";
		$lid_arr = $tbl_link->getLidArrayByCidArray($array, $orderby, $MAX_LINKS, 0);

		foreach ($lid_arr as $lid) 
		{
			$record2 = $tbl_link->getRowByLid($lid);
			$rankings[$i]['links'][] = $tbl_link->makeDisplay($record2);
		}

		$i++;
		if ($i >= $MAX_CATS ) break;
	}

	return $rankings;
}

function get_rankings_mixed($sortDB)
{
	global $xoopsModuleConfig;
	$MAX_LINKS = intval($xoopsModuleConfig['topten_links']);

	global $tbl_link;

	$rankings = array();

	$orderby = "$sortDB DESC";
	$records = $tbl_link->getRowsByOrderby($orderby, $MAX_LINKS, 0);

	foreach ($records as $record) 
	{
		$rankings[] = $tbl_link->makeDisplay($record);
	}

	return $rankings;
}


?>