<?php
// $Id: func.atom.php,v 1.3 2005/08/09 02:17:10 ohwada Exp $

// 2005-08-08 K.OHWADA
// summary became one line
// BUG 2824: the CDATA-section-close delimiter "]]>" MUST be escaped "]]&gt;"

// 2005-06-20 K.OHWADA
// add whatsnew_view_atom()
// use ConvertLanguage()
// use version.php

// 2004-09-01 K.OHWADA
// change whatsnew_iso8601_date()

//=========================================================
// What's New Module
// build ATOM 
// 2004/08/20 K.OHWADA
//=========================================================
include_once XOOPS_ROOT_PATH.'/class/template.php';
include_once XOOPS_ROOT_PATH.'/class/xoopsuser.php';
include_once XOOPS_ROOT_PATH.'/modules/whatsnew/include/func.whatsnew.php';
include_once XOOPS_ROOT_PATH."/modules/whatsnew/include/version.php";
include_once XOOPS_ROOT_PATH.'/modules/whatsnew/class/base_language.php';

// for local language
$file_convert = XOOPS_ROOT_PATH.'/modules/whatsnew/language/'.$xoopsConfig['language'].'/convert_language.php';

if (file_exists( $file_convert )) 
{
	include_once $file_convert;
}
else
{
	include_once XOOPS_ROOT_PATH.'/modules/whatsnew/language/english/convert_language.php';
}

function whatsnew_build_atom($cache_time=0)
{
	$TEMPLATE    = 'db:whatsnew_atom.html';
	$FILE_CONFIG = XOOPS_ROOT_PATH."/modules/whatsnew/cache/conf.php";

	if ( file_exists($FILE_CONFIG) ) 
	{
		include $FILE_CONFIG;
	}
	else
	{
		return;
	}

// no output encode
	if (function_exists('mb_http_output')) 
	{	mb_http_output('pass');	}

	header ('Content-Type:text/xml; charset=utf-8');

	$tpl = new XoopsTpl();

	if ($cache_time > 0)
	{
		$tpl->xoops_setCaching(2);
		$tpl->xoops_setCacheTime($cache_time);
	}

	if ( !$tpl->is_cached($TEMPLATE) || ($cache_time == 0) )
	{
		$article_arr = whatsnew_get_new($whatsnew_module, 'rss_show', 'rss_limit', $whatsnew_rss_limit_show);
		whatsnew_assign_atom( $tpl, $article_arr, $whatsnew_config );
	}

	$tpl->display($TEMPLATE);
}

function whatsnew_view_atom()
{
	$TEMPLATE    = 'db:whatsnew_atom.html';
	$FILE_CONFIG = XOOPS_ROOT_PATH."/modules/whatsnew/cache/conf.php";

	if ( file_exists($FILE_CONFIG) ) 
	{
		include $FILE_CONFIG;
	}
	else
	{
		return;
	}

	header ('Content-Type:text/html; charset=utf-8');

	$tpl = new XoopsTpl();

	$article_arr = whatsnew_get_new($whatsnew_module, 'rss_show', 'rss_limit', $whatsnew_rss_limit_show);
	whatsnew_assign_atom( $tpl, $article_arr, $whatsnew_config );

	$xml  = $tpl->fetch($TEMPLATE);
	$body = htmlspecialchars( $xml, ENT_QUOTES );

?>
<html>
<head>
<meta http-equiv="content-type" content="text/html; charset=utf-8" />
<title>whats new rss</title>
</head>
<body>
<pre>
<?php echo $body; ?>
</pre>
</body>
</html>
<?php

}

//---------------------------------------------------------
// http://www.mnot.net/drafts/draft-nottingham-atom-format-02.html
// required paramter
// feed elements 
//   - title
//   - link
//   - modified
//   - author name
// entry elements 
//   - id
//   - title
//   - link
//   - modified
//   - issued
//   - author name
//---------------------------------------------------------
function whatsnew_assign_atom( &$tpl, $article_arr, $config )
{
	$lang = new ConvertLanguage();

	$GENERATOR     = 'XOOPS WhatsNew '._WHATSNEW_VERSION;
	$GENERATOR_URL = 'http://linux.ohwada.jp/';
	$MODULE_ID_DEFUALT = 1;

	$tpl->assign('feed_title', $lang->convert_to_utf8( htmlspecialchars($config['site_name'], ENT_QUOTES) ) );

	$site_url = $config['site_url'];
	$tpl->assign('feed_link', $site_url);

	$time_now = time();
	$modified = whatsnew_iso8601_date( $time_now );
	$tpl->assign('feed_modified', $modified);

	$tag  = $config['site_tag'];
	$year = date("Y");
	$feed_id = "tag:$tag,$year://1";
	$tpl->assign('feed_id', $feed_id);

	$tpl->assign('feed_generator',     $GENERATOR);
	$tpl->assign('feed_generator_url', $GENERATOR_URL);

	$site_author      = $config['site_author'];
	$site_author_utf8 = $lang->convert_to_utf8( $site_author );
	$tpl->assign('feed_author_name', $site_author_utf8 );

	$tpl->assign('feed_author_url',  $site_url);

	if ( isset($config['site_email']) )
	{
		$tpl->assign('feed_author_email', $config['site_email'] );
	}

	$copyright = "Copyright (c) $year, $site_author";
	$copyright = $lang->convert_to_utf8( $copyright );
	$tpl->assign('feed_copyright', $copyright );

	$max_summary = $config['rss_max_summary'];

	$ii = 1;
	foreach ($article_arr as $article)
	{
		$title = $lang->convert_to_utf8( htmlspecialchars ($article['title'], ENT_QUOTES) );

		$link = $article['link'];

		if ( isset($article['modified']) )
		{
			$modified = $article['modified'];
		}
		elseif( isset($article['time']) )
		{
			$modified = $article['time'];
		}
		else
		{
			$modified = $time_now;
		}

		if ( isset($article['issued']) )
		{
			$issued = $article['issued'];
		}
		else
		{
			$issued = $modified;
		}

		$modified = whatsnew_iso8601_date($modified);
		$issued   = whatsnew_iso8601_date($issued);

		$created = '';
		if ( isset($article['created']) )
		{
			$created = $article['created'];
			$created = whatsnew_iso8601_date($created);
		}

		$mid = '';
		$aid = '';
		if ( isset($article['module_id']) )  $mid = $article['module_id'];
		if ( isset($article['id']) )         $aid = $article['id'];
		if ( empty($mid) )  $mid = $MODULE_ID_DEFUALT;
		if ( empty($aid) )  $aid = $ii;

		$id = "tag:$tag,$year://1.$mid.$aid";

		$desc = '';
		if ( isset($article['description']) ) $desc = $article['description'];

		$summary = '';
		$content = '';
		if ( $desc )
		{
			$desc    = whatsnew_sanitize_control_code($desc);

// summary became one line
			$summary = whatsnew_sanitize_crlf( $desc );

			$summary = strip_tags( $summary );
			$summary = whatsnew_shorten_text( $summary, $max_summary );
			$summary = whatsnew_htmlspecialchars( $summary );
			$summary = $lang->convert_to_utf8( $summary );

// BUG 2824: the CDATA-section-close delimiter "]]>" MUST be escaped "]]&gt;"
			$content = whatsnew_convert_cdata( $desc );
			$content = $lang->convert_to_utf8( $content );
		}

		$dc_subject = '';
		if ( isset($article['module_name']) )
		{
			$dc_subject = $lang->convert_to_utf8( $article['module_name'] );
		}

		$author_name = '';
		if ( isset($article['uid']) )
		{
			$user = new xoopsUser( $article['uid'] );
			$author_name = $user->getvar('uname');
		}

		if (empty($author_name)) $author_name = $site_author;

		$author_name = $lang->convert_to_utf8( $author_name );

		$author_url   = '';
		$author_email = '';

		$tpl->append('entrys', 
			array(
				'title'    => $title,
				'link'     => $link,
				'modified' => $modified,
				'issued'   => $issued, 
				'created'  => $created, 
				'id'       => $id, 
				'summary'  => $summary,
				'content'  => $content,
				'content_base' => $site_url,
				'dc_subject'   => $dc_subject,
				'author_name'  => $author_name,
				'author_url'   => $author_url,
				'author_email' => $author_email,
			));
	
		$ii ++;
	}
}

function whatsnew_clear_atom()
{
	$TEMPLATE = 'db:whatsnew_atom.html';

	$tpl = new XoopsTpl();
	$tpl->clear_cache($TEMPLATE);
}

?>
