<?php
/**
 * $Id: xoops_version.php,v 1.11 2005/04/13 06:18:31 tohokuaiki Exp $
 * Copyright (c) 2003 by Jeremy N. Cowgar <jc@cowgar.com>
 * Copyright (c) 2003 by Hiro SAKAI (http://wellwine.net/)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * You may not change or alter any portion of this comment or credits
 * of supporting developers from this source code or any supporting
 * source code which is considered copyrighted (c) material of the
 * original comment or credit authors.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */

$modversion['name'] = _MI_WEBLOG_NAME;
$modversion['version'] = 1.41;
$modversion['description'] = _MI_WEBLOG_DESC;
$modversion['author'] = "Hiro SAKAI<br />(http://wellwine.net)<br />ITOH Takashi<br />(http://tohokuaiki.jp)";
$modversion['credits'] = "Xoops System";
$modversion['help'] = "weblog_help.html";
$modversion['license'] = "GPL";
$modversion['official'] = 0;
$modversion['image'] = "images/weblog_slogo.png";
$modversion['dirname'] = "weblog";

// Sql file (must contain sql generated by phpMyAdmin or phpPgAdmin)
// All tables should not have any prefix!
$modversion['sqlfile']['mysql'] = "sql/mysql.sql";

// Tables created by sql file (without prefix!)
$modversion['tables'][0] = 'weblog';
$modversion['tables'][1] = 'weblog_category';
$modversion['tables'][2] = 'weblog_priv';
$modversion['tables'][3] = 'weblog_trackback';
$modversion['tables'][4] = 'weblogmyalbum_photos';

// Admin things
$modversion['hasAdmin'] = 1;
$modversion['adminindex'] = "admin/index.php";
$modversion['adminmenu'] = "admin/menu.php";

// Config Options
$modversion['config'] = array() ;
$modversion['config'][] = array(
	'name' => 'numperpage',
	'title' => '_MI_WEBLOG_NUMPERPAGE',
	'description' => '_MI_WEBLOG_NUMPERPAGEDSC',
	'formtype' => 'select',
	'valuetype' => 'int',
	'default' => 10,
	'options' => array('5' => 5, '10' => 10, '15' => 15, '20' => 20, '25' => 25, '30' => 30, '50' => 50)
) ;

$modversion['config'][] = array(
	'name' => 'dateformat',
	'title' => '_MI_WEBLOG_DATEFORMAT',
	'description' => '_MI_WEBLOG_DATEFORMATDSC',
	'formtype' => 'textbox',
	'valuetype' => 'text',
	'default' => 'Y/m/d'
) ;

$modversion['config'][] = array(
	'name' => 'timeformat',
	'title' => '_MI_WEBLOG_TIMEFORMAT',
	'description' => '_MI_WEBLOG_TIMEFORMATDSC',
	'formtype' => 'textbox',
	'valuetype' => 'text',
	'default' => 'g:i a'
) ;

$modversion['config'][] = array(
	'name' => 'update_reads_when',
	'title' => '_MI_WEBLOG_UPDATE_READS_WHEN',
	'description' => '_MI_WEBLOG_UPDATE_READS_WHENDSC',
	'formtype' => 'select',
	'valuetype' => 'int',
	'default' => 1,
	'options' => array('_MI_WEBLOG_UPDATE_READS_WHEN1'=>1,
                                            '_MI_WEBLOG_UPDATE_READS_WHEN2'=>2,
                                            '_MI_WEBLOG_UPDATE_READS_WHEN3'=>3)
) ;

$modversion['config'][] = array(
	'name' => 'showavatar',
	'title' => '_MI_WEBLOG_SHOWAVATAR',
	'description' => '_MI_WEBLOG_SHOWAVATARDSC',
	'formtype' => 'yesno',
	'valuetype' => 'int',
	'default' => 1
) ;

$modversion['config'][] = array(
	'name' => 'minentrysize',
	'title' => '_MI_WEBLOG_MINENTRYSIZE',
	'description' => '_MI_WEBLOG_MINENTRYSIZEDSC',
	'formtype' => 'textbox',
	'valuetype' => 'int',
	'default' => 75
) ;

$modversion['config'][] = array(
	'name' => 'editorheight',
	'title' => '_MI_WEBLOG_EDITORHEIGHT',
	'description' => '_MI_WEBLOG_EDITORHEIGHTDSC',
	'formtype' => 'textbox',
	'valuetype' => 'int',
	'default' => 20
) ;

$modversion['config'][] = array(
	'name' => 'editorwidth',
	'title' => '_MI_WEBLOG_EDITORWIDTH',
	'description' => '_MI_WEBLOG_EDITORWIDTHDSC',
	'formtype' => 'textbox',
	'valuetype' => 'int',
	'default' => 70
) ;

$modversion['config'][] = array(
	'name' => 'adminonly',
	'title' => '_MI_WEBLOG_ONLYADMIN',
	'description' => '_MI_WEBLOG_ONLYADMINDSC',
	'formtype' => 'yesno',
	'valuetype' => 'int',
	'default' => 0
) ;

$modversion['config'][] = array(
// wellwine for read cookie begins
	'name' => 'expiration',
	'title' => '_MI_WEBLOG_EXPIRATION',
	'description' => '_MI_WEBLOG_EXPIRATIONDSC',
	'formtype' => 'textbox',
	'valuetype' => 'int',
	'default' => 86400
) ;

$modversion['config'][] = array(
// wellwine for rss feed
	'name' => 'rssshow',
	'title' => '_MI_WEBLOG_RSSSHOW',
	'description' => '_MI_WEBLOG_RSSSHOWDSC',
	'formtype' => 'yesno',
	'valuetype' => 'int',
	'default' => 1
) ;

$modversion['config'][] = array(
	'name' => 'rssmax',
	'title' => '_MI_WEBLOG_RSSMAX',
	'description' => '_MI_WEBLOG_RSSMAXDSC',
	'formtype' => 'textbox',
	'valuetype' => 'int',
	'default' => 10
) ;

$modversion['config'][] = array(
	'name' => 'imgurl',
	'title' => '_MI_WEBLOG_IMGURL',
	'description' => '_MI_WEBLOG_IMGURLDSC',
	'formtype' => 'textbox',
	'valuetype' => 'text',
	'default' => XOOPS_URL.'/images/logo.gif'
) ;

$modversion['config'][] = array(
	'name' => 'default_dohtml',
	'title' => '_MI_WEBLOG_OPDOHTML',
	'description' => '_MI_WEBLOG_OPDOHTMLDSC',
	'formtype' => 'yesno',
	'valuetype' => 'int',
	'default' => 1
) ;

$modversion['config'][] = array(
	'name' => 'default_private',
	'title' => '_MI_WEBLOG_OPPRIVATE',
	'description' => '_MI_WEBLOG_OPPRIVATEDSC',
	'formtype' => 'yesno',
	'valuetype' => 'int',
	'default' => 0
) ;

$modversion['config'][] = array(
	'name' => 'default_updateping',
	'title' => '_MI_WEBLOG_OPUPDATEPING',
	'description' => '_MI_WEBLOG_OPUPDATEPINGDSC',
	'formtype' => 'yesno',
	'valuetype' => 'int',
	'default' => 0
) ;

$modversion['config'][] = array(
	'name' => 'use_separator',
	'title' => '_MI_WEBLOG_USESEPARATOR',
	'description' => '_MI_WEBLOG_USESEPARATORDSC',
	'formtype' => 'yesno',
	'valuetype' => 'int',
	'default' => 0
) ;

$modversion['config'][] = array(
	'name' => 'use_memberonly',
	'title' => '_MI_WEBLOG_USESMEMBERONLY',
	'description' => '_MI_WEBLOG_USESMEMBERONLYDSC',
	'formtype' => 'yesno',
	'valuetype' => 'int',
	'default' => 0
);

$modversion['config'][] = array(
	'name' => 'use_imagemanager',
	'title' => '_MI_WEBLOG_USEIMAGEMANAGER',
	'description' => '_MI_WEBLOG_USEIMAGEMANAGERDSC',
	'formtype' => 'yesno',
	'valuetype' => 'int',
	'default' => 0
);

$modversion['config'][] = array(
	'name'			=> 'weblog_myalbum_photospath' ,
	'title'			=> '_MI_ALBM_CFG_PHOTOSPATH' ,
	'description'	=> '_MI_ALBM_CFG_DESCPHOTOSPATH' ,
	'formtype'		=> 'textbox' ,
	'valuetype'		=> 'text' ,
	'default'		=> "/uploads/weblog_imagephotos" ,
	'options'		=> array()
) ;
$modversion['config'][] = array(
	'name'			=> 'weblog_myalbum_thumbspath' ,
	'title'			=> '_MI_ALBM_CFG_THUMBSPATH' ,
	'description'	=> '_MI_ALBM_CFG_DESCTHUMBSPATH' ,
	'formtype'		=> 'textbox' ,
	'valuetype'		=> 'text' ,
	'default'		=> "/uploads/weblog_imagethumbs" ,
	'options'		=> array()
) ;
$modversion['config'][] = array(
	'name'			=> 'weblog_myalbum_width' ,
	'title'			=> '_MI_ALBM_CFG_WIDTH' ,
	'description'	=> '_MI_ALBM_CFG_DESCWIDTH' ,
	'formtype'		=> 'textbox' ,
	'valuetype'		=> 'int' ,
	'default'		=> '2048' ,
	'options'		=> array()
) ;
$modversion['config'][] = array(
	'name'			=> 'weblog_myalbum_height' ,
	'title'			=> '_MI_ALBM_CFG_HEIGHT' ,
	'description'	=> '_MI_ALBM_CFG_DESCHEIGHT' ,
	'formtype'		=> 'textbox' ,
	'valuetype'		=> 'int' ,
	'default'		=> '2048' ,
	'options'		=> array()
) ;
$modversion['config'][] = array(
	'name'			=> 'weblog_myalbum_fsize' ,
	'title'			=> '_MI_ALBM_CFG_FSIZE' ,
	'description'	=> '_MI_ALBM_CFG_DESCFSIZE' ,
	'formtype'		=> 'textbox' ,
	'valuetype'		=> 'int' ,
	'default'		=> '1200000' ,
	'options'		=> array()
) ;
$modversion['config'][] = array(
	'name'			=> 'weblog_myalbum_middlepixel' ,
	'title'			=> '_MI_ALBM_CFG_MIDDLEPIXEL' ,
	'description'	=> '_MI_ALBM_CFG_DESCMIDDLEPIXEL' ,
	'formtype'		=> 'textbox' ,
	'valuetype'		=> 'text' ,
	'default'		=> '480x480' ,
	'options'		=> array()
) ;
$modversion['config'][] = array(
	'name'			=> 'weblog_myalbum_thumbsize' ,
	'title'			=> '_MI_ALBM_CFG_THUMBSIZE' ,
	'description'	=> '' ,
	'formtype'		=> 'textbox' ,
	'valuetype'		=> 'int' ,
	'default'		=> '140' ,
	'options'		=> array()
) ;
$modversion['config'][] = array(
	'name'			=> 'weblog_myalbum_thumbrule' ,
	'title'			=> '_MI_ALBM_CFG_THUMBRULE' ,
	'description'	=> '' ,
	'formtype'		=> 'select' ,
	'valuetype'		=> 'text' ,
	'default'		=> 'w' ,
	'options'		=> array(
		'_MI_ALBUM_OPT_CALCFROMWIDTH' => 'w' , '_MI_ALBUM_OPT_CALCFROMHEIGHT' => 'h' , '_MI_ALBUM_OPT_CALCWHINSIDEBOX' => 'b' )
) ;



// Templates
$modversion['templates'][1]['file'] = 'weblog_entries.html';
$modversion['templates'][1]['description'] = _MI_WEBLOG_TEMPLATE_ENTRIESDSC;
$modversion['templates'][2]['file'] = 'weblog_post.html';
$modversion['templates'][2]['description'] = _MI_WEBLOG_TEMPLATE_POSTDSC;
$modversion['templates'][3]['file'] = 'weblog_details.html';
$modversion['templates'][3]['description'] = _MI_WEBLOG_TEMPLATE_DETAILSDSC;
$modversion['templates'][4]['file'] = 'weblog_rss.html';
$modversion['templates'][4]['description'] = _MI_WEBLOG_TEMPLATE_RSSFEEDDSC;
$modversion['templates'][5]['file'] = 'weblog_print.html';
$modversion['templates'][5]['description'] = _MI_WEBLOG_TEMPLATE_PRINTDSC;
$modversion['templates'][6]['file'] = 'weblog_archive.html';
$modversion['templates'][6]['description'] = _MI_WEBLOG_TEMPLATE_ARCHIVEDSC;
$modversion['templates'][7]['file'] = "weblog_imagemanager.html" ;
$modversion['templates'][7]['description'] = _MI_WEBLOG_TEMPLATE_IMAGEMANAGERDSC;

// Search
$modversion['hasSearch'] = 1;
$modversion['search']['file'] = 'include/search.inc.php';
$modversion['search']['func'] = 'weblog_search';

//Blocks
$modversion['blocks'][1]['file'] = 'weblog_recent.php';
$modversion['blocks'][1]['name'] = _MI_WEBLOG_RECENT_BNAME1;
$modversion['blocks'][1]['description'] = _MI_WEBLOG_RECENT_BNAME1_DESC;
$modversion['blocks'][1]['show_func'] = 'b_weblog_recent_show';
$modversion['blocks'][1]['edit_func'] = 'b_weblog_recent_edit';
$modversion['blocks'][1]['template'] = 'weblog_block_recent.html';
$modversion['blocks'][1]['options'] = '10|25|Y/m/d|1|1|1';

$modversion['blocks'][2]['file'] = 'weblog_recent.php';
$modversion['blocks'][2]['name'] = _MI_WEBLOG_TOP_WEBLOGS;
$modversion['blocks'][2]['description'] = _MI_WEBLOG_TOP_WEBLOGS_DESC;
$modversion['blocks'][2]['show_func'] = 'b_weblog_top_weblogs_show';
$modversion['blocks'][2]['edit_func'] = 'b_weblog_top_weblogs_edit';
$modversion['blocks'][2]['template'] = 'weblog_block_top_weblogs.html';
$modversion['blocks'][2]['options'] = '10|1|1';

$modversion['blocks'][3]['file'] = 'weblog_recent.php';
$modversion['blocks'][3]['name'] = _MI_WEBLOG_USERS_WEBLOGS;
$modversion['blocks'][3]['description'] = _MI_WEBLOG_USERS_WEBLOGS_DESC;
$modversion['blocks'][3]['show_func'] = 'b_weblog_users_weblogs_show';
$modversion['blocks'][3]['edit_func'] = 'b_weblog_users_weblogs_edit';
$modversion['blocks'][3]['template'] = 'weblog_block_users_weblogs.html';
$modversion['blocks'][3]['options'] = '5|5|Y/m/d|0|0|0|25';

$modversion['blocks'][4]['file'] = 'weblog_recent.php';
$modversion['blocks'][4]['name'] = _MI_WEBLOG_RECENT_TRACKBACKS;
$modversion['blocks'][4]['description'] = _MI_WEBLOG_RECENT_TRACKBACKS_DESC;
$modversion['blocks'][4]['show_func'] = 'b_weblog_recent_tb_show';
$modversion['blocks'][4]['edit_func'] = 'b_weblog_recent_tb_edit';
$modversion['blocks'][4]['template'] = 'weblog_block_recent_tb.html';
$modversion['blocks'][4]['options'] = '5|25|Y/m/d|2';

$modversion['blocks'][5]['file'] = 'weblog_recent.php';
$modversion['blocks'][5]['name'] = _MI_WEBLOG_RECENT_COMMENTS;
$modversion['blocks'][5]['description'] = _MI_WEBLOG_RECENT_COMMENTS_DESC;
$modversion['blocks'][5]['show_func'] = 'b_weblog_recent_comment_show';
$modversion['blocks'][5]['edit_func'] = 'b_weblog_recent_comment_edit';
$modversion['blocks'][5]['template'] = 'weblog_block_recent_com.html';
$modversion['blocks'][5]['options'] = '5|25|Y/m/d|2';

$modversion['blocks'][6]['file'] = 'weblog_links.php';
$modversion['blocks'][6]['name'] = _MI_WEBLOG_LINKS;
$modversion['blocks'][6]['description'] = _MI_WEBLOG_LINKS_DESC;
$modversion['blocks'][6]['show_func'] = 'b_weblog_links_show';
$modversion['blocks'][6]['edit_func'] = 'b_weblog_links_edit';
$modversion['blocks'][6]['template'] = 'weblog_block_links.html';
$modversion['blocks'][6]['options'] = '|10|0|1';

$modversion['blocks'][7]['file'] = 'weblog_recent.php';
$modversion['blocks'][7]['name'] = _MI_WEBLOG_RECENT_IMAGES;
$modversion['blocks'][7]['description'] = _MI_WEBLOG_RECENT_IMAGES_DESC;
$modversion['blocks'][7]['show_func'] = 'b_weblog_recent_image_show';
$modversion['blocks'][7]['edit_func'] = 'b_weblog_recent_image_edit';
$modversion['blocks'][7]['template'] = 'weblog_block_recent_image.html';
$modversion['blocks'][7]['options'] = '5|20|0|Y/m/d';

// Menu
$modversion['hasMain'] = 1;
$modversion['sub'][1]['name'] = _MI_WEBLOG_SMNAME1;
$modversion['sub'][1]['url'] = 'myblog.php';
$modversion['sub'][2]['name'] = _MI_WEBLOG_SMNAME2;
$modversion['sub'][2]['url'] = 'post.php';
$modversion['sub'][3]['name'] = _MI_WEBLOG_SMNAME3;
$modversion['sub'][3]['url'] = 'archive.php';

// Smarty
$modversion['use_smarty'] = 1;

// Comments
$modversion['hasComments'] = 1;
$modversion['comments']['pageName'] = 'details.php';
$modversion['comments']['itemName'] = 'blog_id';

$modversion['comments']['callbackFile'] = 'include/comment_functions.php';
$modversion['comments']['callback']['approve'] = 'weblog_com_approve';
$modversion['comments']['callback']['update'] = 'weblog_com_update';

// Notifications
$modversion['hasNotification'] = 1;

$modversion['notification']['lookup_file'] = 'include/notification.inc.php';
$modversion['notification']['lookup_func'] = 'blog_info';

$modversion['notification']['category'][1]['name'] = 'blog';
$modversion['notification']['category'][1]['title'] = _MI_WEBLOG_NOTIFY;
$modversion['notification']['category'][1]['description'] = _MI_WEBLOG_NOTIFYDSC;
$modversion['notification']['category'][1]['subscribe_from'] = 'index.php';
$modversion['notification']['category'][1]['item_name'] = 'user_id';
$modversion['notification']['category'][1]['allow_bookmark'] = 1;

$modversion['notification']['category'][2]['name'] = 'blog_entry';
$modversion['notification']['category'][2]['title'] = _MI_WEBLOG_ENTRY_NOTIFY;
$modversion['notification']['category'][2]['description'] = _MI_WEBLOG_ENTRY_NOTIFYDSC;
$modversion['notification']['category'][2]['subscribe_from'] = 'details.php';
$modversion['notification']['category'][2]['item_name'] = 'blog_id';
$modversion['notification']['category'][2]['allow_bookmark'] = 1;

$modversion['notification']['event'][1]['name'] = 'add';
$modversion['notification']['event'][1]['category'] = 'blog';
$modversion['notification']['event'][1]['title'] = _MI_WEBLOG_ADD_NOTIFY;
$modversion['notification']['event'][1]['caption'] = _MI_WEBLOG_ADD_NOTIFYCAP;
$modversion['notification']['event'][1]['description'] = _MI_WEBLOG_ADD_NOTIFYDSC;
$modversion['notification']['event'][1]['mail_template'] = 'weblog_add_notify';
$modversion['notification']['event'][1]['mail_subject'] = _MI_WEBLOG_ADD_NOTIFYSBJ;
?>
