<?php
/**
 * @package Legacy
 * @version $Id: legacy_usermenu.php,v 1.1.2.3 2006/07/07 02:55:13 minahito Exp $
 */

 /**
  * This function is called back to display the user menu.
  * 
  * [Template Variables]
  *  $block.uid ... Curent user id for the menu.
  *  $block.flagShowInbox ... If there is the pm module, set true.
  *  $block.inbox_url ... Return url to access inbox of pm.
  *  $block.new_messages ... amount of unread messages.
  */
function b_legacy_usermenu_show()
{
    $root =& XCube_Root::getSingleton();
    $xoopsUser =& $root->mController->mXoopsUser;

    if (is_object($xoopsUser)) {
        $block = array();
        
        $block['uid'] = $xoopsUser->getVar('uid');
		$block['flagShowInbox'] = false;

		//
		// Check does this system have PrivateMessage feature.
		//
		$url = $root->mController->getPMInboxUrl($block['uid']);

		if ($url != null) {
			$block['inbox_url'] = $url;
			$block['new_messages'] = $root->mController->getCountUnreadPM($block['uid']);
			$block['flagShowInbox']=true;
		}

        return $block;
    }
    return false;
}
?>
