<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

class Legacy_SearchModule extends XCube_Object
{
	function getPropertyDefinition()
	{
		$ret = array(
			S_PUBLIC_VAR("int mid"),
			S_PUBLIC_VAR("string name")
		);
		
		return $ret;
	}
}

class Legacy_SearchModuleArray extends XCube_ObjectArray
{
	function getClassName()
	{
		return "Legacy_SearchModule";
	}
}


class Legacy_SearchItem extends XCube_Object
{
	function getPropertyDefinition()
	{
		$ret = array(
			S_PUBLIC_VAR("string image"),
			S_PUBLIC_VAR("string link"),
			S_PUBLIC_VAR("string title"),
			S_PUBLIC_VAR("int uid"),
			S_PUBLIC_VAR("int time")
		);
		
		return $ret;
	}
}

class Legacy_SearchItemArray extends XCube_ObjectArray
{
	function getClassName()
	{
		return "Legacy_SearchItem";
	}
}

class Legacy_SearchModuleResult extends XCube_Object
{
	function getPropertyDefinition()
	{
		$ret = array(
			S_PUBLIC_VAR("int mid"),
			S_PUBLIC_VAR("string name"),
			S_PUBLIC_VAR("int has_more"),
			S_PUBLIC_VAR("Legacy_SearchItemArray results"),
			S_PUBLIC_VAR("string showall_link")
		);
		
		return $ret;
	}
}

class Legacy_SearchModuleResultArray extends XCube_ObjectArray
{
	function getClassName()
	{
		return "Legacy_SearchModuleResult";
	}
}

class Legacy_ArrayOfInt extends XCube_ObjectArray
{
	function getClassName()
	{
		return "int";
	}
}

class Legacy_ArrayOfString extends XCube_ObjectArray
{
	function getClassName()
	{
		return "string";
	}
}

/**
 * Sample class
 */
class Legacy_SearchService extends XCube_Service
{
	var $mServiceName = "Legacy_SearchService";
	var $mNameSpace = "Legacy";
	var $mClassName = "Legacy_SearchService";
	
	function prepare()
	{
		$this->addType('Legacy_SearchModule');
		$this->addType('Legacy_SearchModuleArray');
		$this->addType('Legacy_SearchItem');
		$this->addType('Legacy_SearchItemArray');
		$this->addType('Legacy_SearchModuleResult');
		$this->addType('Legacy_SearchModuleResultArray');
		$this->addType('Legacy_ArrayOfInt');
		$this->addType('Legacy_ArrayOfString');
	
		$this->addFunction(S_PUBLIC_FUNC('Legacy_SearchItemArray searchItems(int mid, Legacy_ArrayOfString queries, string andor, int maxhit, int start)'));
		$this->addFunction(S_PUBLIC_FUNC('Legacy_SearchItemArray searchItemsOfUser(int mid, int uid, int maxhit, int start)'));
		$this->addFunction(S_PUBLIC_FUNC('Legacy_SearchModuleArray getActiveModules()'));
	}
	
	function getActiveModules(&$user, $params)
	{
		//
		// At first, get active module IDs.
		//
		$handler =& xoops_gethandler('module');
		
		$criteria =& new CriteriaCompo();
		$criteria->add(new Criteria('isactive', 1));
		$criteria->add(new Criteria('hassearch', 1));
		$moduleArr =& $handler->getObjects($criteria);


		$handler =& xoops_gethandler('groupperm');
		$groupArr = Legacy_SearchUtils::getUserGroups($user);

		$ret = array();
		foreach ($moduleArr as $module) {
			if ($handler->checkRight('module_read', $module->get('mid'), $groupArr)) {
				$ret[] = array(
					'mid' => $module->get('mid'),
					'name' => $module->get('name')
				);
			}
		}
		
		return $ret;
	}
	
	function searchItems(&$user, $params)
	{
		//
		// TODO Need validation
		//
		
		$ret = $this->_searchItems($user, intval($params['mid']), $params['queries'], $params['andor'], $params['maxhit'], $params['start'], 0);
		
		return $ret;
	}
	
	function searchItemsOfUser(&$user, $params)
	{
		//
		// TODO Need validation
		//
		
		$ret = $this->_searchItems($user, intval($params['mid']), null, 'and', intval($params['maxhit']), intval($params['start']), intval($params['uid']));
		
		return $ret;
	}
	
	/**
	 * @access private
	 */
	function _searchItems(&$user, $mid, $queries, $andor, $max_hit, $start, $uid)
	{
		$ret = array();
		
		$modleArr = $this->getActiveModules($user, array());
		
		$flag = false;
		foreach ($modleArr as $module) {
			if ($mid == $module['mid']) {
				$flag = true;
				break;
			}
		}
		
		if (!$flag) {
			return $ret;
		}
		
		$root =& XCube_Root::getSingleton();
		$timezone = $root->mController->getConfig('server_TZ') * 3600;

		$handler =& xoops_gethandler('module');
		$module =& $handler->get($mid);
		if (!is_object($module)) {
			return $ret;
		}
		
		if (!$module->get('isactive') || !$module->get('hassearch')) {
			return $ret;
		}

		$results =& $module->search($queries, $andor, $max_hit, $start, $uid);
				
		if (is_array($results) && count($results) > 0) {
			foreach ($results as $result) {
				$item = array();
				if (isset($result['image']) && strlen($result['image']) > 0) {
					$item['image'] = XOOPS_URL . '/modules/' . $module->get('dirname') . '/' . $result['image'];
				}
				else {
					$item['image'] = XOOPS_URL . '/images/icons/posticon2.gif';
				}
						
				$item['link'] = XOOPS_URL . '/modules/' . $module->get('dirname') . '/' . $result['link'];
				$item['title'] = $result['title'];
				$item['uid'] = $result['uid'];
						
				//
				// TODO If this service will come to web service, we should
				// change format from unixtime to string by timeoffset.
				//
				$item['time'] = isset($result['time']) ? $result['time'] - $timezone : 0;
				
				$ret[] = $item;
			}
		}
		
		return $ret;
	}
}

class Legacy_SearchUtils
{
	function getUserGroups(&$user)
	{
		$groups = array();
		
		
		if ($user->isService() || $user->isGuest()) {
			$groups = XOOPS_GROUP_ANONYMOUS;
		}
		else {
			$userHandler =& xoops_gethandler('user');
			$currentUser =& $userHandler->get($user->_mId);	//< FIXME
		
			$groups = is_object($currentUser) ? $currentUser->getGroups() : XOOPS_GROUP_ANONYMOUS;
		
			return $groups;
		}
		
		return $groups;
	}
}

?>