<?php
/**
 * @package XCube
 * @version $Id: XCube_Service.class.php,v 1.1.2.5 2006/07/13 13:12:42 nobunobu Exp $
 */

/**
 * *An experiment class*
 * This class defines function communication between modules.
 * This class conceals real processes.
 */
class XCube_Service
{
	var $mOperations = array();
	var $mErrorStr = null;

	function XCube_Service()
	{
	}
	
	function prepare()
	{
	}

	function register($name, $in=false, $out=false)
	{
		$this->mOperations[$name] = array(
			"name" => $name,
			"in" => $in,
			"out" => $out
		);
	}
	
	function setError($message)
	{
		$this->mErrorStr = $message;
	}

	/**
	 * Return public URL of WSDL. If the public service doesn't exist, return
	 * null.
	 * 
	 * @return string
	 */
	function getWSDLUrl()
	{
		return null;
	}
	
	/**
	 * If this instance is outer web service, return true.
	 * 
	 * @return bool
	 */	
	function isOuterService()
	{
		return false;
	}
}

/**
 * *An experiment class*
 * This class is the adapter of a service class.
 * I give a caller the interface that resembled NUSOAP.
 */
class XCube_AbstractServiceClient
{
	var $mService;
	var $mClientErrorStr;

	function XCube_AbstractServiceClient(&$service)
	{
		$this->mService =& $service;
	}

	function call()
	{
	}
	
	function getOperationData($operation)
	{
	}

	function setError($message)
	{
		$this->mClientErrorStr=$message;
	}

	function getError()
	{
		return !empty($this->mClientErrorStr) ? $this->mClientErrorStr : $this->mService->mErrorStr;
	}
}

class XCube_ServiceClient extends XCube_AbstractServiceClient
{
	function call()
	{
		$this->mClientErrorStr = null;
		
		if(!is_object($this->mService)) {
			$this->mClientErrorStr = "This instance is not connected to service";
			return null;
		}
		
		$args = func_get_args();
		$operation = array_shift($args);
		
		if (isset($this->mService->mOperations[$operation])) {
			$callback = null;
			if (strstr($operation, ".") !== false) {
				$tmp = explode(".", $operation);
				$callback = array($tmp[0], $tmp[1]);
			}
			else {
				$callback = array($this->mService, $operation);
			}

			return call_user_func_array($callback, $args);
		}
		else {
			$this->mClientErrorStr = "operation $operation not present.";
			return null;
		}
	}
}

?>