<?php
/**
 * @version
 */

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_BASE_PATH."/admin/class/ModuleUtils.class.php";

/**
 * This is a abstract class for the process of install, update and uninstall.
 */
class Legacy_AbstractModuleInstaller
{
	/**
	 * @var XCube_Delegate
	 */
	var $mProcessScript = null;
	
	/**
	 * Install or uninstall templates of this target module, this function is
	 * called by own execute().
	 *
	 * @var XCube_Delegate
	 */
	var $mInstallTemplate = null;
	
	/**
	 * Create or drop tables, this function is called by own execute().
	 * 
	 * @var XCube_Delegate
	 */
	var $mInstallTable = null;
	
	var $mDirname = null;

	/**
	 * XoopsModule
	 */
	var $mModule = null;

	/**
	 * Legacy_ModuleUtilsSimpleLog
	 */
	var $mLog = null;

	/**
	 * If this flag is true, never stop processing.
	 */
	var $mForceMode = false;

	function Legacy_AbstractModuleInstaller($dirname)
	{
		$this->mDirname = $dirname;
		$this->mLog =& new Legacy_ModuleUtilsSimpleLog();
		
		//
		// Load message catalog for the required module installer of 'common'
		// process.
		//
		$root =& XCube_Root::getSingleton();
		if (is_object($root->mLanguageManager)) {
			$root->mLanguageManager->loadModuleAdminMessageCatalog('base');
		}
		
		$this->mProcessScript =& new XCube_Delegate();
		$this->mInstallTable =& new XCube_Delegate();
		$this->mInstallTemplate =& new XCube_Delegate();
	}
	
	/**
	 * Start callback to required member functions with module install
	 * framework.
	 * 
	 * @return bool
	 */
	function execute()
	{
		$this->mModule =& $this->loadModuleObject($this->mDirname);
		
		if (!is_object($this->mModule)) {
			$this->_processReport();
			return false;
		}

		$this->mInstallTable->call(new XCube_Ref($this->mModule), new XCube_Ref($this->mLog));
		if (!$this->mForceMode && $this->mLog->hasError()) {
			$this->_processReport();
			return false;
		}

		$this->_installModule();
		if (!$this->mForceMode && $this->mLog->hasError()) {
			$this->_processReport();
			return false;
		}

		$this->mInstallTemplate->call(new XCube_Ref($this->mModule), new XCube_Ref($this->mLog));
		if (!$this->mForceMode && $this->mLog->hasError()) {
			$this->_processReport();
			return false;
		}

		$this->_installBlock();
		if (!$this->mForceMode && $this->mLog->hasError()) {
			$this->_processReport();
			return false;
		}
		
		$this->_installNotification();
		if (!$this->mForceMode && $this->mLog->hasError()) {
			$this->_processReport();
			return false;
		}

		$this->_installPreference();
		if (!$this->mForceMode && $this->mLog->hasError()) {
			$this->_processReport();
			return false;
		}
		
		$this->mProcessScript->call(new XCube_Ref($this->mModule), new XCube_Ref($this->mLog));
		
		$this->_processReport();
		
		return true;
	}

	/**
	 * Load xoops module object and return it.
	 * @static
	 * @access public
	 * @param $dirname string
	 * @return XoopsModule
	 */
	function &loadModuleObject($dirname)
	{
	}

	function _installModule()
	{
		$moduleHandler =& xoops_gethandler('module');
		if (!$moduleHandler->insert($this->mModule)) {
			$this->mLog->addError("*Could not install module information*");
			return false;
		}

		return true;
	}

	/**
	 * Install or uninstall blocks and their templates, this function is called by own execute().
	 */
	function _installBlock()
	{
	}
	
	/**
	 * Install or uninstall notifications, this member function is called by
	 * own execute().
	 * 
	 * @access protected
	 */
	function _installNotification()
	{
	}
	
	/**
	 * Install or uninstall blocks and their preference, this function is called by own execute().
	 */
	function _installPreference()
	{
	}

	/**
	 * If set true, this class may never stop for error.
	 */
	function setForceMode($flag)
	{
		$this->mForceMode = $flag;
	}

	/**
	 * This member function is called back at the last part of execute().
	 * Report the conclusion to the log.
	 */	
	function _processReport()
	{
	}
	
	/**
	 * Return log instance.
	 */
	function &getLog()
	{
		return $this->mLog;
	}
	
	function hasAgree()
	{
		return false;
	}
}

?>